create or replace FUNCTION load_user_role_mapping()  	
RETURNS void AS
$BODY$
declare 
desig varchar(100); 
rolename varchar(100);
user_name varchar(100);
srl numeric;
userid numeric default 0;
roleid numeric default 0;
isUserRoleMappingExist boolean default false;
cur_emp tmp_employee%ROWTYPE;
cur_role tmp_designation_rolemapping%ROWTYPE;
begin
for cur_emp in( select * from tmp_employee where status='Updated' order by srlno)
loop
begin
desig:=upper(cur_emp.designation);
srl:=cur_emp.srlno;
user_name:=cur_emp.username;

RAISE NOTICE 'Processing for User %',user_name;
select id into userid from eg_user where username=user_name;
if
(userid=null) then
update tmp_employee set roleupdatestatus='Cannot identify the user' where srlno=srl;
end if;

for cur_role in(select * from tmp_designation_rolemapping where upper(designation)=upper(desig))
loop
begin
rolename:=cur_role.role;

RAISE NOTICE 'Designation for user is  %',desig;
RAISE NOTICE 'Role Name for Designation is  %',rolename;
if(rolename is NULL) then
--RAISE NOTICE 'Coming inside NULL block';
update tmp_employee set roleupdatestatus='Designation to role mapping not present' where srlno=srl;
else
select id into roleid from eg_role where upper(name)=upper(rolename);
RAISE NOTICE 'Role id is  %',roleid;
if(roleid is NULL) then
update tmp_employee set roleupdatestatus='Role Name defined for Designation does not exist in the role master' where srlno=srl;
end if;
end if;

if(roleid>0 and userid>0)  then
----check if the data already exist
isUserRoleMappingExist:=userrole_mapping_exist(roleid,userid);

if(isUserRoleMappingExist=false) then
insert into eg_userrole(roleid,userid) values(roleid,userid);
update tmp_employee set roleupdatestatus='Updated' where srlno=srl;
else
update tmp_employee set roleupdatestatus='Mapping already exist' where srlno=srl;
end if;

end if;

end;
end loop;
if(rolename is NULL) then
--RAISE NOTICE 'Coming inside NULL block';
update tmp_employee set roleupdatestatus='Designation to role mapping not present' where srlno=srl;
end if;
end;


end loop;

end ;
$BODY$
LANGUAGE plpgsql;	

------------------------------------------
create or replace function userrole_mapping_exist(vroleid numeric,vuserid numeric) returns boolean as 
$BODY$
declare isexist boolean default true;
begin
--PERFORM id from eg_department dept where upper(dept.name)=upper(deptName);
PERFORM roleid from eg_userrole where roleid=vroleid and userid=vuserid;
IF NOT FOUND THEN
RAISE NOTICE 'Inside User Role checking- DOES NOT EXIST %',vroleid;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;
----------------------------------------------

-----------------Additional Role to designation mapping for Water Tax -----------------------
insert into  tmp_designation_rolemapping (srlno,designation,role) values(50,'Assistant Engineer','Water Tax Approver');
insert into  tmp_designation_rolemapping (srlno,designation,role) values(52,'Commissioner','Property Administrator');
------------------------------------------------------------------------------------------------

------------Calling procedure to load the user role mapping for addional mappings
select load_user_role_mapping();
-----------------------------------------