
------------------------Department Master--------------------
------*** Temporary Table ***-----------------
drop table tmp_department;
create table tmp_department(
srlno numeric,
name varchar(200),
code varchar(2)
);

---------------------------------------------
------------*** Procedure for department data load ***-----------
create or replace FUNCTION load_department() 
RETURNS void AS 
$BODY$
declare 
dep_code varchar(2); 
dept_name varchar(200);
isDepartmentExist boolean default false;
cur_dept tmp_department%ROWTYPE;
begin
for cur_dept in( select * from tmp_department)
loop
begin
dep_code:=upper(cur_dept.code);
dept_name:=upper(cur_dept.name);
isDepartmentExist:=department_exist(dept_name);
if(isDepartmentExist=false) then
insert into eg_department(id,name,createddate,code,createdby,lastmodifiedby,lastmodifieddate,version)
values(nextval('seq_eg_department'),dept_name,current_date,dep_code,1,1,current_date,0);
end if;
end;
RAISE NOTICE 'Inside Dept is %',dep_code;

end loop;

RAISE NOTICE 'Completed %',dep_code;
end ;
$BODY$
LANGUAGE plpgsql;	

-----------------------------------------
create or replace function department_exist(deptName in character varying) returns boolean as 
$BODY$
declare isexist boolean default true;
begin
PERFORM id from eg_department dept where upper(dept.name)=upper(deptName);
IF NOT FOUND THEN
RAISE NOTICE 'Inside Department exit checking- DOES NOT EXIST %',deptName;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;

-----------------------------------------------------------------------
---- Load data to tmp_department
---select load_department();
------------------------Designation Mater ----------------------------
---------------------*** Temporary Table ***----------------------
drop table tmp_designation;
create table tmp_designation(
srlno numeric primary key,
name varchar(200),
department varchar(200),
post numeric,
status varchar(1000)
);


----------- ** Procedure for deignation data load ***-----------------------------

create or replace FUNCTION load_designation() 
RETURNS void AS 
$BODY$
declare 
desig_name varchar(200); 
dept_name varchar(200);
isExist boolean default true;
isDepDesigExist boolean default true;
isDepartmentExist boolean default true;
postCount bigint;
srl bigint;
cur_desig tmp_designation%ROWTYPE;
begin
for cur_desig in( select * from tmp_designation order by srlno)
loop
begin
desig_name:=upper(cur_desig.name);
dept_name:=upper(cur_desig.department);
postCount:=cur_desig.post;
srl:=cur_desig.srlno;

RAISE NOTICE 'Inside Designation is %',desig_name;
isExist:=designation_exist(desig_name);
isDepartmentExist:=department_exist(dept_name);

if(isExist=false) then

if(isDepartmentExist=true) then

insert into eg_designation(id,name,description,version,createddate,lastmodifieddate,createdby,lastmodifiedby)
values(nextval('seq_eg_designation'),desig_name,desig_name,0,current_date,current_date,1,1);

insert into egeis_deptdesig (id,designation,department,sanctionedposts,version,createddate,lastmodifieddate,createdby,lastmodifiedby)
values(nextval('seq_egeis_deptdesig'),(select id from eg_designation where upper(name)=upper(desig_name)),(select id from eg_department where upper(name)=upper(dept_name)),postCount,1,current_date,current_date,1,1);
update tmp_designation set status='updated' where srlno=srl;

else
RAISE NOTICE 'Department master data is missing so cannot load to deptdesig table %',dept_name;
update tmp_designation set status='Department master data is missing so cannot load to deptdesig table' where srlno=srl;
end if;
else
RAISE NOTICE 'Designation already exist...now add mapping after checking%',desig_name;
isDepDesigExist:=deptdesig_exist(desig_name,dept_name);

if(isDepDesigExist=false) then
RAISE NOTICE 'Designation-DEPT mapping missing so add%',dept_name;
if(isDepartmentExist=true) then
insert into egeis_deptdesig (id,designation,department,sanctionedposts,version,createddate,lastmodifieddate,createdby,lastmodifiedby)
values(nextval('seq_egeis_deptdesig'),(select id from eg_designation where upper(name)=upper(desig_name)),(select id from eg_department where upper(name)=upper(dept_name)),postCount,1,current_date,current_date,1,1);
update tmp_designation set status='updated' where srlno=srl;

else
RAISE NOTICE 'Department master data is missing so cannot load to deptdesig table %',dept_name;
update tmp_designation set status='Department master data is missing so cannot load to deptdesig table' where srlno=srl;
end if;
else
RAISE NOTICE 'Data already exist so no need to load %',dept_name;
update tmp_designation set status='Data already exist so no need to load' where srlno=srl;

end if;
end if;
end;

end loop;

RAISE NOTICE 'Completed %',desig_name;
end ;
$BODY$
LANGUAGE plpgsql;


create or replace function designation_exist(desgName in character varying) returns boolean as 
$BODY$
declare isexist boolean default true;
begin
PERFORM id from eg_designation des where upper(des.name)=upper(desgName);
IF NOT FOUND THEN
RAISE NOTICE 'Inside Designation exit checking- DOES NOT EXIST %',desgName;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;

-------------------------

create or replace function deptdesig_exist(desgName in character varying,deptName in character varying) returns boolean as 
$BODY$
declare isexist boolean default true;
begin
PERFORM id from egeis_deptdesig des where designation in(select id from eg_designation where upper(name)=upper(desgName))
and department in(select id from eg_department where upper(name)=upper(deptName));
IF NOT FOUND THEN
RAISE NOTICE 'Inside DEPT-Designation exit checking- DOES NOT EXIST %',desgName;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;
-----------------------------------------------------------------------------------------------
---Load data to tmp_designation
--select load_designation();


---------------------------Employee Master-----------------------
--------------*** Temporary Table ***-------------------------------
drop table tmp_employee;
create table tmp_employee(
srlno numeric primary key,
code varchar(10),
name varchar(100),
gender char(1),
department varchar(100),
designation varchar(100),
mobile varchar(10),
status varchar(1000),
username varchar(50),
roleupdatestatus varchar(1000)
);
------------------------------------------------------------------------
--------------------*** Data Load Procedure ***-------------------------

create or replace FUNCTION load_employee() 
RETURNS void AS
$BODY$
declare
desig_name varchar(100); 
dept_name varchar(100);
emp_code varchar(10);
emp_name varchar(100);
emp_gender varchar(1);
emp_gender_num smallint;
emp_mobile varchar(10);
username varchar(50);
isDepartmentExist boolean default false;
isDesignationExist  boolean default false;
isEmployeeCodeUnique boolean default true;
isUserNameUnique boolean default true;
isDeptDesignationExist  boolean default true;
srl bigint;
user_seq bigint;
pos_seq bigint;
dept_code varchar(3);
deptdesig_id bigint default 0;
max_position smallint;
cur_emp tmp_employee%ROWTYPE;

begin
RAISE NOTICE 'Inside Employee data load';
for cur_emp in( select * from tmp_employee where status is null or status <>'Updated' order by srlno)
loop
begin
emp_name:=cur_emp.name;
emp_code:=cur_emp.code;
desig_name:=cur_emp.designation;
dept_name:=cur_emp.department;
srl:=cur_emp.srlno;
emp_gender:=cur_emp.gender;
emp_mobile:=cur_emp.mobile;
username=cur_emp.username;
RAISE NOTICE 'Employee data for code %',emp_code;
isDepartmentExist:=department_exist(dept_name);
isDesignationExist:=designation_exist(desig_name);
isEmployeeCodeUnique :=employee_code_unique(emp_code);
isUserNameUnique:=username_unique(username);

if(isDepartmentExist=false) then
RAISE NOTICE 'Department does not exist %',dept_name;
update tmp_employee set status ='Department does not exist' where srlno=srl;
end if;
if(isDesignationExist=false) then
RAISE NOTICE 'Designation does not exist %',desig_name;
update tmp_employee set status ='Designation does not exist' where srlno=srl;
end if;
if(isEmployeeCodeUnique=false) then
RAISE NOTICE 'Employee Code already exist %',emp_code;
update tmp_employee set status ='Employee Code already exist' where srlno=srl;
end if;
if(isUserNameUnique=false) then
RAISE NOTICE 'User Name already exist %',username;
update tmp_employee set status ='User Name already exist' where srlno=srl;
end if;

if(isDepartmentExist=true and isDesignationExist=true and isEmployeeCodeUnique=true and isUserNameUnique=true) then
RAISE NOTICE 'Ready for Employee data load';
---Load to user table
select nextval('seq_eg_user') into user_seq;

if(upper(emp_gender)='M') then
emp_gender_num:=1;
else
emp_gender_num:=0;
end if;
insert into eg_user(id,locale,username,password,pwdexpirydate,mobilenumber,createddate,lastmodifieddate,createdby,
lastmodifiedby,active,name,gender,type,version)
values(user_seq,'en_IN',username,
'$2a$10$uheIOutTnD33x7CDqac1zOL8DMiuz7mWplToPgcf7oxAI9OzRKxmK','01-Jan-2099',emp_mobile,
current_date,current_date,1,1,true,emp_name,emp_gender_num,'EMPLOYEE',0);
RAISE NOTICE 'After loading User...';
--------------Load to eg_employee
insert into egeis_employee(id,code,employeestatus,employeetype,version) values(user_seq,emp_code,'EMPLOYED',(select id from egeis_employeetype where name='Permanent'),0);
RAISE NOTICE 'After loading Employee';
-----------Load to Position
select nextval('seq_eg_position') into pos_seq;
select code into dept_code from eg_department where upper(name)=upper(dept_name);

---If deptdesig not there then we need to insert one row
isDeptDesignationExist:=deptdesig_exist(desig_name,dept_name);
RAISE NOTICE 'DEPT-DESIG EXISTS ***** %',isDeptDesignationExist;

if(isDeptDesignationExist=false) then
--select nextval('seq_egeis_deptdesig') into deptdesig_id;
insert into egeis_deptdesig (id,designation,department,sanctionedposts,version,createddate,lastmodifieddate,createdby,lastmodifiedby)
values(nextval('seq_egeis_deptdesig'),(select id from eg_designation where upper(name)=upper(desig_name)),(select id from eg_department where upper(name)=upper(dept_name)),1,1,current_date,current_date,1,1);
RAISE NOTICE 'Inserted to DEpt-Desig %',desig_name;
end if;

select id into deptdesig_id from egeis_deptdesig des where designation in(select id from eg_designation where upper(name)=upper(desig_name))
and department in(select id from eg_department where upper(name)=upper(dept_name));

select count(id) into max_position from eg_position where deptdesig=deptdesig_id;

insert into eg_position(name,id,deptdesig,createddate,lastmodifieddate,createdby,lastmodifiedby,ispostoutsourced,version)
values(dept_code||'_'||desig_name||'_'||max_position+1,pos_seq,deptdesig_id,current_date,current_date,1,1,false,0);
----------Update Dept-Desig for number of post--------
--update egeis_deptdesig set sanctionedposts=sanctionedposts+1 where id=deptdesig_id;

----------Load to assignment---------
insert into egeis_assignment (id,designation,department,position,grade,lastmodifiedby,lastmodifieddate,
createddate,createdby,fromdate,todate,version,isprimary,employee)
values(nextval('seq_egeis_assignment'),(select id from eg_designation where upper(name)=upper(desig_name)),
(select id from eg_department where upper(name)=upper(dept_name)),pos_seq,(select grade_id from egeis_grade_mstr where grade_value='A'),
1,current_date,current_date,1,'01-Apr-2015','31-Mar-2017',0,true,user_seq);

---Update employee to jurisdiction as City-----------------
insert into egeis_jurisdiction (id,employee,boundarytype,createddate,lastmodifieddate,createdby,lastmodifiedby,version,boundary)
values(nextval('seq_egeis_jurisdiction'),user_seq,(select id from eg_boundary_type where upper(name)=upper('City') 
and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION')),current_date,current_date,1,1,0,(select id from eg_boundary where boundarytype =(select id from eg_boundary_type where upper(name)=upper('City') 
and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION'))));

------------Update the user role for this employee as EMPLOYEE
insert into eg_userrole(roleid,userid) values((select id from eg_role where upper(name)='EMPLOYEE'),user_seq);
---------------Update temp table---------------------
update tmp_employee set status ='Updated' where srlno=srl;
end if;
end;
 end loop;
end;
$BODY$
LANGUAGE plpgsql;	

create or replace function employee_code_unique(empCode in character varying) returns boolean as 
$BODY$
declare isexist boolean default false;
begin
PERFORM id from egeis_employee where upper(code)=upper(empCode);
IF NOT FOUND THEN
RAISE NOTICE 'Inside Employee Code Unique checking %',empCode;
isexist:=true;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;

create or replace function username_unique(empUsername in character varying) returns boolean as 
$BODY$
declare isexist boolean default false;
begin
PERFORM id from eg_user where upper(username)=upper(empUsername);
IF NOT FOUND THEN
RAISE NOTICE 'Inside User name Unique checking %',empUsername;
isexist:=true;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;

---------------------------
---load data to tmp_employee
--select  load_employee();

--------------------***	Load User-Jurisdiction ***----------------
-----------------Temporary Table ----------------
drop table tmp_employee_jurisdiction;
create table tmp_employee_jurisdiction
(srlno numeric primary key,
employeecode varchar(10),
boundarytype varchar(20),
boundarynum bigint,
status varchar(1000)
);

----------------------------------------
------------------------Data load procedure -------------------
create or replace function employee_exist(empCode in character varying) returns boolean as 
$BODY$
declare isexist boolean default true;
begin
PERFORM id from egeis_employee where upper(code)=upper(empCode);
IF NOT FOUND THEN
RAISE NOTICE 'Inside Employee Code Unique checking %',empCode;
isexist:=false;
END IF;
return isexist;
end;
$BODY$
LANGUAGE plpgsql;


create or replace FUNCTION load_employee_jurisdiction() 
RETURNS void AS 
$BODY$
declare
isEmployeeExist boolean default true;
emp_code varchar(20);
bndry_type varchar(20);
bndry_typeid bigint default 0;
bndry_num bigint;
bndry_numid bigint default 0;
srl smallint;
cur_empjur tmp_employee_jurisdiction%ROWTYPE;
begin

for cur_empjur in( select * from tmp_employee_jurisdiction where status is null or status <>'Updated' order by srlno)
loop
begin
emp_code:=cur_empjur.employeecode;
srl:=cur_empjur.srlno;
bndry_type:=cur_empjur.boundarytype;
bndry_num:=cur_empjur.boundarynum;

RAISE NOTICE 'Inside load_employee_jurisdiction %',emp_code;
----------Checking if Employee Exist-------
isEmployeeExist :=employee_exist(emp_code);
if(isEmployeeExist=false) then
update tmp_employee_jurisdiction set status ='Employee Does not exist' where srlno=srl;
end if;

-------------Checking if Boundary type is correct
select id into bndry_typeid from eg_boundary_type where upper(name)=upper(bndry_type) 
and hierarchytype in(select id from eg_hierarchy_type where upper(name)='ADMINISTRATION');
IF NOT FOUND THEN
RAISE NOTICE 'NO BOUNDARY TYPE %',bndry_type;
update tmp_employee_jurisdiction set status ='NO BOUNDARY TYPE DEFINED' where srlno=srl;
bndry_typeid:=0;
END IF;

--------------Checking if Boundary Value exist
if(bndry_typeid>0) then
select id into bndry_numid from eg_boundary where boundarynum=bndry_num and boundarytype=bndry_typeid;
IF NOT FOUND THEN
RAISE NOTICE 'NO BOUNDARY VALUE %',bndry_num;
update tmp_employee_jurisdiction set status ='NO BOUNDARY DEFINED FOR THE CORRESPONDING TYPE' where srlno=srl;
bndry_numid:=0;
END IF;
END IF;

--------------------If all above conditions are fine load the jurisdiction
if(isEmployeeExist=true and bndry_typeid>0 and bndry_numid>0) then
insert into egeis_jurisdiction (id,employee,boundarytype,createddate,lastmodifieddate,createdby,lastmodifiedby,version,boundary)
values(nextval('seq_egeis_jurisdiction'),(select id from egeis_employee where upper(code)=upper(emp_code)),
bndry_typeid,current_date,current_date,1,1,0,bndry_numid);
update tmp_employee_jurisdiction set status ='Updated' where srlno=srl;

END IF;
end;
end loop;
end;
$BODY$
LANGUAGE plpgsql;
---------------------------------------------------------------------------------
--- Load data to tmp_employee_jurisdiction
-----select load_employee_jurisdiction();

---------------------------------------------
----------------*** Procedure to load the user role mapping using the designation to role mapping ***-----------

------------Temporary table ------------
create table tmp_designation_rolemapping
(srlno numeric primary key,
designation varchar(100),
role varchar(100)
);
---------------------------------

/*
Sample insert scripts
insert into  tmp_designation_rolemapping (srlno,designation,role) values(1,'Revenue officer','Grievance Officer');
insert into  tmp_designation_rolemapping (srlno,designation,role) values(2,'Assistant','Redressal Officer');

*/

-------------------Data 
create or replace FUNCTION load_user_role_mapping()  	
RETURNS void AS
$BODY$
declare 
desig varchar(100); 
rolename varchar(100);
user_name varchar(100);
srl numeric;
userid numeric default 0;
roleid numeric default 0;
cur_emp tmp_employee%ROWTYPE;
cur_role tmp_designation_rolemapping%ROWTYPE;
begin
for cur_emp in( select * from tmp_employee where status='Updated' and (roleupdatestatus<>'Updated' or roleupdatestatus is null) order by srlno)
loop
begin
desig:=upper(cur_emp.designation);
srl:=cur_emp.srlno;
user_name:=cur_emp.username;

RAISE NOTICE 'Processing for User %',user_name;
select id into userid from eg_user where username=user_name;
if
(userid=null) then
update tmp_employee set roleupdatestatus='Cannot identify the user' where srlno=srl;
end if;

for cur_role in(select * from tmp_designation_rolemapping where upper(designation)=upper(desig))
loop
begin
rolename:=cur_role.role;

RAISE NOTICE 'Designation for user is  %',desig;
RAISE NOTICE 'Role Name for Designation is  %',rolename;
if(rolename is NULL) then
--RAISE NOTICE 'Coming inside NULL block';
update tmp_employee set roleupdatestatus='Designation to role mapping not present' where srlno=srl;
else
select id into roleid from eg_role where upper(name)=upper(rolename);
RAISE NOTICE 'Role id is  %',roleid;
if(roleid is NULL) then
update tmp_employee set roleupdatestatus='Role Name defined for Designation does not exist in the role master' where srlno=srl;
end if;
end if;

if(roleid>0 and userid>0)  then
insert into eg_userrole(roleid,userid) values(roleid,userid);
update tmp_employee set roleupdatestatus='Updated' where srlno=srl;
end if;

end;
end loop;
if(rolename is NULL) then
--RAISE NOTICE 'Coming inside NULL block';
update tmp_employee set roleupdatestatus='Designation to role mapping not present' where srlno=srl;
end if;
end;


end loop;

end ;
$BODY$
LANGUAGE plpgsql;	

---------------------------------------------------------------------------


