--migrateAssmtWardWise
CREATE OR REPLACE FUNCTION migrateAssmtWardWise()
RETURNS void AS
$BODY$
DECLARE
	wards RECORD;
	v_temp integer;
BEGIN
	for wards in (select i_rwobjid from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) group by i_rwobjid)
	loop 
		begin
			--raise notice 'migrateAssmtWardWise : Started for Ward (%)', wards.i_rwobjid;
			v_temp  := migrateassessmtWard(wards.i_rwobjid);
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateAssmtWardWise : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;


--resetAsmtNoSequence
CREATE OR REPLACE FUNCTION resetAsmtNoSequence()
RETURNS void AS
$BODY$
DECLARE
	v_asmtsequence integer;
	v_tmp integer default 0;
BEGIN
	select cast(substr(cast(max(i_asmtno) as text),5, length(cast(max(i_asmtno) as text))) as integer) into v_asmtsequence from pt_asmt_mstr_tbl;
	raise notice 'resetAsmtNoSequence : v_asmtsequence (%)', v_asmtsequence;
	v_tmp := setval('seq_egpt_assessment_number', v_asmtsequence, true);
END;
$BODY$ LANGUAGE plpgsql;

--genMaterializedPath
CREATE OR REPLACE FUNCTION genMaterializedPath()
RETURNS void AS
$BODY$
DECLARE
	boundaries eg_boundary%ROWTYPE;
	v_bndryid integer;
	v_parentbndryid integer;
	v_parent integer;
	v_parent1 integer;
	v_parent2 integer;
	v_boundarynum integer;
	v_parent1bndrynum integer;
	v_parent2bndrynum integer;
	v_matpath varchar(16);
	v_tmp integer default 0;
BEGIN
	--update eg_boundary set materializedpath=boundarynum where boundarytype in (select id from eg_boundary_type where name='City');
	for boundaries in (select * from eg_boundary)
	loop
		v_matpath := '';
		v_bndryid := boundaries.id;
		v_parent := boundaries.parent;
		v_boundarynum := boundaries.boundarynum;
		--raise notice 'genMaterializedPath v_bndryid, v_parent, v_boundarynum : % % %', v_bndryid, v_parent, v_boundarynum;
		if(v_parent is null) then
			update eg_boundary set materializedpath=boundarynum where id=v_bndryid;
		else
			select parent, boundarynum into v_parent1, v_parent1bndrynum from eg_boundary where id=v_parent;
		    --raise notice 'genMaterializedPath v_parent1, v_parent1bndrynum : % %', v_parent1, v_parent1bndrynum;
			if(v_parent1 is null) then
				v_matpath := v_parent1bndrynum||'.'||v_boundarynum;
				--raise notice 'genMaterializedPath v_matpath : %', v_matpath;
			else
				select parent, boundarynum into v_parent2, v_parent2bndrynum from eg_boundary where id=v_parent1;
				v_matpath := v_parent2bndrynum||'.'||v_parent1bndrynum||'.'||v_boundarynum;
		   		--raise notice 'genMaterializedPath v_matpath, v_parent2, v_parent2bndrynum : % % %', v_matpath, v_parent2, v_parent2bndrynum;
			end if;
			--raise notice 'genMaterializedPath v_matpath : %', v_matpath;
			update eg_boundary set materializedpath=v_matpath where id=v_bndryid;
		end if;
	end loop;
END;
$BODY$ LANGUAGE plpgsql;
