--createBasicprop
DROP FUNCTION createbasicprop(integer,bigint,bigint,integer,character);
create or replace FUNCTION createBasicprop(assessmentNo IN integer, addressid bigint, id_propertyid bigint, eleWard IN integer, isactive IN character)  
RETURNS numeric as $$
declare
	v_basicpk 	bigint;  
BEGIN 
	--raise notice 'createBasicprop assessmentNo, addressid, idBasicProp, id_propertyid, eleWard, isactive (% % % % % %)',assessmentNo, addressid, idBasicProp, id_propertyid, eleWard, isactive;
	select nextval('seq_egpt_basic_property') into v_basicpk;
INSERT INTO egpt_basic_property(id, createdby, propertyid, isactive, addressid, createddate, lastmodifieddate, id_propertyid, municiapl_no_old, id_adm_bndry, id_prop_create_reason, prop_occupancy_date, status, modifiedby, vl_assessmentno, regd_doc_no, regd_doc_date, assessmentdate, source)
	select v_basicpk, 1, i_asmtno, (CASE WHEN isactive = 'N' THEN TRUE ELSE FALSE END), addressid, dt_taxassddt, dt_taxassddt, id_propertyid, vc_oldasmtno, (select egovcode from eg_stg_election where code=eleWard), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, (select id from egpt_status where code='ASSESSED'), 1, i_vcntlndasmtno, vc_rgtddocno, dt_rgtddocdt, dt_taxassddt, 'M' from pt_asmt_mstr_tbl where i_asmtno=assessmentNo;
	--raise notice 'createBasicprop basicproperty created';
return v_basicpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createBasicprop : % %', SQLERRM, SQLSTATE;
END; 
$$ LANGUAGE plpgsql;

--migrateSingleAssess
CREATE OR REPLACE FUNCTION migrateSingleAssess(assessmentNo IN integer, idsource IN bigint, currinst IN bigint, currinstdesc IN varchar(16), idModule IN bigint)
RETURNS bigint AS
$BODY$
DECLARE

v_idinstall bigint;
v_addressid bigint;
v_idpropid bigint;
v_idowner bigint;
v_idbasic bigint;
v_idprop bigint;
v_idpropdet bigint;
v_idfloor bigint;
v_idownerlk bigint;
v_iddmd bigint;
v_iddmdcalc bigint;
v_houseno varchar(32);
v_zone int;
v_ward int;
v_block int;
v_locality int;
v_eward int;
v_street int;
v_assmtdate date;
v_corraddr1 varchar(32); 
v_corraddr2 varchar(32);
v_isExempted character;
v_arv double precision;
v_totaltax double precision;
v_exemptionReason integer;
v_delflag character;
BEGIN
	begin
		--raise notice 'migrateSingleAssess : Started for assessment no (% % % % %)', assessmentNo, idsource, currinst, currinstdesc, idModule;
		select asmtmstr.vc_onrdoorno, asmtmstr.i_zoneobjid, asmtmstr.i_rwobjid, asmtmstr.i_blckobjid, asmtmstr.i_lctyobjid, asmtmstr.i_strtobjid, asmtmstr.i_ewobjid, asmtmstr.dt_taxassddt, asmtmstr.vc_onraddr1, asmtmstr.vc_onraddr2, asmtmstr.c_xptn, asmtmstr.i_xptnpcode, asmtmstr.d_fxdarv, (coalesce(asmtmstr.d_fxdpt,0)+coalesce(asmtmstr.d_fxded,0)+coalesce(asmtmstr.d_fxdlcs,0)+coalesce(asmtmstr.d_fxdunauthplnplty,0)), asmtmstr.c_delflag
		into v_houseno, v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag
		from pt_asmt_mstr_tbl asmtmstr where asmtmstr.i_asmtno = assessmentNo;
		--raise notice 'migrateSingleAssess v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag (% % % % % % % % % % % % % % % %)', v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag;
		select id into v_idinstall from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and v_assmtdate between start_date and end_date;
		--raise notice 'migrateSingleAssess : v_idinstall 1(%)', v_idinstall;
		if (v_idinstall is null) then
			select id into v_idinstall from eg_installment_master where start_date=(select min(inst.start_date) from pt_arrear_tbl arr, eg_installment_master inst where inst.id_module=idModule and arr.i_asmtno=assessmentNo and arr.vc_dmndyear=inst.description) and id_module=idModule;
		end if;
		if (v_idinstall is null) then
			v_idinstall := currinst;
		end if;
		--raise notice 'migrateSingleAssess : v_idinstall 2(%)', v_idinstall;
		--raise notice 'migrateSingleAssess : got installment (%)', v_idinstall;
		v_addressid := createAddress(v_houseno, v_block, v_locality);
		--raise notice 'migrateSingleAssess : address created (%)', v_addressid;
		v_idpropid := createPropertyid(v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate);
		--raise notice 'migrateSingleAssess : propertyid created (%)', v_idpropid;
		v_idowner := createOwner(assessmentNo, v_corraddr1, v_corraddr2, v_addressid);
		--raise notice 'migrateSingleAssess : owner created (%)', v_idowner;
		v_idbasic := createBasicprop(assessmentNo, v_addressid, v_idpropid, v_eward, v_delflag);
		--raise notice 'migrateSingleAssess : Basicproperty created (%)', v_idbasic;
		v_idownerlk := linkOwner(v_idbasic, idsource, v_idowner);
		--raise notice 'migrateSingleAssess : Owner linked (%)', v_idownerlk;
		v_idprop := createProperty(v_assmtdate, idsource, v_idbasic, v_isExempted, v_exemptionReason, v_idinstall);
		--raise notice 'migrateSingleAssess : Property Created (%)', v_idprop;
		v_idpropdet := createPropertyDet(assessmentNo, v_idprop);
		--raise notice 'Property Details created (%)', v_idpropdet;
		v_iddmd := createDemand(assessmentNo, v_idprop, currinst, v_assmtdate, idModule, v_arv, currinstdesc);
		--raise notice 'migrateSingleAssess : Demand created';
		v_iddmdcalc := createDemandCalc(v_iddmd, v_totaltax, currinst, v_assmtdate, v_arv);
		--raise notice 'migrateSingleAssess : createDemandCalc created';
		v_idfloor := addFloors(assessmentNo, v_assmtdate, v_idpropdet, v_iddmdcalc);
		--raise notice 'Floors created';
		v_idfloor := migrateCollection(assessmentNo, v_iddmd);
		--raise notice 'Collection created';
		update pt_asmt_mstr_tbl set ismigrated='Y' where i_asmtno=assessmentNo;
		return v_idfloor;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'migrateSingleAssess : % %', SQLERRM, SQLSTATE;
	update pt_asmt_mstr_tbl set error = SQLSTATE || '-' || SQLERRM where i_asmtno=assessmentNo;
	END;
END;
$BODY$ LANGUAGE plpgsql;

--addFloors
create or replace FUNCTION addFloors(assessmentNo IN integer, assessmentdate IN date, idPropDet IN bigint, idDmdCal IN bigint)  
RETURNS numeric as $$
declare
	v_FlrDetpk bigint;
	v_FlrDmdCalc bigint;
	floors pt_asmt_dtls_tbl%ROWTYPE;
BEGIN 
	--raise notice 'addFloors assessmentNo, assessmentdate, idPropDet, idDmdCal (% % % %)',assessmentNo, assessmentdate, idPropDet, idDmdCal;
for floors in (select * from pt_asmt_dtls_tbl where c_delflag='N' and i_asmtno = assessmentNo order by i_flrno)
	loop 
		begin
			select nextval('seq_egpt_floor_detail') into v_FlrDetpk;
			--raise notice 'addFloors v_FlrDetpk (%)',v_FlrDetpk;
			INSERT INTO egpt_floor_detail(id, id_property_detail, floor_no, created_date, builtup_area, id_struc_cl, id_occpn_mstr, id_usg_mstr, modified_date, created_by, modified_by, id_depreciationmaster, occupancydate)
			values (v_FlrDetpk, idPropDet, floors.i_flrno, assessmentdate, floors.d_plntarea, (select egovcode from egpt_stg_bldgclass_mater where code=floors.i_clscode), (select egovcode from egpt_stg_occupancy where code=floors.i_ocpntypecode), (select egovcode from egpt_stg_usagemaster where code=floors.i_bldgusecode), assessmentdate, 1, 1, (select egovcode from egpt_stg_depreciation where code=floors.i_depcode), to_date('01/04/2011','dd/MM/yyyy'));
			--raise notice 'Floor done';
			v_FlrDmdCalc := createFlrDmdCalc(idDmdCal, floors.i_asmtdtlsno, v_FlrDetpk, assessmentdate, assessmentNo);
			--raise notice 'Floor demand calc is done';
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'addFloors, adding floors failed : % %', SQLERRM, SQLSTATE;
		END;
END LOOP;
	return 1;
EXCEPTION
WHEN OTHERS THEN
--raise notice 'addFloors : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--migrateassessmtWard
CREATE OR REPLACE FUNCTION migrateassessmtWard(wardCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_oscode not in (select i_oscode from pt_os_mstr_tbl where vc_osdesc like '%EWSHS') and i_rwobjid=wardCode)
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtWard : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtWard : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;

--migrateassessmtblock
CREATE OR REPLACE FUNCTION migrateassessmtblock(blockCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_oscode not in (select i_oscode from pt_os_mstr_tbl where vc_osdesc like '%EWSHS') and i_blckobjid=blockCode)
	loop 
		begin
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtblock : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtblock : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;
