-----------------START-------------------
CREATE TABLE ct_grd_mstr_tbl (
    i_grdobjid smallint NOT NULL,
    vc_grdname character varying(20) NOT NULL,
    vc_grddesc character varying(100),
    i_usrid integer NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL
);

CREATE TABLE ct_ocpn_mstr_tbl (
    i_ocpncode integer NOT NULL,
    vc_ocpndesc character varying(50) NOT NULL,
    i_usrid integer NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL
);

CREATE TABLE ct_plce_mstr_tbl (
    i_plcobjid integer NOT NULL,
    vc_plccd character varying(4) NOT NULL,
    vc_plcname character varying(100) NOT NULL,
    i_usrid integer NOT NULL,
    dt_dttm timestamp without time zone NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL
);

CREATE TABLE ct_rgn_mstr_tbl (
    i_rgnobjid smallint NOT NULL,
    vc_rgnname character varying(20) NOT NULL,
    vc_rgndesc character varying(100),
    i_usrid integer NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL
);

CREATE TABLE pt_aprtcplx_mstr_tbl (
    i_aprtcplxcode integer NOT NULL,
    vc_aprtcplxname character varying(50) NOT NULL,
    i_aprtcplxtypecode integer NOT NULL,
    vc_doorno character varying(30) NOT NULL,
    i_strtobjid integer NOT NULL,
    i_lctyobjid integer NOT NULL,
    i_blckobjid integer NOT NULL,
    i_rwobjid integer NOT NULL,
    i_zoneobjid integer NOT NULL,
    i_ewobjid integer NOT NULL,
    i_noofflats smallint,
    i_nooffloors smallint,
    i_noofrsdlflats smallint,
    i_noofnonrsdlflats smallint,
    i_ulbobjid smallint NOT NULL,
    i_usrid integer NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL
);

CREATE TABLE pt_arrear_tbl (
    i_asmtno integer NOT NULL,
    vc_dmndyear character varying(11) NOT NULL,
    d_arrpt numeric(18,2),
    d_arred numeric(18,2),
    d_arrlcs numeric(18,2),
    d_arruauthcnstplty numeric(18,2),
    d_pltyonarrs numeric(18,2),
    i_ulbobjid smallint NOT NULL,
    i_usrid integer NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    i_ctrrcptno bigint
);

CREATE TABLE pt_asmt_dtls_tbl (
    i_asmtdtlsno integer NOT NULL,
    i_asmtno integer NOT NULL,
    vc_cnstun character varying(3),
    i_bldgage integer,
    i_clscode integer NOT NULL,
    i_bldgusecode integer NOT NULL,
    i_ocpntypecode integer NOT NULL,
    d_capval numeric(18,2),
    i_flrno integer,
    d_lnth numeric(18,2),
    d_wdth numeric(18,2),
    d_plntarea numeric(18,2),
    i_ur numeric(18,2),
    d_mrv numeric(18,2),
    d_arv numeric(18,2),
    i_depcode integer,
    d_bldgval numeric(18,2),
    d_siteval numeric(18,2),
    d_tarv numeric(18,2),
    d_pt numeric(18,2),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL,
    dt_adddt date,
    vc_bldgpersno character varying(20),
    dt_bldprmt date,
    is_planaprvd character(1)
);

CREATE TABLE pt_asmt_mstr_tbl (
    i_asmtno integer NOT NULL,
    vc_onrsurname character varying(20),
    vc_onrname character varying(100) NOT NULL,
    vc_fthrsurname character varying(20),
    vc_fthrname character varying(50),
    c_sex character(1) DEFAULT 'M'::bpchar NOT NULL,
    vc_ssidno character varying(12),
    i_strtobjid integer NOT NULL,
    i_lctyobjid integer NOT NULL,
    i_blckobjid integer NOT NULL,
    i_rwobjid integer NOT NULL,
    i_zoneobjid integer NOT NULL,
    i_ewobjid integer NOT NULL,
    vc_onrdoorno character varying(30),
    vc_onraddr1 character varying(30) NOT NULL,
    vc_onraddr2 character varying(30),
    vc_city character varying(25),
    vc_stdcode character varying(6),
    vc_onrphno character varying(8),
    vc_onrmobino character varying(10),
    vc_onreid character varying(50),
    vc_onrfaxno character varying(15),
    d_extoflnd numeric(18,2),
    i_vcntlndasmtno integer,
    d_areaoveraptt numeric(18,2),
    dt_cnstdt date,
    dt_taxassddt date,
    c_bldgplanoptn character(1),
    vc_bldgprmnno character varying(15),
    dt_bldgprmndt date,
    vc_rgtddocno character varying(30),
    dt_rgtddocdt date,
    c_sprstru character(1),
    c_athdbathroom character(1),
    c_lift character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_tlts character(1),
    c_drng character(1),
    c_whp character(1),
    c_ecty character(1),
    c_wt character(1),
    c_cablecntn character(1) DEFAULT 'X'::bpchar NOT NULL,
    vc_siteonr character varying(60),
    c_xptn character(1),
    i_xptnpcode integer NOT NULL,
    i_flrtypecode integer NOT NULL,
    i_rftypecode integer NOT NULL,
    i_oscode integer NOT NULL,
    c_srvctax character(1),
    i_srvctaxid integer NOT NULL,
    c_aprtcplxopt character(1),
    i_aprtcplxcode integer NOT NULL,
    i_walltypecode integer NOT NULL,
    i_woodtypecode integer NOT NULL,
    vc_opntsurname character varying(20),
    vc_opntname character varying(50),
    d_fxdarv numeric(18,2),
    d_fxdpt numeric(18,2),
    d_fxded numeric(18,2),
    d_fxdlcs numeric(18,2),
    c_unauthplnplty character(1),
    d_fxdunauthplnplty numeric(18,2),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL,
    c_wrtoffflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_vcnyrmsnflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_asmtstatus character(2) DEFAULT 'AM'::bpchar NOT NULL,
    vc_oldasmtno character varying(15),
    vc_uid character varying(12),
    vc_aadhaar_seed character(1) DEFAULT 'N'::bpchar,
    dt_aadhaar_updt date,
    vc_remarks character varying(300),
    ismigrated character varying(1) DEFAULT 'N'::character varying,
    error character varying(512)
);


CREATE TABLE pt_asmt_mstr_tbl1 (
    i_asmtno integer NOT NULL,
    vc_onrsurname character varying(20),
    vc_onrname character varying(100) NOT NULL,
    vc_fthrsurname character varying(20),
    vc_fthrname character varying(50),
    c_sex character(1) DEFAULT 'M'::bpchar NOT NULL,
    vc_ssidno character varying(12),
    i_strtobjid integer NOT NULL,
    i_lctyobjid integer NOT NULL,
    i_blckobjid integer NOT NULL,
    i_rwobjid integer NOT NULL,
    i_zoneobjid integer NOT NULL,
    i_ewobjid integer NOT NULL,
    vc_onrdoorno character varying(30),
    vc_onraddr1 character varying(30) NOT NULL,
    vc_onraddr2 character varying(30),
    vc_city character varying(25),
    vc_stdcode character varying(6),
    vc_onrphno character varying(8),
    vc_onrmobino character varying(10),
    vc_onreid character varying(50),
    vc_onrfaxno character varying(15),
    d_extoflnd numeric(18,2),
    i_vcntlndasmtno integer,
    d_areaoveraptt numeric(18,2),
    dt_cnstdt date,
    dt_taxassddt date,
    c_bldgplanoptn character(1),
    vc_bldgprmnno character varying(15),
    dt_bldgprmndt date,
    vc_rgtddocno character varying(30),
    dt_rgtddocdt date,
    c_sprstru character(1),
    c_athdbathroom character(1),
    c_lift character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_tlts character(1),
    c_drng character(1),
    c_whp character(1),
    c_ecty character(1),
    c_wt character(1),
    c_cablecntn character(1) DEFAULT 'X'::bpchar NOT NULL,
    vc_siteonr character varying(60),
    c_xptn character(1),
    i_xptnpcode integer NOT NULL,
    i_flrtypecode integer NOT NULL,
    i_rftypecode integer NOT NULL,
    i_oscode integer NOT NULL,
    c_srvctax character(1),
    i_srvctaxid integer NOT NULL,
    c_aprtcplxopt character(1),
    i_aprtcplxcode integer NOT NULL,
    i_walltypecode integer NOT NULL,
    i_woodtypecode integer NOT NULL,
    vc_opntsurname character varying(20),
    vc_opntname character varying(50),
    d_fxdarv numeric(18,2),
    d_fxdpt numeric(18,2),
    d_fxded numeric(18,2),
    d_fxdlcs numeric(18,2),
    c_unauthplnplty character(1),
    d_fxdunauthplnplty numeric(18,2),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL,
    c_wrtoffflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_vcnyrmsnflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_asmtstatus character(2) DEFAULT 'AM'::bpchar NOT NULL,
    vc_oldasmtno character varying(15),
    vc_uid character varying(12),
    vc_aadhaar_seed character(1) DEFAULT 'N'::bpchar,
    dt_aadhaar_updt date,
    vc_remarks character varying(300)
);



CREATE TABLE pt_asmtbal_tbl (
    i_slno integer NOT NULL,
    d_arearamt numeric(18,2),
    d_currentamt numeric(18,2),
    d_pltyonarrs numeric(18,2),
    d_advamt numeric(18,2),
    i_asmtno integer NOT NULL,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_asmtrcpt_tbl (
    i_slno character(25) NOT NULL,
    i_bookno integer,
    c_rcptno character(15),
    dt_rcptdt date,
    dt_etrydt date,
    i_bnkcode integer NOT NULL,
    d_crnpt numeric(18,2),
    d_crned numeric(18,2),
    d_crnlcs numeric(18,2),
    d_crnuauthcnstplty numeric(18,2),
    i_empcode integer NOT NULL,
    d_pltyoncrn numeric(18,2),
    d_arrpt numeric(18,2),
    d_arred numeric(18,2),
    d_arrlcs numeric(18,2),
    d_arruauthcnstplty numeric(18,2),
    d_pltyonarr numeric(18,2),
    dt_paidfrmprddt date,
    dt_paidtoprddt date,
    d_advamt numeric(18,2),
    vc_paytype character varying(30),
    c_amtpaidat character(1) DEFAULT 'D'::bpchar NOT NULL,
    i_esevaid integer,
    i_grcid integer,
    c_paymode character(1) DEFAULT 'C'::bpchar NOT NULL,
    vc_chqddccbno character varying(15),
    vc_crcardno character varying(16),
    dt_chqddccbdt date,
    i_asmtno integer NOT NULL,
    i_dmndno character(25) NOT NULL,
    c_isrlsd character(1) DEFAULT 'N'::bpchar NOT NULL,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL,
    d_servchrgs numeric(18,2),
    d_rebate numeric(18,2)
);


CREATE TABLE pt_bldgcls_mstr_tbl (
    i_clscode integer NOT NULL,
    vc_clsname character varying(45),
    vc_clsdesc character varying(50),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);


CREATE TABLE pt_bldguse_mstr_tbl (
    i_bldgusecode integer NOT NULL,
    vc_bldgusetype character varying(45),
    vc_bldgusedesc character varying(50),
    c_resflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);


CREATE TABLE pt_deprate_mstr_tbl (
    i_depratecode integer NOT NULL,
    i_ocpntypecode integer NOT NULL,
    d_deprate numeric(18,2),
    i_frombldgage integer,
    i_tobldgage integer,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_dmndrgtr_tbl (
    i_dmndno bigint NOT NULL,
    dt_dmnddt date,
    vc_dmndyear character varying(11) NOT NULL,
    d_crnpt numeric(18,2),
    d_crned numeric(18,2),
    d_crnlcs numeric(18,2),
    d_crnuauthcnstplty numeric(18,2),
    d_arrpt numeric(18,2),
    d_arred numeric(18,2),
    d_arrlcs numeric(18,2),
    d_arruauthcnstplty numeric(18,2),
    d_pltyonarrs numeric(18,2),
    d_adjdamt numeric(18,2),
    i_asmtno integer NOT NULL,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_doctype_mstr_tbl (
    i_doctypecode integer NOT NULL,
    vc_doctypedesc character varying(20) NOT NULL,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_flrtype_mstr_tbl (
    i_flrtypecode integer NOT NULL,
    vc_flrtypedesc character varying(35),
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_ocpntype_mstr_tbl (
    i_ocpntypecode integer NOT NULL,
    vc_ocpntypedesc character varying(35) NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_os_mstr_tbl (
    i_oscode integer NOT NULL,
    vc_osdesc character varying(35) NOT NULL,
    c_invdlpropflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL,
    egovcode bigint
);

CREATE TABLE pt_rftype_mstr_tbl (
    i_rftypecode integer NOT NULL,
    vc_rftypedesc character varying(35),
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_srvctaxcat_mstr_tbl (
    i_srvctaxid integer NOT NULL,
    d_sertaxpctgper numeric(18,2),
    vc_srvctaxdesc character varying(100) NOT NULL,
    dt_fromyear date,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_taxrate_mstr_tbl (
    i_taxratecode integer NOT NULL,
    vc_taxratetype character varying(30),
    d_taxrate numeric(18,2),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_ulb_setup_tbl (
    i_ulbsetupno integer NOT NULL,
    d_perrebonur numeric(18,2),
    d_fxdrebonur numeric(18,2),
    c_seeshoreflg character(1),
    d_seeshoreper numeric(18,2),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_ur_mstr_tbl (
    i_urcode integer NOT NULL,
    i_zoneobjid integer NOT NULL,
    i_clscode integer NOT NULL,
    i_bldgusecode integer NOT NULL,
    d_ur numeric(18,2),
    dt_wefdate date,
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_walltype_mstr_tbl (
    i_walltypecode integer NOT NULL,
    vc_walltypedesc character varying(35),
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_woodtype_mstr_tbl (
    i_woodtypecode integer NOT NULL,
    vc_woodtypedesc character varying(35),
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);

CREATE TABLE pt_xptn_mstr_tbl (
    i_xptnpcode integer NOT NULL,
    vc_xptnpdesc character varying(45),
    i_ulbobjid smallint NOT NULL,
    c_delflag character(1) DEFAULT 'N'::bpchar NOT NULL,
    ts_dttm timestamp without time zone NOT NULL,
    i_usrid integer NOT NULL
);
-----------------END-------------------

-----------------START-------------------
--create staging tables
CREATE TABLE egpt_stg_usagemaster (
    code bigint,
    name character varying(256),
    orderid integer,
    replacementcode bigint,
    isresidential boolean,
    egovcode bigint
);

CREATE TABLE egpt_stg_bldgclass_mater (
    code bigint,
    name character varying(256),
    orderid integer,
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_floortype (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_rooftype (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_walltype (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_woodtype (
    code bigint,
    name character varying(256),
    replacementcode character varying(50),
    egovcode bigint
);

CREATE TABLE egpt_stg_apartment (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_exemption (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_titlereason (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);

CREATE TABLE egpt_stg_documents (
    mame character varying(50),
    ismandatory boolean,
    servicename character varying(50),
	egovcode bigint
);

CREATE TABLE egpt_stg_depreciation (
    code bigint,
    name character varying(256),
    agefrom integer,
    ageto integer,
    rate double precision,
	egovcode bigint
);

CREATE TABLE egpt_stg_unitrate (
    zonecode bigint,
    usagecode bigint,
    classificationcode bigint,
    fromdate timestamp without time zone,
    todate timestamp without time zone,
    rate double precision,
	egovcode bigint
);

CREATE TABLE egpt_stg_ownership (
    code bigint,
    name character varying(256),
	egovcode bigint
);

CREATE TABLE egpt_stg_occupancy (
    code bigint,
    name character varying(256),
    replacementcode bigint,
    egovcode bigint
);
-----------------END-------------------

-----------------START-------------------
--migrateassessmtCity
CREATE OR REPLACE FUNCTION migrateassessmtCity()
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_oscode not in (select i_oscode from pt_os_mstr_tbl where vc_osdesc like '%EWSHS'))
	loop 
		begin
			/*IF (MOD(v_migCount, 100) = 0) THEN
				commit;
			END IF;*/
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtCity : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtCity : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;

--migrateassessmtWard
CREATE OR REPLACE FUNCTION migrateassessmtWard(wardCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_oscode not in (select i_oscode from pt_os_mstr_tbl where vc_osdesc like '%EWSHS') and i_rwobjid=wardCode)
	loop 
		begin
			IF (MOD(v_migCount, 100) = 0) THEN
				commit;
			END IF;
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtWard : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtWard : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;

--migrateassessmtblock
CREATE OR REPLACE FUNCTION migrateassessmtblock(blockCode IN bigint)
RETURNS void AS
$BODY$
DECLARE
asmstr pt_asmt_mstr_tbl%ROWTYPE;

v_idsource bigint;
v_currinst bigint;
v_currinstdesc varchar(16);
v_moduleid bigint;
v_assessmentno integer;
v_temp integer;
v_migCount integer default 0;
BEGIN
	select id into v_idsource from egpt_src_of_info where src_sht_name = 'MNCPL-RECORDS';
	select id, description into v_currinst, v_currinstdesc from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and now() between start_date and end_date;
	select id into v_moduleid from eg_module where name='Property Tax';

	for asmstr in (select * from pt_asmt_mstr_tbl where (ismigrated='N' or ismigrated is null) and i_oscode not in (select i_oscode from pt_os_mstr_tbl where vc_osdesc like '%EWSHS') and i_blckobjid=blockCode)
	loop 
		begin
			IF (MOD(v_migCount, 100) = 0) THEN
				commit;
			END IF;
			v_assessmentno := asmstr.i_asmtno;
			--raise notice 'migrateassessmtblock : Started for assessment no (%)', v_assessmentno;
			v_temp  := migrateSingleAssess(v_assessmentno, v_idsource, v_currinst, v_currinstdesc, v_moduleid);
			v_migCount := v_migCount + 1;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateassessmtblock : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
END;
$BODY$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION migrateSingleAssess(assessmentNo IN integer, idsource IN bigint, currinst IN bigint, currinstdesc IN varchar(16), idModule IN bigint)
RETURNS bigint AS
$BODY$
DECLARE

v_idinstall bigint;
v_addressid bigint;
v_idpropid bigint;
v_idowner bigint;
v_idbasic bigint;
v_idprop bigint;
v_idpropdet bigint;
v_idfloor bigint;
v_idownerlk bigint;
v_iddmd bigint;
v_iddmdcalc bigint;
v_houseno varchar(32);
v_zone int;
v_ward int;
v_block int;
v_locality int;
v_eward int;
v_street int;
v_assmtdate date;
v_corraddr1 varchar(32); 
v_corraddr2 varchar(32);
v_isExempted character;
v_arv double precision;
v_totaltax double precision;
v_exemptionReason integer;
v_delflag character;
BEGIN
	begin
		--raise notice 'migrateSingleAssess : Started for assessment no (% % % % %)', assessmentNo, idsource, currinst, currinstdesc, idModule;
		select asmtmstr.vc_onrdoorno, asmtmstr.i_zoneobjid, asmtmstr.i_rwobjid, asmtmstr.i_blckobjid, asmtmstr.i_lctyobjid, asmtmstr.i_strtobjid, asmtmstr.i_ewobjid, asmtmstr.dt_taxassddt, asmtmstr.vc_onraddr1, asmtmstr.vc_onraddr2, asmtmstr.c_xptn, asmtmstr.i_xptnpcode, asmtmstr.d_fxdarv, (coalesce(asmtmstr.d_fxdpt,0)+coalesce(asmtmstr.d_fxded,0)+coalesce(asmtmstr.d_fxdlcs,0)+coalesce(asmtmstr.d_fxdunauthplnplty,0)), asmtmstr.c_delflag
		into v_houseno, v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag
		from pt_asmt_mstr_tbl asmtmstr where asmtmstr.i_asmtno = assessmentNo;
		--raise notice 'migrateSingleAssess v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag (% % % % % % % % % % % % % % % %)', v_houseno, v_zone, v_ward, v_block, v_locality, v_eward, v_street, v_eward, v_assmtdate, v_corraddr1, v_corraddr2, v_isExempted, v_exemptionReason, v_arv, v_totaltax, v_delflag;
		select id into v_idinstall from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and v_assmtdate between start_date and end_date;
		--raise notice 'migrateSingleAssess : v_idinstall 1(%)', v_idinstall;
		if (v_idinstall is null) then
			select id into v_idinstall from eg_installment_master where start_date=(select min(inst.start_date) from pt_arrear_tbl arr, eg_installment_master inst where inst.id_module=idModule and arr.i_asmtno=assessmentNo and arr.vc_dmndyear=inst.description) and id_module=idModule;
		end if;
		if (v_idinstall is null) then
			v_idinstall := currinst;
		end if;
		--raise notice 'migrateSingleAssess : v_idinstall 2(%)', v_idinstall;
		--raise notice 'migrateSingleAssess : got installment (%)', v_idinstall;
		v_addressid := createAddress(v_houseno, v_block, v_locality);
		--raise notice 'migrateSingleAssess : address created (%)', v_addressid;
		v_idpropid := createPropertyid(v_zone, v_ward, v_block, v_locality, v_street, v_eward, v_assmtdate);
		--raise notice 'migrateSingleAssess : propertyid created (%)', v_idpropid;
		v_idowner := createOwner(assessmentNo, v_corraddr1, v_corraddr2, v_addressid);
		--raise notice 'migrateSingleAssess : owner created (%)', v_idowner;
		v_idbasic := createBasicprop(assessmentNo, v_addressid, v_idpropid, v_ward, v_delflag);
		--raise notice 'migrateSingleAssess : Basicproperty created (%)', v_idbasic;
		v_idownerlk := linkOwner(v_idbasic, idsource, v_idowner);
		--raise notice 'migrateSingleAssess : Owner linked (%)', v_idownerlk;
		v_idprop := createProperty(v_assmtdate, idsource, v_idbasic, v_isExempted, v_exemptionReason, v_idinstall);
		--raise notice 'migrateSingleAssess : Property Created (%)', v_idprop;
		v_idpropdet := createPropertyDet(assessmentNo, v_idprop);
		--raise notice 'Property Details created (%)', v_idpropdet;
		v_iddmd := createDemand(assessmentNo, v_idprop, currinst, v_assmtdate, idModule, v_arv, currinstdesc);
		--raise notice 'migrateSingleAssess : Demand created';
		v_iddmdcalc := createDemandCalc(v_iddmd, v_totaltax, currinst, v_assmtdate, v_arv);
		--raise notice 'migrateSingleAssess : createDemandCalc created';
		v_idfloor := addFloors(assessmentNo, v_assmtdate, v_idpropdet, v_iddmdcalc);
		--raise notice 'Floors created';
		v_idfloor := migrateCollection(assessmentNo, v_iddmd);
		--raise notice 'Collection created';
		update pt_asmt_mstr_tbl set ismigrated='Y' where i_asmtno=assessmentNo;
		return v_idfloor;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'migrateSingleAssess : % %', SQLERRM, SQLSTATE;
	update pt_asmt_mstr_tbl set error = SQLSTATE || '-' || SQLERRM where i_asmtno=assessmentNo;
	END;
END;
$BODY$ LANGUAGE plpgsql;


--generateUsername
create or replace FUNCTION generateUsername(name IN varchar(8))  
RETURNS VARCHAR as $$
declare
	v_username 	varchar(10); 
	v_random 	varchar(18);
	v_randomno 	varchar(4);
BEGIN 
	--raise notice 'generateUsername name (%)',name;
	v_username := lpad(upper(substr(replace(replace(replace(name,'.',''),' ',''),',',''),1,6)), 6, '0');
	v_random := random()*100000;
	v_randomno := substring(v_random from 1 for 4);
	v_username := v_username || v_randomno;
	--raise notice 'generateUsername, username generated (%)', v_username;
return v_username;
EXCEPTION
WHEN OTHERS THEN
raise notice 'generateUsername : % %', SQLERRM, SQLSTATE;
END;  
$$ LANGUAGE plpgsql;

--createAddress
create or replace FUNCTION createAddress(houseno IN varchar(32), block IN int, locality IN int)  
RETURNS numeric as $$
declare
	v_addresspk 	bigint;  
BEGIN 
	--raise notice 'createAddress houseno, block, locality (% % %)', houseno, block, locality;
	select nextval('seq_eg_address') into v_addresspk;
	INSERT INTO eg_address(housenobldgapt, type, streetroadline, arealocalitysector, pincode, id)
    values (houseno, 'PROPERTYADDRESS', (select name from eg_stg_block where code=block), (select name from eg_stg_locality where code=locality), NULL, v_addresspk);
	insert into egpt_address (id) values (v_addresspk);
	--raise notice 'createAddress Address created';
return v_addresspk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createAddress : % %', SQLERRM, SQLSTATE;
END; 
$$ LANGUAGE plpgsql;

--createPropertyid
create or replace FUNCTION createPropertyid(zone IN int, ward IN int, block IN int, locality IN int, street IN int, eleward IN int, assessmentdate IN date)  
RETURNS numeric as $$
declare
	v_pidpk 	bigint;  
	v_isbndryloaded	bigint default 1;
	zoneBndry eg_stg_zone%ROWTYPE;
BEGIN 
	--raise notice 'createPropertyid zone, ward, block, locality, street, eleward, assessmentdate (% % % % % % %)',zone, ward, block, locality, street, eleward, assessmentdate;
	select nextval('seq_egpt_propertyid') into v_pidpk;
	INSERT INTO egpt_propertyid(id, zone_num, ward_adm_id, adm1, adm2, adm3, created_date, modified_date, created_by, modified_by, elect_bndry)
    VALUES (v_pidpk, (select egovcode from eg_stg_zone where code=zone), (select egovcode from eg_stg_ward where code=ward), (select egovcode from eg_stg_block where code=block), (select egovcode from eg_stg_locality where code=locality), (select egovcode from eg_stg_street where code=street), assessmentdate, assessmentdate, 1, 1, (select egovcode from eg_stg_election where code=eleward));
	--raise notice 'createPropertyid Propertyid created';
return v_pidpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createPropertyid : % %', SQLERRM, SQLSTATE;
END; 
$$ LANGUAGE plpgsql;

--createOwner
create or replace FUNCTION createOwner(assessmentNo IN integer, corraddr1 IN varchar(32), corraddr2 IN varchar(32), addressid IN bigint)  
RETURNS numeric as $$
declare
	v_userpk 	bigint;  
	v_addresspk	bigint;
BEGIN 
	--raise notice 'createOwner assessmentNo, corraddr1, corraddr2, addressid (% % % % %)', assessmentNo, corraddr1, corraddr2, addressid;
	select nextval('seq_eg_address') into v_addresspk;
	select nextval('seq_eg_user') into v_userpk;
	INSERT INTO eg_user(id, locale, username, password, mobilenumber, emailid, createddate, lastmodifieddate, createdby, lastmodifiedby, active, name, gender, type, aadhaarnumber, guardian, guardianrelation)
    select v_userpk, 'en_IN', generateUsername(vc_onrname), 'NOT SET', vc_onrmobino, vc_onreid, dt_taxassddt, dt_taxassddt, 1, 1, TRUE, trim((coalesce(vc_onrsurname,'') ||' '|| coalesce(vc_onrname,''))), (CASE WHEN c_sex = 'F' THEN 0 ELSE 1 END), 'CITIZEN', vc_uid, vc_fthrsurname ||' '|| vc_fthrname, 'Father' from pt_asmt_mstr_tbl where i_asmtno=assessmentNo;
	--raise notice 'createOwner Owner created';
IF (corraddr1 IS NOT NULL OR corraddr2 IS NOT NULL) AND (length(corraddr1)>0 OR length(corraddr2)>0) then
	--raise notice 'createOwner Corr Address available';
    INSERT INTO eg_address(type, streetroadline, arealocalitysector, pincode, id, userid)
    values ('CORRESPONDENCE', corraddr1, corraddr2, NULL, v_addresspk, v_userpk);
	insert into eg_correspondence_address (id) values (v_addresspk);
	--raise notice 'createOwner Owner address created with available corr address';
else
	--raise notice 'createOwner Corr Address NOT available';
	INSERT INTO eg_address(housenobldgapt, type, streetroadline, arealocalitysector, pincode, id, userid)
	select housenobldgapt, 'CORRESPONDENCE', streetroadline, arealocalitysector, pincode, v_addresspk, v_userpk from eg_address where id=addressid;
	insert into eg_correspondence_address (id) values (v_addresspk);
	--raise notice 'createOwner Owner address created with property address';
END IF;

return v_userpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createOwner : % %', SQLERRM, SQLSTATE;
END;  
$$ LANGUAGE plpgsql;

--createBasicprop
create or replace FUNCTION createBasicprop(assessmentNo IN integer, addressid bigint, id_propertyid bigint, ward IN integer, isactive IN character)  
RETURNS numeric as $$
declare
	v_basicpk 	bigint;  
BEGIN 
	--raise notice 'createBasicprop assessmentNo, addressid, idBasicProp, id_propertyid, ward, isactive (% % % % % %)',assessmentNo, addressid, idBasicProp, id_propertyid, ward, isactive;
	select nextval('seq_egpt_basic_property') into v_basicpk;
INSERT INTO egpt_basic_property(id, createdby, propertyid, isactive, addressid, createddate, lastmodifieddate, id_propertyid, municiapl_no_old, id_adm_bndry, id_prop_create_reason, prop_occupancy_date, status, modifiedby, vl_assessmentno, regd_doc_no, regd_doc_date, assessmentdate, source)
	select v_basicpk, 1, i_asmtno, (CASE WHEN isactive = 'N' THEN TRUE ELSE FALSE END), addressid, dt_taxassddt, dt_taxassddt, id_propertyid, vc_oldasmtno, (select egovcode from eg_stg_ward where code=ward), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, (select id from egpt_status where code='ASSESSED'), 1, i_vcntlndasmtno, vc_rgtddocno, dt_rgtddocdt, dt_taxassddt, 'M' from pt_asmt_mstr_tbl where i_asmtno=assessmentNo;
	--raise notice 'createBasicprop basicproperty created';
return v_basicpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createBasicprop : % %', SQLERRM, SQLSTATE;
END; 
$$ LANGUAGE plpgsql;


--Link Owner to Property
create or replace FUNCTION linkOwner(idBasiprop IN bigint, idSource IN bigint, idUser IN bigint)  
RETURNS numeric as $$
declare
	v_ownerlkpk 	bigint;  
BEGIN 
	--raise notice 'linkOwner idBasiprop, idSource, idUser (% % %)', idBasiprop, idSource, idUser;
	select nextval('seq_egpt_property_owner_info') into v_ownerlkpk;
	INSERT INTO egpt_property_owner_info(id, basicproperty, id_source, orderno, owner)
    VALUES (v_ownerlkpk, idBasiprop, idSource, 1, idUser);
	--raise notice 'linkOwner Owner linked';
	return 1;
EXCEPTION
WHEN OTHERS THEN
raise notice 'linkOwner : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--createProperty
create or replace FUNCTION createProperty(assessmentdate IN date, idSource IN bigint, idBasicProp IN bigint, isExempted character, exemptionReason IN integer, idInstallment IN bigint) 
RETURNS numeric as $$
declare
	v_proppk 	bigint;  
BEGIN 
	--raise notice 'createProperty assessmentdate, idSource, idBasicProp, isExempted, exemptionReason, idInstallment (% % % % % %)',assessmentdate, idSource, idBasicProp, isExempted, exemptionReason, idInstallment;
	select nextval('seq_egpt_property') into v_proppk;
	INSERT INTO egpt_property(id, created_date, modified_date, created_by, id_source, id_basic_property, is_default_property, status, effective_date, modify_reason, id_installment, modified_by, state_id, isexemptedfromtax, tax_exempted_reason)
		VALUES (v_proppk, assessmentdate, assessmentdate, 1, idSource, idBasicProp, 'Y', 'A', assessmentdate, 'CREATE', idInstallment, 1, NULL, (CASE WHEN isExempted = 'Y' THEN TRUE ELSE FALSE END), (select egovcode from egpt_stg_exemption where code=exemptionReason));
	--raise notice 'createProperty Property Created';
return v_proppk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createProperty : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--createPropertyDet
create or replace FUNCTION createPropertyDet(assessmentNo IN integer, idproperty IN bigint)  
RETURNS numeric as $$
declare
	v_pdpk 	bigint;
BEGIN 
	--raise notice 'createPropertyDet assessmentNo, idproperty (% %)',assessmentNo, idproperty;
	select nextval('seq_egpt_property_detail') into v_pdpk;
	INSERT INTO egpt_property_detail(id, id_property, sital_area, property_type, id_propertytypemaster, id_mutation, updt_timestamp, lift, toilets, watertap, structure, electricity, attachedbathroom, waterharvesting, cable, extentsite, extent_appurtenant_land, siteowner, floortype, rooftype, walltype, woodtype, apartment, building_permission_no, building_permission_date, buildingplandetails_checked, appurtenantland_checked)
		select v_pdpk, idproperty, coalesce(d_extoflnd, 0), 'BuiltUpProperty', (select egovcode from pt_os_mstr_tbl osm where osm.i_oscode=ptmstr.i_oscode), (select id from EGPT_MUTATION_MASTER where type='CREATE' and code='NEW'), dt_taxassddt, (CASE WHEN c_lift = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_tlts = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_wt = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_sprstru = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_ecty = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_athdbathroom = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_whp = 'Y' THEN TRUE ELSE FALSE END), (CASE WHEN c_cablecntn = 'Y' THEN TRUE ELSE FALSE END), coalesce(d_extoflnd, 0), coalesce(d_areaoveraptt, 0), vc_siteonr, (select egovcode from egpt_stg_floortype where code=i_flrtypecode), (select egovcode from egpt_stg_rooftype where code=i_rftypecode), (select egovcode from egpt_stg_walltype where code=i_walltypecode), (select egovcode from egpt_stg_woodtype where code=i_woodtypecode), (select egovcode from egpt_stg_apartment where code=i_aprtcplxcode),  vc_bldgprmnno, dt_bldgprmndt, (CASE WHEN c_bldgplanoptn = 'Y' THEN TRUE ELSE FALSE END), FALSE from pt_asmt_mstr_tbl ptmstr where i_asmtno=assessmentNo;
	--raise notice 'createPropertyDet PropertyDetail Created';
return v_pdpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createPropertyDet : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--addFloors
create or replace FUNCTION addFloors(assessmentNo IN integer, assessmentdate IN date, idPropDet IN bigint, idDmdCal IN bigint)  
RETURNS numeric as $$
declare
	v_FlrDetpk bigint;
	v_FlrDmdCalc bigint;
	floors pt_asmt_dtls_tbl%ROWTYPE;
BEGIN 
	--raise notice 'addFloors assessmentNo, assessmentdate, idPropDet, idDmdCal (% % % %)',assessmentNo, assessmentdate, idPropDet, idDmdCal;
for floors in (select * from pt_asmt_dtls_tbl where c_delflag='N' and i_asmtno = assessmentNo order by i_flrno)
	loop 
		begin
			select nextval('seq_egpt_property_detail') into v_FlrDetpk;
			--raise notice 'addFloors v_FlrDetpk (%)',v_FlrDetpk;
			INSERT INTO egpt_floor_detail(id, id_property_detail, floor_no, created_date, builtup_area, id_struc_cl, id_occpn_mstr, id_usg_mstr, modified_date, created_by, modified_by, id_depreciationmaster, occupancydate)
			values (v_FlrDetpk, idPropDet, floors.i_flrno, assessmentdate, floors.d_plntarea, (select egovcode from egpt_stg_bldgclass_mater where code=floors.i_clscode), (select egovcode from egpt_stg_occupancy where code=floors.i_ocpntypecode), (select egovcode from egpt_stg_usagemaster where code=floors.i_bldgusecode), assessmentdate, 1, 1, (select egovcode from egpt_stg_depreciation where code=floors.i_depcode), to_date('01/04/2011','dd/MM/yyyy'));
			--raise notice 'Floor done';
			v_FlrDmdCalc := createFlrDmdCalc(idDmdCal, floors.i_asmtdtlsno, v_FlrDetpk, assessmentdate, assessmentNo);
			--raise notice 'Floor demand calc is done';
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'addFloors, adding floors failed : % %', SQLERRM, SQLSTATE;
		END;
END LOOP;
	return 1;
EXCEPTION
WHEN OTHERS THEN
--raise notice 'addFloors : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--Demand
create or replace FUNCTION createDemand(assessmentNo IN bigint, idProp IN bigint, currInst IN bigint, assessmentdate IN date, idModule IN bigint, arv double precision, currInstDesc varchar(16)) 
RETURNS numeric as $$
declare
	v_demandpk 	bigint; 
	v_dmddet 	bigint; 
	v_temp 		bigint; 
	v_idinst	bigint; 
	v_proptax 	double precision;
	v_educess 	double precision;
	v_libcess 	double precision;
	v_unauthtax	double precision;
	v_totaltax	double precision;
	v_arreartax	double precision;
	arrearDmds 	pt_arrear_tbl%ROWTYPE;
BEGIN 
	--raise notice 'createDemand assessmentNo, idProp, currInst, assessmentdate, idModule (% % % %)',assessmentNo, idProp, currInst, assessmentdate, idModule;
	select d_fxdpt, d_fxded, d_fxdlcs, d_fxdunauthplnplty
	into v_proptax, v_educess, v_libcess, v_unauthtax
	from pt_asmt_mstr_tbl where i_asmtno =assessmentNo;
	v_totaltax := v_proptax + v_educess + v_libcess + v_unauthtax;

	--raise notice 'createDemand v_proptax, v_educess, v_libcess, v_unauthtax, v_proptax (% % % % %)',v_proptax, v_educess, v_libcess, v_unauthtax, v_proptax;

	select nextval('seq_eg_demand') into v_demandpk;
	INSERT INTO eg_demand(id, id_installment, base_demand, is_history, create_date, modified_date, amt_collected)
    VALUES (v_demandpk, currInst, v_totaltax, 'N', assessmentdate, assessmentdate, 0);

	insert into egpt_ptdemand (id_demand, id_property) values (v_demandpk, idProp);
	--raise notice 'createDemand Demand Created';
	--select * from pt_dmndrgtr_tbl where i_asmtno =1065010757
	v_temp := createInstDemandDetail(v_demandpk, currInst, v_proptax, v_educess, v_libcess, v_unauthtax, idModule, assessmentdate);
	begin
		select (d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty) into v_arreartax from pt_dmndrgtr_tbl where i_asmtno =assessmentNo and vc_dmndyear=currInstDesc;
		if(v_arreartax>0)then
		for arrearDmds in (select * from pt_arrear_tbl where i_asmtno =assessmentNo)
		loop 
			begin
				select id into v_idinst from eg_installment_master where id_module=idModule and description=arrearDmds.vc_dmndyear;
				v_temp := createInstDemandDetail(v_demandpk, v_idinst, arrearDmds.d_arrpt, arrearDmds.d_arred, arrearDmds.d_arrlcs, arrearDmds.d_arruauthcnstplty, idModule, assessmentdate);
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'createDemand, failed while adding arrears : % %', SQLERRM, SQLSTATE;
			END;
		END LOOP;
		end if;
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'createDemand, failed while checking arrears : % %', SQLERRM, SQLSTATE;
	END;
return v_demandpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createDemand : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--createInstDemandDetail
create or replace FUNCTION createInstDemandDetail(idDemand IN bigint, idInstall IN bigint, propTax IN double precision, eduCess IN double precision, libCess IN double precision, unAuthPenalty IN double precision, idModule IN bigint, assessmentdate IN date) 
RETURNS numeric as $$
declare
	v_temp 	bigint;  
BEGIN 
	--raise notice 'createInstDemandDetail idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate (% % % % % % % %)',idDemand, idInstall, propTax, eduCess, libCess, unAuthPenalty, idModule, assessmentdate;

	IF (coalesce(propTax,0)>0) then
		v_temp := createDemandDetail(idDemand, getDemandReason(idInstall, 'GEN_TAX', idModule), propTax, assessmentdate);
	end if;
	IF (coalesce(eduCess,0)>0) then
		v_temp := createDemandDetail(idDemand, getDemandReason(idInstall, 'EDU_CESS', idModule), eduCess, assessmentdate);
	end if;
	IF (coalesce(libCess,0)>0) then
		v_temp := createDemandDetail(idDemand, getDemandReason(idInstall, 'LIB_CESS', idModule), libCess, assessmentdate);
	end if;
	IF (coalesce(unAuthPenalty,0)>0) then
		v_temp := createDemandDetail(idDemand, getDemandReason(idInstall, 'UNAUTH_PENALTY', idModule), unAuthPenalty, assessmentdate);
	end if;
	--raise notice 'createInstDemandDetail DemandDetails for installment (%) Created ', idInstall;
	return v_temp;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createInstDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;


--createDemandDetail
create or replace FUNCTION createDemandDetail(idDemand IN bigint, idDemandRsn IN bigint, taxAmount IN double precision, assessmentdate IN date) 
RETURNS numeric as $$
declare
	v_dmddetpk 	bigint;  
BEGIN 
	--raise notice 'createDemand idDemand, idDemandRsn, taxAmount, assessmentdate (% % % %)',idDemand, idDemandRsn, taxAmount, assessmentdate;

	select nextval('seq_eg_demand_details') into v_dmddetpk;
	INSERT INTO eg_demand_details(id, id_demand, id_demand_reason, amount, modified_date, create_date, amt_collected)
	VALUES (v_dmddetpk, idDemand, idDemandRsn, taxAmount, assessmentdate, assessmentdate, 0);

	--raise notice 'createDemandDetail DemandDetail Created';
return v_dmddetpk;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createDemandDetail : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;


--getDemandReason
create or replace FUNCTION getDemandReason(idInstallment IN bigint, dmdRsnCode IN VARCHAR, idModule IN bigint)
RETURNS bigint as $$
declare
	v_idDmdRsn 	bigint;  
BEGIN 
	--raise notice 'getDemandReason idInstallment, dmdRsnCode (% %)',idInstallment, dmdRsnCode;
	select dr.id
	into v_idDmdRsn
	from eg_demand_reason dr, eg_demand_reason_master drm
	where dr.id_demand_reason_master = drm.id
	and drm.module = idModule
	and dr.id_installment = idInstallment
	and drm.code = dmdRsnCode;
	--raise notice 'createDemand v_idDmdRsn (%)',v_idDmdRsn;
return v_idDmdRsn;
EXCEPTION
WHEN OTHERS THEN
raise notice 'getDemandReason : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--createDemandCalc
create or replace FUNCTION createDemandCalc(idDemand IN bigint, taxAmount IN double precision, idInstall IN bigint, assessmentdate IN date, arv IN double precision)
RETURNS bigint as $$
declare
	v_idDmdCalc 	bigint;  
BEGIN 
	--raise notice 'getDemandReason idInstallment, dmdRsnCode (% %)',idInstallment, dmdRsnCode;
	select nextval('seq_egpt_demandcalculations') into v_idDmdCalc;
	INSERT INTO egpt_demandcalculations(id, id_demand, propertytax, current_interest, modified_date, created_date, created_by, modified_by, alv)
    VALUES (v_idDmdCalc, idDemand, taxAmount, idInstall, assessmentdate, assessmentdate, 1, 1, arv);
	--raise notice 'createDemand v_idDmdRsn (%)',v_idDmdRsn;
return v_idDmdCalc;
EXCEPTION
WHEN OTHERS THEN
raise notice 'getDemandReason : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--createFlrDmdCalc
create or replace FUNCTION createFlrDmdCalc(idDmdCal IN bigint, idAsmDtls IN bigint, idFlrDtl IN bigint, assessmentdate IN date, assessmentNo IN bigint)
RETURNS bigint as $$
declare
	v_idFlrDmdCalc 	bigint;  
BEGIN 
	--raise notice 'createFlrDmdCalc idDmdCal, idAsmDtls, idFlrDtl, assessmentdate (% % % %)',idDmdCal, idAsmDtls, idFlrDtl, assessmentdate;
	select nextval('seq_egpt_floordemandcalc') into v_idFlrDmdCalc;
	--raise notice 'createFlrDmdCalc v_idFlrDmdCalc (%)',v_idFlrDmdCalc;
	INSERT INTO egpt_floordemandcalc(id, id_floordet, id_dmdcalc, categoryamt, createtimestamp, lastupdatedtimestamp, alv, mrv) select v_idFlrDmdCalc, idFlrDtl, idDmdCal, i_ur, assessmentdate, assessmentdate, d_arv, d_mrv from pt_asmt_dtls_tbl where i_asmtdtlsno=idAsmDtls and i_asmtno=assessmentNo;
	--raise notice 'Floor Demand Calcs Created';
return v_idFlrDmdCalc;
EXCEPTION
WHEN OTHERS THEN
raise notice 'createFlrDmdCalc : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--createFlrDmdCalc
create or replace FUNCTION migrateCollection(assessmentNo IN bigint, idDemand IN bigint)
RETURNS bigint as $$
declare
v_collection double precision;
dds record;
BEGIN 
	--raise notice 'migrateCollection assessmentNo, idDemand (% %)',assessmentNo, idDemand;
	select sum(d_crnpt+d_crned+d_crnlcs+d_crnuauthcnstplty+d_arrpt+d_arred+d_arrlcs+d_arruauthcnstplty+d_advamt) into v_collection from pt_asmtrcpt_tbl where i_asmtno=assessmentNo;
	--raise notice 'migrateCollection v_collection (%)',v_collection;
	for dds in (SELECT dd.id ddid, dd.amount FROM eg_demand_details dd, eg_demand_reason dr, eg_installment_master inst where dd.id_demand=idDemand and dd.id_demand_reason=dr.id and dr.id_installment=inst.id order by inst.start_date)
	loop 
		begin
			if v_collection>0 then
				v_collection := v_collection - dds.amount;
				update eg_demand_details set amt_collected=amount where id=dds.ddid;
			end if;
			--raise notice 'migrateCollection after adjust v_collection (%)',v_collection;
		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'migrateCollection, Migrate collection failed : % %', SQLERRM, SQLSTATE;
		END;
	END LOOP;
	--raise notice 'Collection Migrated';
return 1;
EXCEPTION
WHEN OTHERS THEN
--raise notice 'migrateCollection : % %', SQLERRM, SQLSTATE;
END;
$$ LANGUAGE plpgsql;

--loadAssessmentMaster
CREATE OR REPLACE FUNCTION loadAssessmentMaster()
  RETURNS character varying AS
$BODY$
declare
	v_strucpk 	bigint; 
	v_usagepk 	bigint;
	v_floortypepk 	bigint;
	v_rooftypepk 	bigint;
	v_woodtypepk 	bigint;
	v_walltypepk 	bigint;
	v_exemptionpk 	bigint;
	v_apartmentpk 	bigint;
	v_occupancypk 	bigint;
	v_titlereason	bigint;
	v_isassmasterloaded	bigint default 1;
	bldgclass egpt_stg_bldgclass_mater%ROWTYPE;
	usageMstr egpt_stg_usagemaster%ROWTYPE;
	floorType egpt_stg_floortype%ROWTYPE;
	roofType egpt_stg_rooftype%ROWTYPE;
	wallType egpt_stg_walltype%ROWTYPE;
	woodType egpt_stg_woodtype%ROWTYPE;
	exemption egpt_stg_exemption%ROWTYPE;
	apartment egpt_stg_apartment%ROWTYPE;
	occupancy egpt_stg_occupancy%ROWTYPE;
	titlereasons pt_doctype_mstr_tbl%ROWTYPE;
BEGIN 
begin
	--Building Classification
	for bldgclass in (select * from egpt_stg_bldgclass_mater order by code)
		loop 
			begin
				select nextval('seq_egpt_struc_cl') into v_strucpk;
				INSERT INTO egpt_struc_cl(id, constr_num, constr_type, constr_descr, modified_date, is_history, created_by, code, order_id, from_date, to_date, created_date, modified_by, id_installment)
				VALUES (v_strucpk, 1, bldgclass.name, bldgclass.name, now(), 'N', 1, upper(substr(replace(replace(replace(bldgclass.name,'.',''),' ',''),',',''),1,16)), v_strucpk, to_date('01/04/2004', 'dd/mm/yyyy'), to_date('01/04/2099', 'dd/mm/yyyy'), now(), 1, (select id from eg_installment_master where id_module=(select id from eg_module where name='Property Tax') and current_timestamp between start_date and end_date));
				update egpt_stg_bldgclass_mater set egovcode =v_strucpk where code=bldgclass.code;		   
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading building classification failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Building Classification loaded';

	--Property Usage
	for usageMstr in (select * from egpt_stg_usagemaster order by code)
		loop 
			begin
				select nextval('seq_egpt_property_usage_master') into v_usagepk;
			   	INSERT INTO egpt_property_usage_master(id, usg_name, modified_date, code, order_id, from_date, to_date, is_enabled, created_by, modified_by, created_date, isresidential)
		        VALUES (v_usagepk, usageMstr.name, now(),upper(substr(replace(replace(replace(usageMstr.name,'.',''),' ',''),',',''),1,16)), v_usagepk, to_date('01/04/2004', 'dd/mm/yyyy') ,to_date('01/04/2099', 'dd/mm/yyyy'), 1, 1, 1, now(), FALSE);
				update egpt_stg_usagemaster set egovcode =v_usagepk where code=usageMstr.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Usage Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	update egpt_property_usage_master set isresidential = TRUE where upper(usg_name) like 'RESI%';
	RAISE NOTICE 'Property Usage loaded';

	--Floor Type
	for floorType in (select * from egpt_stg_floortype order by code)
		loop 
			begin
				select nextval('seq_egpt_floor_type') into v_floortypepk;
			   	INSERT INTO egpt_floor_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_floortypepk, floorType.name, upper(substr(replace(replace(replace(floorType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_floortype set egovcode =v_floortypepk where code=floorType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Floor Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Floor type loaded';

	--Roof Type
	for roofType in (select * from egpt_stg_rooftype order by code)
		loop 
			begin
				select nextval('seq_egpt_roof_type') into v_rooftypepk;
			   	INSERT INTO egpt_roof_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_rooftypepk, roofType.name, upper(substr(replace(replace(replace(roofType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_rooftype set egovcode =v_rooftypepk where code=roofType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Roof Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Roof type loaded';

	--Wood Type
	for woodType in (select * from egpt_stg_woodtype order by code)
		loop 
			begin
				select nextval('seq_egpt_wood_type') into v_woodtypepk;
			   	INSERT INTO egpt_wood_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_woodtypepk, woodType.name, upper(substr(replace(replace(replace(woodType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_woodtype set egovcode =v_woodtypepk where code=woodType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Wood Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Wood type loaded';

	--Wall Type
	for wallType in (select * from egpt_stg_walltype order by code)
		loop 
			begin
				select nextval('seq_egpt_wall_type') into v_walltypepk;
			   	INSERT INTO egpt_wall_type(id, name, code,createddate ,lastmodifieddate,createdby,lastmodifiedby) 
		        VALUES (v_walltypepk, wallType.name, upper(substr(replace(replace(replace(wallType.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_walltype set egovcode =v_walltypepk where code=wallType.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Wall Type failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Wall type loaded';

	--Exemption Master
	for exemption in (select * from egpt_stg_exemption order by code)
		loop 
			begin
				select nextval('seq_egpt_exemption_reason') into v_exemptionpk;
				INSERT INTO egpt_exemption_reason(id, name, code, createddate, lastmodifieddate, createdby, lastmodifiedby)
		        VALUES (v_exemptionpk, exemption.name, upper(substr(replace(replace(replace(exemption.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_exemption set egovcode =v_exemptionpk where code=exemption.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Exemption Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Exemption Master loaded';

	--Apartment Master
	for apartment in (select * from egpt_stg_apartment order by code)
		loop 
			begin
				select nextval('seq_egpt_apartment') into v_apartmentpk;
				INSERT INTO egpt_apartment(id, name, code, createddate, lastmodifieddate, createdby, lastmodifiedby)
		        VALUES (v_apartmentpk, apartment.name, upper(substr(replace(replace(replace(apartment.name,'.',''),' ',''),',',''),1,10)), now(), now(), 1, 1);
				update egpt_stg_apartment set egovcode =v_apartmentpk where code=apartment.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Apartment Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Apartment Master loaded';

	--Occupancy Master
	for occupancy in (select * from egpt_stg_occupancy order by code)
		loop 
			begin
				select nextval('seq_egpt_occupation_type_master') into v_occupancypk;
				INSERT INTO egpt_occupation_type_master(id, occupation, modified_date, occupation_local, code, created_by, modified_by, created_date)
				VALUES (v_occupancypk, occupancy.name, now(), occupancy.name, upper(substr(replace(replace(replace(occupancy.name,'.',''),' ',''),',',''),1,10)), 1, 1, now());
				update egpt_stg_occupancy set egovcode =v_occupancypk where code=occupancy.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Occuapancy Master failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Occuapancy Master loaded';

	--Reasons for title transfer
	for titlereasons in (select * from pt_doctype_mstr_tbl)
		loop 
			begin
				select nextval('SEQ_EGPT_MUTATION_MASTER') into v_titlereason;
				Insert into egpt_mutation_master (ID,MUTATION_NAME,MUTATION_DESC,TYPE,CODE,ORDER_ID)
				VALUES (v_titlereason, titlereasons.vc_doctypedesc, titlereasons.vc_doctypedesc, 'TRANSFER', upper(substr(replace(replace(replace(titlereasons.vc_doctypedesc,'.',''),' ',''),',',''),1,10)), v_occupancypk);

				update egpt_stg_occupancy set egovcode =v_titlereason where code=occupancy.code;	
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'loadAssessmentMaster, loading Reasons for title transfer failed : % %', SQLERRM, SQLSTATE;
			v_isassmasterloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Reasons for title transfer loaded';
EXCEPTION
WHEN OTHERS THEN
raise notice 'loadAssessmentMaster failed : % %', SQLERRM, SQLSTATE;
v_isassmasterloaded := 0;
END;
return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
  
--loadReceipts  
CREATE OR REPLACE FUNCTION loadReceipts()
  RETURNS character varying AS
$BODY$
declare
	v_categorypk 	bigint; 
	v_bndrycategorypk 	bigint;
	v_usagename 	varchar(256); 
	v_classname 	varchar(256); 
	v_catename	 	varchar(64);
	v_isassmasterloaded	bigint default 1;
	unitrate pt_ur_mstr_tbl%ROWTYPE;
BEGIN
	begin
		delete from egpt_property_receipts;
		insert into egpt_property_receipts (id, id_basic_property, booknumber, rcpt_number, rcpt_date, from_date, to_date, rcpt_amount)
		select nextval('seq_egpt_property_receipts'), bp.id, i_bookno, trim(i_slno), dt_rcptdt, dt_paidfrmprddt, dt_paidtoprddt, (d_arrpt + d_arred + d_arrlcs + d_arruauthcnstplty + d_pltyonarr + d_crnpt + d_crned + d_crnlcs + d_crnuauthcnstplty + d_pltyoncrn + d_advamt) from pt_asmtrcpt_tbl rcpt, egpt_basic_property bp where cast(bp.propertyid as int)=rcpt.i_asmtno and rcpt.c_delflag='N';
	EXCEPTION
	WHEN OTHERS THEN
	raise notice 'loadReceipts, loading Unit Rates failed : % %', SQLERRM, SQLSTATE;
	v_isassmasterloaded := 0;
	END;
RAISE NOTICE 'Unit Rates loaded';

return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
  
--loadUnitRates
  CREATE OR REPLACE FUNCTION loadUnitRates()
  RETURNS character varying AS
$BODY$
declare
	v_categorypk 	bigint; 
	v_bndrycategorypk 	bigint;
	v_usagename 	varchar(256); 
	v_classname 	varchar(256); 
	v_catename	 	varchar(64);
	v_isassmasterloaded	bigint default 1;
	unitrate pt_ur_mstr_tbl%ROWTYPE;
BEGIN 

for unitrate in (select * from pt_ur_mstr_tbl order by i_zoneobjid)
	loop 
		begin
			select nextval('seq_egpt_mstr_category') into v_categorypk;
			select nextval('seq_egpt_mstr_bndry_category') into v_bndrycategorypk;
			--raise notice 'unitrate.i_clscode, unitrate.i_bldgusecode % %', unitrate.i_clscode, unitrate.i_bldgusecode;
			select name into v_usagename from egpt_stg_usagemaster where code=unitrate.i_bldgusecode;
			select name into v_classname from egpt_stg_bldgclass_mater where code=unitrate.i_clscode;
			v_catename := upper(substr(replace(replace(replace(v_usagename,'.',''),' ',''),',',''),1,4)) || '-' || upper(substr(replace(replace(replace(v_classname,'.',''),' ',''),',',''),1,4)) || '-' || unitrate.d_ur || '-' || round(random()*1000);

			--raise notice 'v_usagename, v_classname, v_catename, unitrate.dt_wefdate % % % %', v_usagename, v_classname, v_catename, unitrate.dt_wefdate;	
		
			Insert into EGPT_MSTR_CATEGORY (id, category_name, category_amnt, id_installment, is_history, created_by, id_usage, from_date, to_date, modified_by, created_date, modified_date, id_struct_cl) values (v_categorypk, v_catename, unitrate.d_ur, null,'N', 1, (select egovcode from egpt_stg_usagemaster where code=unitrate.i_clscode), unitrate.dt_wefdate, to_date('2099-03-31 00:00:00.0','null'),1, unitrate.ts_dttm, unitrate.ts_dttm, (select egovcode from egpt_stg_bldgclass_mater where code=unitrate.i_bldgusecode));

			Insert into EGPT_MSTR_BNDRY_CATEGORY (id, id_bndry, id_category, modified_date, from_date, to_date, created_by, modified_by, created_date) values (v_bndrycategorypk, (select egovcode from eg_stg_zone where code = unitrate.i_zoneobjid), v_categorypk, unitrate.ts_dttm, unitrate.dt_wefdate, to_date('31-03-2099','DD-MM-YYYY'), 1, 1, unitrate.ts_dttm);

		EXCEPTION
		WHEN OTHERS THEN
		raise notice 'loadUnitRates, loading Unit Rates failed : % %', SQLERRM, SQLSTATE;
		v_isassmasterloaded := 0;
		END;
END LOOP;
RAISE NOTICE 'Unit Rates loaded';

return v_isassmasterloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
-----------------END-------------------
