------------------START---------------------
CREATE OR REPLACE FUNCTION loadzeroblock()
RETURNS character varying AS
$BODY$
declare
v_bndrypk 	bigint; 
v_boundarynum bigint;
v_isbndryloaded	bigint default 1;
v_temp bigint;
blockBndry eg_stg_block%ROWTYPE;
BEGIN
	begin
		v_temp := setval('"seq_boundarynum"', (select max(boundarynum) from eg_boundary where boundarytype=(select id from eg_boundary_type where name='Block')));
	EXCEPTION
	WHEN OTHERS THEN
		create sequence seq_boundarynum;
		v_temp := setval('"seq_boundarynum"', (select max(boundarynum) from eg_boundary where boundarytype=(select id from eg_boundary_type where name='Block')));
	end;
	for blockBndry in (select block.* from eg_stg_block block where block.code=0)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select b.id from eg_boundary b, eg_stg_ward ward, eg_stg_block block where block.wardcode=ward.code and ward.egovcode=b.id and ward.code=blockBndry.wardcode and block.code=blockBndry.code), trim(blockBndry.name) , (select id from eg_boundary_type where name='Block'), blockBndry.name, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_block set egovcode=v_bndrypk where code=blockBndry.code and wardcode=blockBndry.wardcode;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'block loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0; 
			END;
	END LOOP;
	RAISE NOTICE 'Zero block loaded';

return v_isbndryloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
------------------END---------------------
