------------------START---------------------
CREATE OR REPLACE FUNCTION loadzeroblock()
RETURNS character varying AS
$BODY$
declare
v_bndrypk 	bigint; 
v_boundarynum bigint;
v_isbndryloaded	bigint default 1;
v_temp bigint;
blockBndry eg_stg_block%ROWTYPE;
BEGIN
	v_temp := setval('"seq_boundarynum"', (select max(boundarynum) from eg_boundary where boundarytype=(select id from eg_boundary_type where name='Block')));
	for blockBndry in (select block.* from eg_stg_block block where block.code=0)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select b.id from eg_boundary b, eg_stg_ward ward, eg_stg_block block where block.wardcode=ward.code and ward.egovcode=b.id and ward.code=blockBndry.wardcode and block.code=blockBndry.code), trim(blockBndry.name) , (select id from eg_boundary_type where name='Block'), blockBndry.name, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_block set egovcode=v_bndrypk where code=blockBndry.code and wardcode=blockBndry.wardcode;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'block loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0; 
			END;
	END LOOP;
	RAISE NOTICE 'Zero block loaded';

return v_isbndryloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
------------------END---------------------

------------------START---------------------
CREATE OR REPLACE FUNCTION reloadcrosslink()
  RETURNS character varying AS
$BODY$
declare
	v_bndrypk 	bigint;  
	v_isbndryloaded	bigint default 1;
	v_blocktype 	bigint; 
	v_localitytype 	bigint;
	v_wardtype		bigint;
	v_citytype      bigint;
	v_eleward		bigint;
	v_admcitybndryid	bigint;
	mapBndry eg_stg_boundary_map%ROWTYPE;
BEGIN 
begin
	--removing existig cross links
	delete from eg_crosshierarchy;
	--block and locality map
	select id into v_blocktype from eg_boundary_type where name='Block' and hierarchytype = (select id from eg_hierarchy_type where name='REVENUE');
	select id into v_localitytype from eg_boundary_type where name='Locality' and hierarchytype = (select id from eg_hierarchy_type where name='LOCATION');
	select id into v_citytype from eg_boundary_type where name='City' and hierarchytype = (select id from eg_hierarchy_type where name='ADMINISTRATION');
	select id into v_wardtype from eg_boundary_type where name='Ward' and hierarchytype = (select id from eg_hierarchy_type where name='ADMINISTRATION');
	select b.id into v_admcitybndryid from eg_boundary b where b.boundarytype=v_citytype;
	for mapBndry in (select * from eg_stg_boundary_map where zonecode is not null and zonecode!=0 and wardcode is not null and wardcode!=0 and blockcode is not null and localitycode is not null and localitycode!=0)
		loop 
			--raise notice 'mapBndry.wardcode, mapBndry.blockcode, mapBndry.localitycode : % % %', mapBndry.wardcode, mapBndry.blockcode, mapBndry.localitycode;
			begin
				--Revenue Block and locality cross linkage
				INSERT INTO eg_crosshierarchy (id, parent, child, parenttype, childtype) values (nextval('seq_eg_crosshierarchy'), (select b.id from eg_boundary b, eg_stg_block  block where block.code= mapBndry.blockcode and block.egovcode=b.id and block.wardcode=mapBndry.wardcode), (select b.id from eg_boundary b, eg_stg_locality loc where loc.code=mapBndry.localitycode and loc.egovcode=b.id), v_blocktype, v_localitytype);
				--RAISE NOTICE 'Block and locality are done';
				--Admin Ward and locality cross linkage
				select b.id into v_eleward from eg_boundary b, eg_stg_election eleward where eleward.code= mapBndry.electionwardcode and eleward.egovcode=b.id;
				--raise notice 'v_eleward : %', v_eleward;
				if(v_eleward is NULL) then
				INSERT INTO eg_crosshierarchy (id, parent, child, parenttype, childtype) values (nextval('seq_eg_crosshierarchy'), v_admcitybndryid, (select b.id from eg_boundary b, eg_stg_locality loc where loc.code=mapBndry.localitycode and loc.egovcode=b.id), v_wardtype, v_localitytype);
				else
				INSERT INTO eg_crosshierarchy (id, parent, child, parenttype, childtype) values (nextval('seq_eg_crosshierarchy'), v_eleward, (select b.id from eg_boundary b, eg_stg_locality loc where loc.code=mapBndry.localitycode and loc.egovcode=b.id), v_wardtype, v_localitytype);
				end if;
				--RAISE NOTICE 'Admin Ward and locality are done';
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'Boundary Mapping re-lading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Boundary Mapping re loaded';

EXCEPTION
WHEN OTHERS THEN
raise notice 'Boundary Mapping re-lading failed : % %', SQLERRM, SQLSTATE;
v_isbndryloaded := 0; 
END;
return v_isbndryloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
------------------END---------------------
