--loadboundary
CREATE OR REPLACE FUNCTION loadboundary(cityname character varying)
  RETURNS character varying AS
$BODY$
declare
	v_bndrypk 	bigint;  
	v_isbndryloaded	bigint default 1;
	v_blocktype 	bigint; 
	v_localitytype 	bigint;
	v_wardtype		bigint;
	v_boundarynum 	bigint;
	v_citytype      bigint;
	v_eleward		bigint;
	v_cityname		varchar(256);
	v_admcitybndryid	bigint;
	zoneBndry eg_stg_zone%ROWTYPE;
	wardBndry eg_stg_ward%ROWTYPE;
	locationBndry eg_stg_locality%ROWTYPE;
	blockBndry eg_stg_block%ROWTYPE;
	election eg_stg_election%ROWTYPE;
	mapBndry eg_stg_boundary_map%ROWTYPE;
	streetBndry eg_stg_street%ROWTYPE;
BEGIN 
begin

	--city
	select name into v_cityname from eg_boundary where boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='ADMINISTRATION')) and name=cityName;
	RAISE NOTICE 'Admin city found (%)', v_cityname;
	if (v_cityname is NULL) then 
	INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (nextval('seq_eg_boundary'),1, null, cityName , (select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='ADMINISTRATION')), cityName, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);
	end if;

	select name into v_cityname from eg_boundary where boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='REVENUE')) and name=cityName;
	RAISE NOTICE 'Revenue city found (%)', v_cityname;
	if (v_cityname is NULL) then 
	INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (nextval('seq_eg_boundary'),1, null, cityName , (select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='REVENUE')), cityName, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);
	end if;

	select name into v_cityname from eg_boundary where boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='LOCATION')) and name=cityName;
	RAISE NOTICE 'Locality city found (%)', v_cityname;
	if (v_cityname is NULL) then 
	INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (nextval('seq_eg_boundary'),1, null, cityName , (select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='LOCATION')), cityName, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);
	end if;

	RAISE NOTICE 'City loaded';
	--zone
	begin
	drop sequence seq_boundarynum;
	create sequence seq_boundarynum;
	EXCEPTION
	WHEN OTHERS THEN
	create sequence seq_boundarynum;
	END;
	for zoneBndry in (select zone.* from eg_stg_zone zone)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select id from eg_boundary where name=cityName and boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='REVENUE'))), trim(zoneBndry.name) , (select id from eg_boundary_type where name='Zone'), zoneBndry.name, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_zone zone set egovcode=v_bndrypk where code=zoneBndry.code;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'zone loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Zones loaded';

	--ward
	drop sequence seq_boundarynum;
	create sequence seq_boundarynum;
	for wardBndry in (select ward.* from eg_stg_ward ward)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select id from eg_boundary where name=cityName and boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='REVENUE'))), trim(wardBndry.name) , (select id from eg_boundary_type where name='Ward' and hierarchytype=(select id from eg_hierarchy_type where name='REVENUE')), trim(wardBndry.name), null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_ward set egovcode=v_bndrypk where code=wardBndry.code;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'ward loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Ward loaded';


	--block
	drop sequence seq_boundarynum;
	create sequence seq_boundarynum;
	for blockBndry in (select block.* from eg_stg_block block)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select b.id from eg_boundary b, eg_stg_ward ward, eg_stg_block block where block.wardcode=ward.code and ward.egovcode=b.id and ward.code=blockBndry.wardcode and block.code=blockBndry.code), trim(blockBndry.name) , (select id from eg_boundary_type where name='Block'), blockBndry.name, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_block set egovcode=v_bndrypk where code=blockBndry.code;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'block loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0; 
			END;
	END LOOP;
	RAISE NOTICE 'Block loaded';


	--locality
	drop sequence seq_boundarynum;
	create sequence seq_boundarynum;
	for locationBndry in (select * from eg_stg_locality)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select id from eg_boundary where name=cityName and boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='LOCATION'))), trim(locationBndry.name) , (select id from eg_boundary_type where name='Locality'), locationBndry.name, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_locality set egovcode=v_bndrypk where code=locationBndry.code;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'locality loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Locality loaded';

	--election ward
	drop sequence seq_boundarynum;
	create sequence seq_boundarynum;
	for election in (select * from eg_stg_election)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select id from eg_boundary where name=cityName and boundarytype=(select id from eg_boundary_type where name='City' and hierarchytype=(select id from eg_hierarchy_type where name='ADMINISTRATION'))), trim(election.name) , (select id from eg_boundary_type where name='Ward' and hierarchytype=(select id from eg_hierarchy_type where name='ADMINISTRATION')), election.name, null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_election set egovcode=v_bndrypk where code=election.code;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'election ward loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0; 
			END;
	END LOOP;
	RAISE NOTICE 'election loaded';

	--Street
	drop sequence seq_boundarynum;
	create sequence seq_boundarynum;
	for streetBndry in (select * from eg_stg_street)
		loop 
			begin
				select nextval('seq_eg_boundary') into v_bndrypk;
				select nextval('seq_boundarynum') into v_boundarynum;
				INSERT INTO eg_boundary (id, boundarynum, parent, name, boundarytype, localname, bndry_name_old_local, fromdate, todate, bndryid, longitude, latitude, materializedpath, ishistory, createddate, lastmodifieddate, createdby, lastmodifiedby) values (v_bndrypk, v_boundarynum, (select egovcode from eg_stg_locality where locality_code=streetBndry.code), trim(streetBndry.name) , (select id from eg_boundary_type where name='Locality'), trim(streetBndry.name), null, to_date('01/04/2004 00:00:00', 'dd/mm/yyyy hh24:mi:ss'), to_date('01/04/2099 23:59:59', 'dd/mm/yyyy hh24:mi:ss'), null, null, null, null, 'N',  now(), now(), 1, 1);

			update eg_stg_street set egovcode=v_bndrypk where code=streetBndry.code;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'Street loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Street loaded';
	--block and locality map
	select id into v_blocktype from eg_boundary_type where name='Block' and hierarchytype = (select id from eg_hierarchy_type where name='REVENUE');
	select id into v_localitytype from eg_boundary_type where name='Locality' and hierarchytype = (select id from eg_hierarchy_type where name='LOCATION');
	select id into v_citytype from eg_boundary_type where name='City' and hierarchytype = (select id from eg_hierarchy_type where name='ADMINISTRATION');
	select id into v_wardtype from eg_boundary_type where name='Ward' and hierarchytype = (select id from eg_hierarchy_type where name='ADMINISTRATION');
	select b.id into v_admcitybndryid from eg_boundary b where b.boundarytype=v_citytype;
	for mapBndry in (select * from eg_stg_boundary_map where zonecode is not null and zonecode!=0 and wardcode is not null and wardcode!=0 and blockcode is not null and blockcode!=0 and localitycode is not null and localitycode!=0)
		loop 
			--raise notice 'mapBndry.wardcode, mapBndry.blockcode, mapBndry.localitycode : % % %', mapBndry.wardcode, mapBndry.blockcode, mapBndry.localitycode;
			begin
				--Revenue Block and locality cross linkage
				INSERT INTO eg_crosshierarchy (id, parent, child, parenttype, childtype) values (nextval('seq_eg_crosshierarchy'), (select b.id from eg_boundary b, eg_stg_block  block where block.code= mapBndry.blockcode and block.egovcode=b.id), (select b.id from eg_boundary b, eg_stg_locality loc where loc.code=mapBndry.localitycode and loc.egovcode=b.id), v_blocktype, v_localitytype);

				--Admin Ward and locality cross linkage
				select b.id into v_eleward from eg_boundary b, eg_stg_election eleward where eleward.code= mapBndry.electionwardcode and eleward.egovcode=b.id;

				if(v_eleward is NULL) then
				INSERT INTO eg_crosshierarchy (id, parent, child, parenttype, childtype) values (nextval('seq_eg_crosshierarchy'), v_admcitybndryid, (select b.id from eg_boundary b, eg_stg_locality loc where loc.code=mapBndry.localitycode and loc.egovcode=b.id), v_citytype, v_localitytype);
				else
				INSERT INTO eg_crosshierarchy (id, parent, child, parenttype, childtype) values (nextval('seq_eg_crosshierarchy'), v_eleward, (select b.id from eg_boundary b, eg_stg_locality loc where loc.code=mapBndry.localitycode and loc.egovcode=b.id), v_wardtype, v_localitytype);
				end if;
			EXCEPTION
			WHEN OTHERS THEN
			raise notice 'Boundary Mapping loading failed : % %', SQLERRM, SQLSTATE;
			v_isbndryloaded := 0;
			END;
	END LOOP;
	RAISE NOTICE 'Boundary Mapping loaded';

EXCEPTION
WHEN OTHERS THEN
raise notice 'Load Boundary failed : % %', SQLERRM, SQLSTATE;
v_isbndryloaded := 0; 
END;
return v_isbndryloaded;
END; 
$BODY$
  LANGUAGE plpgsql;
