/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.reports;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.search.contract.HoardingDcbReport;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.HoardingCategoryService;
import org.egov.adtax.web.controller.GenericController;
import org.egov.infra.config.core.LocalizationSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class AgencyReportController
extends GenericController {
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private HoardingCategoryService hoardingCategoryService;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;

    @ModelAttribute(value="advertisementPermitDetail")
    public AdvertisementPermitDetail advertisementPermitDetail() {
        return new AdvertisementPermitDetail();
    }

    @ModelAttribute(value="hoardingCategories")
    public List<HoardingCategory> hoardingCategories() {
        return this.hoardingCategoryService.getAllActiveHoardingCategory();
    }

    @RequestMapping(value={"/dcbreport-search"}, method={RequestMethod.GET})
    public String searchAgencyWiseHoardingForm(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail) {
        return "report-agencywise";
    }

    @RequestMapping(value={"/getAgencyWiseDcb"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void agencyWiseViewHoarding(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, @RequestParam String agency, HttpServletResponse response) throws IOException {
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAgencyWiseAdvertisementSearchResult(advertisementPermitDetail)) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/report-view"}, method={RequestMethod.GET})
    public String agencywiseReport(@RequestParam(value="id") String id, @RequestParam(value="category") String category, @RequestParam(value="subcategory") String subcategory, @RequestParam(value="zone") String zone, @RequestParam(value="ward") String ward, @RequestParam(value="ownerDetail") String ownerDetail, Model model) {
        Long categoryid = category != null ? Long.valueOf(Long.parseLong(category)) : null;
        Long subcategoryid = subcategory != null ? Long.valueOf(Long.parseLong(subcategory)) : null;
        Long zoneid = zone != null ? Long.valueOf(Long.parseLong(zone)) : null;
        Long wardid = ward != null ? Long.valueOf(Long.parseLong(ward)) : null;
        List advertisementPermitDetail = this.advertisementPermitDetailService.getAdvertisementPermitDetailBySearchParam(Long.valueOf(Long.parseLong(id)), categoryid, subcategoryid, zoneid, wardid, ownerDetail);
        if (advertisementPermitDetail != null && !advertisementPermitDetail.isEmpty()) {
            model.addAttribute("agency", (Object)((AdvertisementPermitDetail)advertisementPermitDetail.get(0)).getAgency().getName());
        } else {
            model.addAttribute("agency", (Object)"");
        }
        model.addAttribute("dcbResult", (Object)this.getAgencyWiseDCBResult(advertisementPermitDetail));
        return "report-agencywise-view";
    }

    private List<HoardingDcbReport> getAgencyWiseDCBResult(List<AdvertisementPermitDetail> advertisementPermitDetail) {
        ArrayList<HoardingDcbReport> hoardingDcbReportResults = new ArrayList<HoardingDcbReport>();
        for (AdvertisementPermitDetail advpermitdetail : advertisementPermitDetail) {
            if (advpermitdetail.getAgency() == null || advpermitdetail.getAdvertisement() == null || advpermitdetail.getAdvertisement().getDemandId() == null) continue;
            HoardingDcbReport hoardingReport = new HoardingDcbReport();
            Map demandWiseFeeDetail = this.advertisementDemandService.checkPendingAmountByDemand(advpermitdetail);
            hoardingReport.setDemandAmount((BigDecimal)demandWiseFeeDetail.get("Demand"));
            hoardingReport.setCollectedAmount((BigDecimal)demandWiseFeeDetail.get(" Total Collection"));
            hoardingReport.setPendingAmount((BigDecimal)demandWiseFeeDetail.get("PENDINGDEMANDAMOUNT"));
            hoardingReport.setPenaltyAmount((BigDecimal)demandWiseFeeDetail.get("PENALTYAMOUNT"));
            hoardingReport.setAdditionalTaxAmount((BigDecimal)demandWiseFeeDetail.get("ADDITIONALTAXAMOUNT"));
            hoardingReport.setApplicationNumber(advpermitdetail.getApplicationNumber());
            hoardingReport.setPermissionNumber(advpermitdetail.getPermissionNumber());
            hoardingReport.setAgencyName(advpermitdetail.getAgency().getName());
            hoardingReport.setCategory(advpermitdetail.getAdvertisement().getCategory().getName());
            hoardingReport.setSubcategory(advpermitdetail.getAdvertisement().getSubCategory().getDescription());
            hoardingReport.setOwnerDetail(advpermitdetail.getOwnerDetail());
            hoardingDcbReportResults.add(hoardingReport);
        }
        return hoardingDcbReportResults;
    }
}

