/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.notice;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.notice.AdvertisementNoticeService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/advertisement"})
public class AdvertisementNoticeController {
    private static final String DEMAND_NOTICE = "demand_notice_";
    private static final String PERMIT_ORDER = "permit_order_";
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AdvertisementNoticeService advertisementNoticeService;
    @Autowired
    private CityService cityService;

    @GetMapping(value={"/permitOrder"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> generatePermitOrder(HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(request.getParameter("pathVar")));
        ReportOutput reportOutput = this.advertisementNoticeService.generatePermitOrder(advertisementPermitDetail, this.getUlbDetails(request));
        reportOutput.setReportName(StringUtils.append((String)PERMIT_ORDER, (String)advertisementPermitDetail.getAdvertisement().getAdvertisementNumber()));
        reportOutput.setReportDisposition(ReportDisposition.INLINE);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }

    @GetMapping(value={"/demandNotice"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> generateDemandNotice(HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(request.getParameter("pathVar")));
        ReportOutput reportOutput = this.advertisementNoticeService.generateDemandNotice(advertisementPermitDetail, this.getUlbDetails(request));
        reportOutput.setReportName(StringUtils.append((String)DEMAND_NOTICE, (String)advertisementPermitDetail.getAdvertisement().getAdvertisementNumber()));
        reportOutput.setReportDisposition(ReportDisposition.INLINE);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }

    @GetMapping(value={"/demandNotice/{id}"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> viewDemandNoticeReport(@PathVariable Long id, HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetails = this.advertisementPermitDetailService.findBy(id);
        ReportOutput reportOutput = this.advertisementNoticeService.generateDemandNotice(advertisementPermitDetails, this.getUlbDetails(request));
        reportOutput.setReportName(StringUtils.append((String)DEMAND_NOTICE, (String)advertisementPermitDetails.getAdvertisement().getAdvertisementNumber()));
        reportOutput.setReportDisposition(ReportDisposition.INLINE);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }

    @GetMapping(value={"/permitOrder/{id}"})
    @ResponseBody
    public ResponseEntity<InputStreamResource> viewPermitOrderReport(@PathVariable Long id, HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetails = this.advertisementPermitDetailService.findBy(id);
        if (!"ADTAXPERMITGENERATED".equalsIgnoreCase(advertisementPermitDetails.getStatus().getCode())) {
            this.advertisementPermitDetailService.updateStateTransition(advertisementPermitDetails, Long.valueOf(0L), "", "CREATEADVERTISEMENT", "GENERATE PERMIT ORDER");
        }
        ReportOutput reportOutput = this.advertisementNoticeService.generatePermitOrder(advertisementPermitDetails, this.getUlbDetails(request));
        reportOutput.setReportName(StringUtils.append((String)PERMIT_ORDER, (String)advertisementPermitDetails.getAdvertisement().getAdvertisementNumber()));
        reportOutput.setReportDisposition(ReportDisposition.INLINE);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }

    private Map<String, Object> getUlbDetails(HttpServletRequest request) {
        HashMap<String, Object> ulbDetailsReportParams = new HashMap<String, Object>();
        ulbDetailsReportParams.put("cityName", request.getSession().getAttribute("cityname").toString());
        ulbDetailsReportParams.put("logoPath", this.cityService.getCityLogoURL());
        ulbDetailsReportParams.put("ulbName", this.cityService.getMunicipalityName());
        return ulbDetailsReportParams;
    }
}

