/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.mobile;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementService;
import org.egov.adtax.service.collection.AdvertisementBillServiceImpl;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.ptis.client.integration.utils.SpringBeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/mobile"})
public class AdtaxMobilePaymentController {
    private static final String MESSAGE = "message";
    @Autowired
    private AdvertisementBillServiceImpl advertisementBillServiceImpl;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AdvertisementService advertisementService;
    private static final String PAYTAX_FORM = "mobilePayment-form";
    private static final String COLLECT_ADVTAX_ERROR = "collectAdvtax-error";

    @RequestMapping(value={"/payAdtax/{advertisementNo},{ulbCode},{amountToBePaid},{mobileNumber},{emailId}"}, method={RequestMethod.GET})
    public String collectTax(Model model, @PathVariable String advertisementNo, @PathVariable String ulbCode, @PathVariable BigDecimal amountToBePaid, @PathVariable String mobileNumber, @PathVariable String emailId, HttpServletRequest request) {
        String redirectUrl = "";
        Advertisement advertisement = null;
        if (advertisementNo != null) {
            advertisement = this.advertisementService.findByAdvertisementNumber(advertisementNo);
        }
        if (amountToBePaid.compareTo(this.advertisementDemandService.getPendingTaxAmount(advertisement)) > 0) {
            model.addAttribute(MESSAGE, (Object)"msg.PaidAmount.greaterthan.Total");
            return COLLECT_ADVTAX_ERROR;
        }
        BillInfoImpl billInfo = this.advertisementBillServiceImpl.getBillInfo(amountToBePaid, advertisement);
        if (billInfo != null) {
            PaymentRequest paymentRequest = SpringBeanUtil.getCollectionIntegrationService().processMobilePayments(billInfo);
            if (paymentRequest != null) {
                for (Object obj : paymentRequest.getRequestParameters().values()) {
                    redirectUrl = obj.toString();
                }
                model.addAttribute("redirectUrl", (Object)redirectUrl);
            }
        } else {
            model.addAttribute(MESSAGE, (Object)"Bill data is incorrect");
            return COLLECT_ADVTAX_ERROR;
        }
        return PAYTAX_FORM;
    }
}

