/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.SubCategoryService;
import org.egov.adtax.web.controller.GenericController;
import org.egov.adtax.workflow.AdvertisementWorkFlowService;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.config.core.LocalizationSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hoarding"})
public class SearchHoardingController
extends GenericController {
    private static final String RENEWAL_SEARCH = "renewal-search";
    private static final String HOARDING_SEARCH_FOR_UPDATE = "hoarding-search-for-update";
    private static final String HOARDING_SEARCH = "hoarding-search";
    private static final String ADVERTISEMENT_SEARCH = "advertisement-search";
    private static final String DATA = "{ \"data\":";
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private SubCategoryService subCategoryService;
    @Autowired
    private AdvertisementWorkFlowService advertisementWorkFlowService;

    @ModelAttribute
    public AdvertisementPermitDetail advertisementPermitDetail() {
        return new AdvertisementPermitDetail();
    }

    @RequestMapping(value={"/getsubcategories-by-category"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SubCategory> hoardingSubcategories(@RequestParam Long categoryId) {
        return this.subCategoryService.getAllActiveSubCategoryByCategoryId(categoryId);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return HOARDING_SEARCH;
    }

    @RequestMapping(value={"/adtax-search"}, method={RequestMethod.GET})
    public String searchAdtaxForm() {
        return ADVERTISEMENT_SEARCH;
    }

    @RequestMapping(value={"/getsearch-adtax-result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchAdtaxResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IOUtils.write((String)(DATA + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetail, "Advertisement")) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/hoarding-search-list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String searchType = request.getParameter("searchType");
        IOUtils.write((String)(DATA + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetail, searchType)) + "}"), (Writer)response.getWriter());
    }

    public String commonSearchResult(AdvertisementPermitDetail advertisementPermitDetail, String searchType) {
        List searchResult = this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetail, searchType);
        return DATA + searchResult + "}";
    }

    @RequestMapping(value={"findhoarding-for-update"}, method={RequestMethod.GET})
    public String searchHoardingForm(@ModelAttribute HoardingSearch hoardingSearch) {
        return HOARDING_SEARCH_FOR_UPDATE;
    }

    @RequestMapping(value={"findhoarding-for-update"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchHoarding(@ModelAttribute HoardingSearch hoardingSearch) {
        return DATA + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(hoardingSearch, "searchLegacyRecord")) + "}";
    }

    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String viewHoarding(@PathVariable String id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        model.addAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        model.addAttribute("arrearTax", (Object)this.advertisementDemandService.getPendingArrearsTax(advertisementPermitDetail));
        model.addAttribute("previousFinancialYear", (Object)this.financialYearDAO.getPreviousFinancialYearByDate(new Date()));
        model.addAttribute("applicationHistory", (Object)this.advertisementWorkFlowService.getHistory(advertisementPermitDetail));
        return "hoarding-view";
    }

    @RequestMapping(value={"/renewal-search"}, method={RequestMethod.GET})
    public String renewalSearchForm() {
        return RENEWAL_SEARCH;
    }

    @RequestMapping(value={"/renewl-search-result"}, method={RequestMethod.GET})
    @ResponseBody
    public void renewSearchResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IOUtils.write((String)(DATA + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.advertisementPermitDetailService.getRenewalAdvertisementSearchResult(advertisementPermitDetail, "Advertisement")) + "}"), (Writer)response.getWriter());
    }
}

