/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import java.util.Date;
import javax.validation.Valid;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class CreateLegacyAdvertisementController
extends HoardingControllerSupport {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private SecurityUtils securityUtils;

    @RequestMapping(value={"adtaxCreateLegacy"}, method={RequestMethod.GET})
    public String createLegacyHoardingForm(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail) {
        if (advertisementPermitDetail != null) {
            if (advertisementPermitDetail.getAdvertisement() == null) {
                advertisementPermitDetail.setAdvertisement(new Advertisement());
            }
            advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.ACTIVE);
            advertisementPermitDetail.getAdvertisement().setLegacy(Boolean.TRUE);
        }
        return "hoarding-createLegacy";
    }

    private void validateLegacyApplicationDate(AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder) {
        Installment installmentObj;
        if (advertisementPermitDetail != null && advertisementPermitDetail.getApplicationDate() != null && (installmentObj = this.advertisementDemandService.getCurrentInstallment()) != null && installmentObj.getToDate() != null && advertisementPermitDetail.getApplicationDate().after(DateUtils.endOfDay((Date)installmentObj.getToDate()))) {
            resultBinder.rejectValue("applicationDate", "invalid.applicationDateForLegacy");
        }
    }

    @RequestMapping(value={"adtaxCreateLegacy"}, method={RequestMethod.POST})
    public String createLegacyHoarding(@Valid @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib) {
        User currentUser = this.securityUtils.getCurrentUser();
        this.validateHoardingDocs(advertisementPermitDetail, resultBinder);
        this.validateAdvertisementDetails(advertisementPermitDetail, resultBinder);
        this.validateLegacyApplicationDate(advertisementPermitDetail, resultBinder);
        if (resultBinder.hasErrors()) {
            return "hoarding-createLegacy";
        }
        this.storeHoardingDocuments(advertisementPermitDetail);
        if (advertisementPermitDetail != null) {
            advertisementPermitDetail.setIsActive(Boolean.TRUE);
            advertisementPermitDetail.setStatus(this.advertisementPermitDetailService.getStatusByModuleAndCode("ADTAXPERMITGENERATED"));
            Installment installmentObj = this.advertisementDemandService.getCurrentInstallment();
            if (installmentObj != null && installmentObj.getFromDate() != null) {
                advertisementPermitDetail.getAdvertisement().setPenaltyCalculationDate(installmentObj.getFromDate());
            }
        }
        AdvertisementPermitDetail advertisementPermitDetailObj = this.advertisementPermitDetailService.createAdvertisementPermitDetail(advertisementPermitDetail, null, null, null, null, currentUser);
        String message = this.messageSource.getMessage("hoarding.create.success", (Object[])new String[]{advertisementPermitDetailObj.getAdvertisement().getAdvertisementNumber(), advertisementPermitDetailObj.getApplicationNumber(), advertisementPermitDetailObj.getPermissionNumber()}, null);
        redirAttrib.addFlashAttribute("message", (Object)message);
        return "redirect:/hoarding/success/" + advertisementPermitDetailObj.getId();
    }

    @RequestMapping(value={"/checkUnique-advertisementNo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean uniqueAgendaNumber(@RequestParam String hoardingNumber) {
        return this.advertisementService.findByAdvertisementNumber(hoardingNumber) == null;
    }
}

