/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.adtax.entity.AdvertisementReassignDetails;
import org.egov.adtax.service.ReassignAdvertisementService;
import org.egov.adtax.workflow.AdvertisementWorkFlowService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reassignadvertisement/{applicationId}/{applicationType}"})
public class AdvertisementReassignController {
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private ReassignAdvertisementService reassignAdvertisementService;
    @Autowired
    private AdvertisementWorkFlowService advertisementWorkFlowService;
    @Autowired
    private PositionMasterService positionMasterService;
    private static final String SUCCESSMESSAGE = "successMessage";
    @Autowired
    protected ResourceBundleMessageSource messageSource;

    @ModelAttribute
    public AdvertisementReassignDetails reassign() {
        return new AdvertisementReassignDetails();
    }

    public Long getLoggedInPositiontionId() {
        Position position = null;
        Long userId = ApplicationThreadLocals.getUserId();
        if (userId != null && userId.intValue() != 0) {
            position = this.positionMasterService.getPositionByUserId(userId);
        }
        return position.getId();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String getReassign(@ModelAttribute(value="reassign") AdvertisementReassignDetails reassignInfo, Model model, @PathVariable String applicationType, @PathVariable Long applicationId, HttpServletRequest request) {
        String designationStr = this.advertisementWorkFlowService.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.advertisementWorkFlowService.getDepartmentForCscOperatorWorkFlow();
        String[] departments = departmentStr.split(",");
        String[] designations = designationStr.split(",");
        Department dept = null;
        HashMap<Long, String> employeeWithPosition = new HashMap<Long, String>();
        for (String department : departments) {
            dept = this.departmentService.getDepartmentByName(department);
            for (String designationName : Arrays.asList(designations)) {
                List desig = this.designationService.getDesignationsByName(designationName);
                for (Designation designation : desig) {
                    List assignments = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(dept.getId(), designation.getId(), new Date());
                    if (assignments.isEmpty()) continue;
                    for (Assignment assignment : assignments) {
                        if (assignment == null || assignment.getPosition() == null || this.getLoggedInPositiontionId().equals(assignment.getPosition().getId())) continue;
                        employeeWithPosition.put(assignment.getPosition().getId(), assignment.getEmployee().getName().concat("/").concat(assignment.getPosition().getName()));
                        model.addAttribute("assignments", employeeWithPosition);
                    }
                }
            }
        }
        if (employeeWithPosition.isEmpty()) {
            model.addAttribute("message", (Object)this.messageSource.getMessage("notexists.position", (Object[])new String[0], null));
        }
        reassignInfo.setApplicationId(applicationId);
        reassignInfo.setStateType(applicationType);
        return "advertisement-reassign";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String update(@ModelAttribute(value="reassign") AdvertisementReassignDetails reassignInfo, Model model, @Valid BindingResult errors, HttpServletRequest request) {
        Long positionId = Long.valueOf(request.getParameter("approvalPosition"));
        Position position = this.positionMasterService.getPositionById(positionId);
        Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(positionId).get(0);
        String appNo = this.reassignAdvertisementService.getStateObject(reassignInfo, position);
        if (StringUtils.isNotEmpty((CharSequence)appNo)) {
            String successMessage = "Avertisement Tax application with application number : " + appNo + " successfully re-assigned to " + assignment.getEmployee().getName() + "~" + assignment.getDesignation().getName() + ":" + assignment.getDepartment().getCode();
            model.addAttribute(SUCCESSMESSAGE, (Object)successMessage);
        } else {
            model.addAttribute(SUCCESSMESSAGE, (Object)"Reassign Failed!");
        }
        return "reassign-success";
    }
}

