/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.deactivate;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.Agency;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.AgencyService;
import org.egov.adtax.service.SubCategoryService;
import org.egov.adtax.web.controller.GenericController;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.config.core.LocalizationSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/deactivate"})
public class DeactivateAdvertisementController
extends GenericController {
    private final AgencyService agencyService;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private SubCategoryService subCategoryService;

    @Autowired
    public DeactivateAdvertisementController(AgencyService agencyService) {
        this.agencyService = agencyService;
    }

    @ModelAttribute
    public Agency agency() {
        return new Agency();
    }

    @ModelAttribute(value="agencies")
    public List<Agency> getAgencies() {
        return this.agencyService.findAll();
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET})
    public String changeStatus(@ModelAttribute(value="advertisementPermitDetailStatus") AdvertisementPermitDetail advertisementPermitDetailStatus, @PathVariable String applicationNumber, BindingResult result, Model model) {
        model.addAttribute("advertisementPermitDetailStatus", (Object)this.advertisementPermitDetailService.findByApplicationNumber(applicationNumber));
        return "statusChange-result";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String statusChange(Model model) {
        model.addAttribute("advertisementPermitDetailRecord", (Object)new AdvertisementPermitDetail());
        return "statuschange-search";
    }

    @RequestMapping(value={"/activerecord-list-search"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetailRecord, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String searchType = request.getParameter("searchType");
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)this.advertisementPermitDetailService.getActiveAdvertisementSearchResult(advertisementPermitDetailRecord, searchType)) + "}"), (Writer)response.getWriter());
    }

    public String commonSearchResult(AdvertisementPermitDetail advertisementPermitDetailRecord, String searchType) {
        List searchResult = this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetailRecord, searchType);
        return "{ \"data\":" + searchResult + "}";
    }

    @RequestMapping(value={"/subcategories-by-categoryselect"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SubCategory> hoardingSubcategories(@RequestParam Long categoryId) {
        return this.subCategoryService.getAllActiveSubCategoryByCategoryId(categoryId);
    }

    @RequestMapping(value={"/result/{id}"}, method={RequestMethod.GET})
    public String viewHoardingByApplicationNumber(@PathVariable Long id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findById(id);
        if (advertisementPermitDetail != null && advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getStatus() != null && advertisementPermitDetail.getAdvertisement().getStatus().equals((Object)AdvertisementStatus.WORKFLOW_IN_PROGRESS)) {
            model.addAttribute("message", (Object)"msg.deactivate.alreadyInWorkFlow");
            return "deactive-error";
        }
        if (advertisementPermitDetail != null && advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getStatus() != null && advertisementPermitDetail.getAdvertisement().getStatus().equals((Object)AdvertisementStatus.ACTIVE) && advertisementPermitDetail.getStatus() != null && advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
            model.addAttribute("message", (Object)"msg.deactivate.paymentPending");
            return "deactive-error";
        }
        Set demandDetails = new HashSet();
        demandDetails = advertisementPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalCollectedAmount = BigDecimal.ZERO;
        BigDecimal pendingTax = BigDecimal.ZERO;
        for (EgDemandDetails demandObject : demandDetails) {
            totalAmount = totalAmount.add(demandObject.getAmount());
            totalCollectedAmount = totalCollectedAmount.add(demandObject.getAmtCollected());
        }
        pendingTax = totalAmount.subtract(totalCollectedAmount);
        advertisementPermitDetail.getAdvertisement().setPendingTax(pendingTax);
        model.addAttribute("advertisementPermitDetailStatus", (Object)advertisementPermitDetail);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        model.addAttribute("applicationDate", (Object)sdf.format(advertisementPermitDetail.getApplicationDate()));
        return "statusChange-deactivate";
    }

    @RequestMapping(value={"/deactive/{id}"}, method={RequestMethod.POST})
    public String deactivate(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetailStatus, Model model, @PathVariable Long id) {
        AdvertisementPermitDetail existingRateObject = this.advertisementPermitDetailService.findById(id);
        if (existingRateObject != null) {
            existingRateObject.setDeactivation_remarks(advertisementPermitDetailStatus.getDeactivation_remarks());
            existingRateObject.setDeactivation_date(advertisementPermitDetailStatus.getDeactivation_date());
            existingRateObject.getAdvertisement().setStatus(AdvertisementStatus.INACTIVE);
            this.advertisementPermitDetailService.updateAdvertisementPermitDetail(existingRateObject);
        }
        return "statusChange-success";
    }

    @RequestMapping(value={"agencies"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Agency> findAgencies(@RequestParam String name) {
        return this.agencyService.findAllByNameLike(name);
    }
}

