/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.common;

import java.util.Date;
import java.util.List;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.HoardingDocument;
import org.egov.adtax.entity.HoardingDocumentType;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.entity.RevenueInspector;
import org.egov.adtax.entity.UnitOfMeasure;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.AdvertisementRateService;
import org.egov.adtax.service.AdvertisementService;
import org.egov.adtax.service.HoardingCategoryService;
import org.egov.adtax.service.HoardingDocumentTypeService;
import org.egov.adtax.service.RatesClassService;
import org.egov.adtax.service.RevenueInspectorService;
import org.egov.adtax.service.SubCategoryService;
import org.egov.adtax.service.UnitOfMeasureService;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.EnvironmentSettings;
import org.egov.infra.utils.FileStoreUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class HoardingControllerSupport
extends GenericWorkFlowController {
    @Autowired
    protected AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    protected AdvertisementService advertisementService;
    @Autowired
    protected SubCategoryService subCategoryService;
    @Autowired
    protected FileStoreUtils fileStoreUtils;
    @Autowired
    protected BoundaryService boundaryService;
    @Autowired
    protected AdvertisementRateService advertisementRateService;
    @Autowired
    protected HoardingCategoryService hoardingCategoryService;
    @Autowired
    protected UnitOfMeasureService unitOfMeasureService;
    @Autowired
    protected RevenueInspectorService revenueInspectorService;
    @Autowired
    protected RatesClassService ratesClassService;
    @Autowired
    protected HoardingDocumentTypeService hoardingDocumentTypeService;
    @Autowired
    protected EnvironmentSettings environmentSettings;
    @Autowired
    protected AdvertisementDemandService advertisementDemandService;
    @Autowired
    protected FinancialYearDAO financialYearDAO;

    @ModelAttribute(value="previousFinancialYear")
    public CFinancialYear previousFinancialYear() {
        return this.financialYearDAO.getPreviousFinancialYearByDate(new Date());
    }

    @ModelAttribute(value="hoardingCategories")
    public List<HoardingCategory> hoardingCategories() {
        return this.hoardingCategoryService.getAllActiveHoardingCategory();
    }

    @ModelAttribute(value="uom")
    public List<UnitOfMeasure> uom() {
        return this.unitOfMeasureService.getAllActiveUnitOfMeasure();
    }

    @ModelAttribute(value="revenueInspectors")
    public List<RevenueInspector> revenueInspectors() {
        return this.revenueInspectorService.findAllActiveRevenueInspectors();
    }

    @ModelAttribute(value="rateClasses")
    public List<RatesClass> rateClasses() {
        return this.ratesClassService.getAllActiveRatesClass();
    }

    @ModelAttribute(value="allRateClasses")
    public List<RatesClass> getAllRatesClass() {
        return this.ratesClassService.getAllRatesClass();
    }

    @ModelAttribute(value="hoardingDocumentTypes")
    public List<HoardingDocumentType> hoardingDocumentTypes() {
        return this.hoardingDocumentTypeService.getAllDocumentTypes();
    }

    @ModelAttribute(value="revenueZones")
    public List<Boundary> revenueZones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "ADMINISTRATION");
    }

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="localities")
    public List<Boundary> localities() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "ADMINISTRATION");
    }

    protected void storeHoardingDocuments(AdvertisementPermitDetail advertisementPermitDetail) {
        advertisementPermitDetail.getAdvertisement().getDocuments().forEach(document -> document.setFiles(this.fileStoreUtils.addToFileStore(document.getAttachments(), "ADTAX")));
    }

    protected void updateHoardingDocuments(AdvertisementPermitDetail advertisementPermitDetail) {
        advertisementPermitDetail.getAdvertisement().getDocuments().forEach(document -> {
            if (document.getAttachments() != null) {
                document.addFiles(this.fileStoreUtils.addToFileStore(document.getAttachments(), "ADTAX"));
            }
        });
    }

    protected void validateHoardingDocs(AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder) {
        int index = 0;
        for (HoardingDocument document : advertisementPermitDetail.getAdvertisement().getDocuments()) {
            if (document.getDoctype().isMandatory() && document.getAttachments()[0].getSize() == 0L) {
                resultBinder.rejectValue("advertisement.documents[" + index + "].attachments", "hoarding.doc.mandatory");
            } else if (document.isEnclosed() && document.getAttachments()[0].getSize() == 0L) {
                resultBinder.rejectValue("advertisement.documents[" + index + "].attachments", "hoarding.doc.not.enclosed");
            }
            ++index;
        }
    }

    protected void validateHoardingDocsOnUpdate(AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib) {
        int index = 0;
        for (HoardingDocument document : advertisementPermitDetail.getAdvertisement().getDocuments()) {
            if (document.getDoctype().isMandatory() && document.getFiles().size() == 0 && document.getAttachments()[0].getSize() == 0L) {
                resultBinder.rejectValue("advertisement.documents[" + index + "].attachments", "hoarding.doc.mandatory");
                redirAttrib.addFlashAttribute("message", (Object)"hoarding.doc.not.enclosed");
            } else if (document.isEnclosed() && document.getFiles().size() == 0 && document.getAttachments()[0].getSize() == 0L) {
                resultBinder.rejectValue("advertisement.documents[" + index + "].attachments", "hoarding.doc.not.enclosed");
                redirAttrib.addFlashAttribute("message", (Object)"hoarding.doc.not.enclosed");
            }
            ++index;
        }
    }

    protected Boolean checkTaxAlreadyCollectedForAdvertisement(Advertisement advertisement) {
        Boolean taxAlreadyCollectedForDemandInAnyYear = false;
        if (advertisement != null && advertisement.getDemandId() != null && advertisement.getDemandId().getEgDemandDetails() != null) {
            block0: for (EgDemandDetails demandDtl : advertisement.getDemandId().getEgDemandDetails()) {
                for (EgdmCollectedReceipt collRecpt : demandDtl.getEgdmCollectedReceipts()) {
                    if (collRecpt.isCancelled().booleanValue()) continue;
                    taxAlreadyCollectedForDemandInAnyYear = true;
                    continue block0;
                }
            }
        }
        return taxAlreadyCollectedForDemandInAnyYear;
    }

    protected void validateAdvertisementDetails(AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder) {
        if (advertisementPermitDetail.getAgency() == null && advertisementPermitDetail.getOwnerDetail() == null) {
            resultBinder.rejectValue("agency", "invalid.eitherAgencyOrOwnerDetailRequired");
        }
        if (advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getPropertyNumber() == null && advertisementPermitDetail.getAdvertisement().getCategory() != null && advertisementPermitDetail.getAdvertisement().getCategory().isPropertyMandatory()) {
            resultBinder.rejectValue("advertisement.propertyNumber", "invalid.propertyIdIsMandatoryForCategory");
        }
        if (advertisementPermitDetail.getPermissionstartdate() != null && advertisementPermitDetail.getPermissionenddate() != null && advertisementPermitDetail.getPermissionstartdate().compareTo(advertisementPermitDetail.getPermissionenddate()) > -1) {
            resultBinder.rejectValue("permissionstartdate", "invalid.permissionFromDateAndToDateCompare");
        }
    }
}

