/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.category;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.service.HoardingCategoryService;
import org.egov.adtax.service.SubCategoryService;
import org.egov.infra.config.core.LocalizationSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/subcategory"})
public class SubCategoryController {
    private final SubCategoryService subCategoryService;
    @Autowired
    private HoardingCategoryService hoardingCategoryService;

    @Autowired
    public SubCategoryController(SubCategoryService subCategoryService) {
        this.subCategoryService = subCategoryService;
    }

    @ModelAttribute(value="subCategory")
    public SubCategory subCategory() {
        return new SubCategory();
    }

    @ModelAttribute(value="subCategories")
    public List<SubCategory> getAllSubCategory() {
        return this.subCategoryService.getAllSubCategory();
    }

    @ModelAttribute(value="hoardingCategories")
    public List<HoardingCategory> getAllHoardingCategory() {
        return this.hoardingCategoryService.getAllHoardingCategory();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String create() {
        return "subcategory-form";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return "subcategory-search";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute SubCategory subCategory, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "subcategory-form";
        }
        this.subCategoryService.createSubCategory(subCategory);
        redirectAttrs.addFlashAttribute("subCategory", (Object)subCategory);
        redirectAttrs.addFlashAttribute("message", (Object)"message.subcategory.create");
        return "redirect:/subcategory/success/" + subCategory.getId();
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="id") Long id, @ModelAttribute SubCategory subCategory) {
        return new ModelAndView("subcategory/subcategory-success", "subCategory", (Object)this.subCategoryService.getSubCategoryById(id));
    }

    @RequestMapping(value={"/searchSubCategory"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchSubcategory(Model model, @ModelAttribute SubCategory subCategory, @RequestParam String category, @RequestParam String description, HttpServletResponse response) throws IOException {
        List SubCategoryJson = this.subCategoryService.getSubcategory(Long.valueOf(category), description != null ? Long.valueOf(description) : null);
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(LocalizationSettings.datePattern()).create().toJson((Object)SubCategoryJson) + "}"), (Writer)response.getWriter());
    }
}

