/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.agency;

import javax.validation.Valid;
import org.egov.adtax.entity.Agency;
import org.egov.adtax.service.AgencyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/agency"})
public class UpdateAgencyController {
    private final AgencyService agencyService;

    @Autowired
    public UpdateAgencyController(AgencyService agencyService) {
        this.agencyService = agencyService;
    }

    @ModelAttribute
    public Agency agencyModel(@PathVariable String code, Model model) {
        return this.agencyService.findByCode(code);
    }

    @RequestMapping(value={"/updateAgency/{code}"}, method={RequestMethod.GET})
    public String update(@PathVariable String code) {
        return "redirect:/agency/update/" + code;
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute Agency agency, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "agency-form";
        }
        this.agencyService.updateAgency(agency);
        redirectAttrs.addFlashAttribute("agency", (Object)agency);
        redirectAttrs.addFlashAttribute("message", (Object)"message.agency.update");
        return "redirect:/agency/success/" + agency.getCode();
    }

    @RequestMapping(value={"/update/{code}"}, method={RequestMethod.GET})
    public ModelAndView updateView(@PathVariable(value="code") String code, @ModelAttribute Agency agency) {
        return new ModelAndView("agency/agency-form", "agency", (Object)this.agencyService.findByCode(code));
    }

    @RequestMapping(value={"/view/{code}"}, method={RequestMethod.GET})
    public String view(@ModelAttribute Agency agency, BindingResult errors) {
        if (errors.hasErrors()) {
            return "agency-search";
        }
        return "redirect:/agency/success/" + agency.getCode();
    }
}

