/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.unitOfMeasure;

import java.util.List;
import javax.validation.Valid;
import org.egov.adtax.entity.UnitOfMeasure;
import org.egov.adtax.service.UnitOfMeasureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/unitOfMeasure"})
public class UnitOfMeasureController {
    private final UnitOfMeasureService unitOfMeasureService;

    @Autowired
    public UnitOfMeasureController(UnitOfMeasureService unitOfMeasureService) {
        this.unitOfMeasureService = unitOfMeasureService;
    }

    @ModelAttribute
    public UnitOfMeasure unitOfMeasure() {
        return new UnitOfMeasure();
    }

    @ModelAttribute(value="unitOfMeasures")
    public List<UnitOfMeasure> getAllUnitOfMeasures() {
        return this.unitOfMeasureService.getAllUnitOfMeasure();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String create() {
        return "unitOfMeasure-form";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return "unitOfMeasure-search";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute UnitOfMeasure unitOfMeasure, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "unitOfMeasure-form";
        }
        this.unitOfMeasureService.createUnitOfMeasure(unitOfMeasure);
        redirectAttrs.addFlashAttribute("unitOfMeasure", (Object)unitOfMeasure);
        redirectAttrs.addFlashAttribute("message", (Object)"message.uom.create");
        return "redirect:/unitOfMeasure/success/" + unitOfMeasure.getId();
    }

    @RequestMapping(value={"/success/{description}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="description") Long description, @ModelAttribute UnitOfMeasure unitOfMeasure) {
        return new ModelAndView("unitOfMeasure/unitOfMeasure-success", "unitOfMeasure", (Object)this.unitOfMeasureService.getUnitOfMeasureById(description));
    }
}

