/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.enums.AdvertisementApplicationType;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.adtax.workflow.AdvertisementWorkFlowService;
import org.egov.commons.Installment;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class CreateAdvertisementController
extends HoardingControllerSupport {
    private static final String APPROVAL_POSITION = "approvalPosition";
    private static final String APPLICATION_PDF = "application/pdf";
    protected String reportId;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AdvertisementWorkFlowService advertisementWorkFlowService;

    @RequestMapping(value={"child-boundaries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> childBoundaries(@RequestParam Long parentBoundaryId) {
        return this.boundaryService.getActiveChildBoundariesByBoundaryId(parentBoundaryId);
    }

    @RequestMapping(value={"subcategories"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SubCategory> hoardingSubcategories(@RequestParam Long categoryId) {
        return this.subCategoryService.getAllActiveSubCategoryByCategoryId(categoryId);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String createHoardingForm(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, Model model, HttpServletRequest request) {
        this.buildCreateHoardingForm(advertisementPermitDetail, model);
        model.addAttribute("currentState", (Object)"NEW");
        return "hoarding-create";
    }

    private void buildCreateHoardingForm(AdvertisementPermitDetail advertisementPermitDetail, Model model) {
        User currentUser = this.securityUtils.getCurrentUser();
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
        this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"CREATEADVERTISEMENT");
        model.addAttribute("isEmployee", (Object)(!"Anonymous".equalsIgnoreCase(currentUser.getName()) && this.advertisementWorkFlowService.isEmployee(this.securityUtils.getCurrentUser()) != false ? 1 : 0));
        model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
    }

    @RequestMapping(value={"/createbycitizen"}, method={RequestMethod.GET})
    public String createHoardingByCitizen(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, Model model, HttpServletRequest request) {
        this.buildCreateHoardingForm(advertisementPermitDetail, model);
        model.addAttribute("currentState", (Object)"NEW");
        model.addAttribute("applicationSource", (Object)"online");
        return "hoarding-create";
    }

    @RequestMapping(value={"/create", "/createbycitizen"}, method={RequestMethod.POST})
    public String createAdvertisement(@Valid @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        Assignment assignment;
        User currentuser = this.securityUtils.getCurrentUser();
        Boolean isEmployee = !"Anonymous".equalsIgnoreCase(currentuser.getName()) && this.advertisementWorkFlowService.isEmployee(this.securityUtils.getCurrentUser()) != false;
        this.validateAssignmentForCscUser(advertisementPermitDetail, isEmployee, resultBinder);
        this.validateHoardingDocs(advertisementPermitDetail, resultBinder);
        this.validateApplicationDate(advertisementPermitDetail, resultBinder);
        this.validateAdvertisementDetails(advertisementPermitDetail, resultBinder);
        if (advertisementPermitDetail != null) {
            if (advertisementPermitDetail.getState() == null) {
                advertisementPermitDetail.setStatus(this.advertisementPermitDetailService.getStatusByModuleAndCode("CREATED"));
            }
            advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.WORKFLOW_IN_PROGRESS);
            advertisementPermitDetail.setSource(Source.SYSTEM.toString());
            advertisementPermitDetail.setApplicationtype(AdvertisementApplicationType.NEW);
            if (resultBinder.hasErrors()) {
                WorkflowContainer workFlowContainer = new WorkflowContainer();
                model.addAttribute("isEmployee", (Object)isEmployee);
                workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
                this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, workFlowContainer);
                model.addAttribute("additionalRule", (Object)"CREATEADVERTISEMENT");
                model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
                model.addAttribute("currentState", (Object)"NEW");
                return "hoarding-create";
            }
        }
        this.storeHoardingDocuments(advertisementPermitDetail);
        Long approvalPosition = 0L;
        String approvalComment = "";
        String approverName = "";
        String nextDesignation = "";
        if ((!isEmployee.booleanValue() || "Anonymous".equalsIgnoreCase(currentuser.getName())) && (assignment = this.advertisementWorkFlowService.getMappedAssignmentForCscOperator(advertisementPermitDetail)) != null) {
            approvalPosition = assignment.getPosition().getId();
            approverName = assignment.getEmployee().getName();
            nextDesignation = assignment.getDesignation().getName();
        }
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approverName") != null) {
            approverName = request.getParameter("approverName");
        }
        if (request.getParameter("nextDesignation") != null) {
            nextDesignation = request.getParameter("nextDesignation");
        }
        if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
        }
        advertisementPermitDetail.getAdvertisement().setPenaltyCalculationDate(advertisementPermitDetail.getApplicationDate());
        this.advertisementPermitDetailService.createAdvertisementPermitDetail(advertisementPermitDetail, approvalPosition, approvalComment, "CREATEADVERTISEMENT", workFlowAction, currentuser);
        redirAttrib.addFlashAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        String message = this.messageSource.getMessage("msg.success.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), advertisementPermitDetail.getApplicationNumber()}, null);
        redirAttrib.addFlashAttribute("message", (Object)message);
        if (!isEmployee.booleanValue()) {
            return "redirect:/hoarding/showack/" + advertisementPermitDetail.getId();
        }
        return "redirect:/hoarding/success/" + advertisementPermitDetail.getId();
    }

    private void validateApplicationDate(AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder) {
        Installment installmentObj;
        if (advertisementPermitDetail != null && advertisementPermitDetail.getApplicationDate() != null && (installmentObj = this.advertisementDemandService.getCurrentInstallment()) != null && installmentObj.getFromDate() != null && (advertisementPermitDetail.getApplicationDate().after(DateUtils.endOfDay((Date)installmentObj.getToDate())) || advertisementPermitDetail.getApplicationDate().before(DateUtils.startOfDay((Date)installmentObj.getFromDate())))) {
            resultBinder.rejectValue("applicationDate", "invalid.applicationDate");
        }
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="id") String id, @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail) {
        return new ModelAndView("hoarding/hoarding-success", "hoarding", (Object)this.advertisementPermitDetailService.findBy(Long.valueOf(id)));
    }

    @RequestMapping(value={"/showack/{id}"}, method={RequestMethod.GET})
    public String showAck(@PathVariable Long id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        model.addAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        return "hoarding-ack";
    }

    @RequestMapping(value={"/printack/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> printAck(@PathVariable Long id, Model model, HttpServletRequest request) {
        byte[] reportOutput;
        String cityMunicipalityName = (String)request.getSession().getAttribute("citymunicipalityname");
        String cityName = (String)request.getSession().getAttribute("cityname");
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        if (advertisementPermitDetail != null && (reportOutput = this.advertisementService.getReportParamsForAcknowdgement(advertisementPermitDetail, cityMunicipalityName, cityName).getReportOutputData()) != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.parseMediaType((String)APPLICATION_PDF));
            headers.add("content-disposition", "inline;filename=hoarding-ack.pdf");
            return new ResponseEntity((Object)reportOutput, (MultiValueMap)headers, HttpStatus.CREATED);
        }
        return null;
    }

    public void validateAssignmentForCscUser(AdvertisementPermitDetail advertisementPermitDetail, Boolean isEmployee, BindingResult errors) {
        if (!isEmployee.booleanValue() && advertisementPermitDetail != null) {
            Assignment assignment;
            Assignment assignment2 = assignment = this.advertisementWorkFlowService.isCscOperator(this.securityUtils.getCurrentUser()) != false ? this.advertisementWorkFlowService.getAssignmentByDeptDesigElecWard(advertisementPermitDetail) : null;
            if (assignment == null && this.advertisementWorkFlowService.getUserPositionByZone(advertisementPermitDetail) == null) {
                errors.reject("notexists.position", "notexists.position");
            }
        }
    }
}

