/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.citizen;

import java.io.Serializable;
import java.util.List;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.Agency;
import org.egov.adtax.entity.enums.AgencyStatus;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.AdvertisementReportService;
import org.egov.adtax.service.AgencyService;
import org.egov.adtax.service.collection.AdvertisementBillServiceImpl;
import org.egov.adtax.service.collection.AdvertisementBillable;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/citizen"})
public class AdtaxCitizenSupportController {
    private static final String COLLECT_ADVTAX_ERROR = "collectAdvtax-error";
    private static final String MESSAGE = "message";
    private static final String ONLINEPAYMENT_REDIRECTION = "onlinepayment-redirection";
    private static final String CITIZEN_CITIZEN_ONLINE_DCBVIEW = "citizen/citizen-online-dcbview";
    private static final String SEARCH_ADTAX_ONLINE_PAYMENT = "search-adtax-online-payment";
    private static final String ADVERTISEMENT_BILLNUMBER = "SEQ_advertisementbill_NUMBER";
    @Autowired
    private AgencyService agencyService;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AdvertisementReportService hoardingReportService;
    @Autowired
    private AdvertisementBillable advertisementBillable;
    @Autowired
    private AdvertisementBillServiceImpl advertisementBillServiceImpl;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;

    @RequestMapping(value={"/search/search-advertisement"}, method={RequestMethod.GET})
    public String searchHoardingForm(@ModelAttribute HoardingSearch hoardingSearch) {
        return SEARCH_ADTAX_ONLINE_PAYMENT;
    }

    @RequestMapping(value={"/search/active-agencies"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Agency> findActiveAgencies(@RequestParam String name) {
        return this.agencyService.findAllActiveByName(name, AgencyStatus.ACTIVE);
    }

    @RequestMapping(value={"/search/getHoardingDcb/{id}"})
    public String viewHoarding(@PathVariable Long id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(id);
        if (advertisementPermitDetail != null) {
            Advertisement hoarding = advertisementPermitDetail.getAdvertisement();
            model.addAttribute("hoarding", (Object)hoarding);
            model.addAttribute("dcbResult", (Object)this.hoardingReportService.getHoardingWiseDCBResult(hoarding));
        }
        return CITIZEN_CITIZEN_ONLINE_DCBVIEW;
    }

    @RequestMapping(value={"/search/generateonlinebill/{id}"}, method={RequestMethod.POST})
    public String payTax(@PathVariable String id, RedirectAttributes redirectAttributes, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findById(Long.valueOf(id));
        if (advertisementPermitDetail != null) {
            Advertisement advertisement = advertisementPermitDetail.getAdvertisement();
            if (advertisement != null && advertisement.getDemandId() != null) {
                if (!this.advertisementDemandService.checkAnyTaxIsPendingToCollect(advertisement).booleanValue()) {
                    model.addAttribute(MESSAGE, (Object)"msg.collection.noPendingTax");
                    return COLLECT_ADVTAX_ERROR;
                }
                this.advertisementBillable.setCollectionType("Advertisement");
                this.advertisementBillable.setAdvertisement(advertisement);
                Serializable referenceNumber = this.sequenceNumberGenerator.getNextSequence(ADVERTISEMENT_BILLNUMBER);
                this.advertisementBillable.setReferenceNumber("ADTAX".concat(String.format("%s%06d", "", referenceNumber)));
                model.addAttribute("collectxml", (Object)this.advertisementBillServiceImpl.getBillXML((Billable)this.advertisementBillable));
                return ONLINEPAYMENT_REDIRECTION;
            }
            model.addAttribute(MESSAGE, (Object)"msg.collection.noPendingTax");
            return COLLECT_ADVTAX_ERROR;
        }
        model.addAttribute(MESSAGE, (Object)"msg.invalied.request");
        return COLLECT_ADVTAX_ERROR;
    }
}

