/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.rate;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.egov.adtax.entity.AdvertisementRate;
import org.egov.adtax.entity.AdvertisementRatesDetails;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.entity.UnitOfMeasure;
import org.egov.adtax.service.AdvertisementRateService;
import org.egov.adtax.service.HoardingCategoryService;
import org.egov.adtax.service.RatesClassService;
import org.egov.adtax.service.UnitOfMeasureService;
import org.egov.commons.CFinancialYear;
import org.egov.infra.config.properties.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/rates"})
public class ScheduleOfRateController {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduleOfRateController.class);
    @Autowired
    private AdvertisementRateService advertisementRateService;
    @Autowired
    private HoardingCategoryService hoardingCategoryService;
    @Autowired
    private ApplicationProperties applicationproperties;
    @Autowired
    private RatesClassService ratesClassService;
    @Autowired
    private UnitOfMeasureService unitOfMeasureService;

    @ModelAttribute(value="rate")
    public AdvertisementRate rate() {
        return new AdvertisementRate();
    }

    @ModelAttribute(value="hoardingCategories")
    public List<HoardingCategory> hoardingCategories() {
        return this.hoardingCategoryService.getAllActiveHoardingCategory();
    }

    @ModelAttribute(value="unitOfMeasures")
    public List<UnitOfMeasure> unitOfMeasures() {
        return this.unitOfMeasureService.getAllActiveUnitOfMeasure();
    }

    @ModelAttribute(value="ratesClasses")
    public List<RatesClass> ratesClasses() {
        return this.ratesClassService.getAllActiveRatesClass();
    }

    @ModelAttribute(value="financialYears")
    public List<CFinancialYear> financialyear() {
        return this.advertisementRateService.getAllFinancialYears();
    }

    @RequestMapping(value={"/subscheduleofrate"}, method={RequestMethod.GET})
    public String newSubScheduleOfRate() {
        LOG.info("Inside Create Sub Schedule of rate ");
        return "subScheduleOfRate-create";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String newScheduleOfRate() {
        LOG.info("Inside Schedule of rate ");
        return "scheduleOfRate-form";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String searchForm(@Valid @ModelAttribute AdvertisementRate rate, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        List<AdvertisementRatesDetails> advertisementRatesDetails = new ArrayList();
        if (this.validateScheduleOfRateSearch(rate, model).booleanValue()) {
            return "scheduleOfRate-form";
        }
        advertisementRatesDetails = this.advertisementRateService.findScheduleOfRateDetailsByCategorySubcategoryUomAndClass(rate.getCategory(), rate.getSubCategory(), rate.getUnitofmeasure(), rate.getClasstype(), rate.getFinancialyear());
        if (advertisementRatesDetails.size() == 0) {
            advertisementRatesDetails.add(new AdvertisementRatesDetails());
            rate.setAdvertisementRatesDetails(advertisementRatesDetails);
            model.addAttribute("mode", (Object)"noDataFound");
        } else {
            rate = ((AdvertisementRatesDetails)advertisementRatesDetails.get(0)).getAdvertisementRate();
            model.addAttribute("mode", (Object)"dataFound");
        }
        model.addAttribute("rate", (Object)rate);
        redirectAttrs.addFlashAttribute("rate", (Object)rate);
        return "scheduleOfRate-result";
    }

    @RequestMapping(value={"getHoardingDcb/{unitFrom}"})
    public String viewHoarding(@PathVariable String category, Model model) {
        return "report-dcbview";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute AdvertisementRate rate, RedirectAttributes redirectAttrs, Model model) {
        AdvertisementRate existingRateobject = null;
        ArrayList<AdvertisementRatesDetails> rateDetails = new ArrayList<AdvertisementRatesDetails>();
        existingRateobject = this.advertisementRateService.findScheduleOfRateByCategorySubcategoryUomAndClass(rate.getCategory(), rate.getSubCategory(), rate.getUnitofmeasure(), rate.getClasstype(), rate.getFinancialyear());
        for (AdvertisementRatesDetails advDtl : rate.getAdvertisementRatesDetails()) {
            if (existingRateobject != null) {
                advDtl.setAdvertisementRate(existingRateobject);
            } else {
                advDtl.setAdvertisementRate(rate);
            }
            rateDetails.add(advDtl);
        }
        if (existingRateobject != null) {
            this.advertisementRateService.deleteAllInBatch(existingRateobject.getAdvertisementRatesDetails());
            existingRateobject.setAdvertisementRatesDetails(rateDetails);
            existingRateobject.setUnitrate(rate.getUnitrate());
            rate = this.advertisementRateService.createScheduleOfRate(existingRateobject);
        } else {
            rate.getAdvertisementRatesDetails().clear();
            rate.setAdvertisementRatesDetails(rateDetails);
            rate = this.advertisementRateService.createScheduleOfRate(rate);
        }
        redirectAttrs.addFlashAttribute("agency", (Object)rate);
        redirectAttrs.addFlashAttribute("message", (Object)"message.scheduleofrate.create");
        return "redirect:/rates/success/" + rate.getId();
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="id") Long id, @ModelAttribute AdvertisementRate rate) {
        return new ModelAndView("scheduleOfRate-success", "rate", (Object)this.advertisementRateService.getScheduleOfRateById(id));
    }

    private Boolean validateScheduleOfRateSearch(AdvertisementRate rate, Model model) {
        Boolean validate = false;
        if (rate != null) {
            if (rate.getCategory() == null || rate.getCategory().getId() == null) {
                model.addAttribute("message", (Object)"message.category.ismandatory");
                validate = true;
            }
            if (rate.getSubCategory() == null || rate.getSubCategory().getId() == null) {
                model.addAttribute("message", (Object)"message.subcategory.ismandatory");
                validate = true;
            }
            if (rate.getUnitofmeasure() == null || rate.getUnitofmeasure().getId() == null) {
                model.addAttribute("message", (Object)"message.uom.ismandatory");
                validate = true;
            }
        }
        return validate;
    }

    @RequestMapping(value={"/searchscheduleofrate"}, method={RequestMethod.GET})
    public String newSearchScheduleOfRate() {
        return "scheduleOfRate-search";
    }

    @RequestMapping(value={"/searchscheduleofrate"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchScheduleOfRate(HttpServletRequest request, HttpServletResponse response) {
        String category = request.getParameter("category");
        String subCategory = request.getParameter("subCategory");
        String unitOfMeasure = request.getParameter("uom");
        String classtype = request.getParameter("rateClass");
        String finyear = request.getParameter("finyear");
        return "{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationproperties.defaultDatePattern()).create().toJson((Object)this.advertisementRateService.getScheduleOfRateSearchResult(category, subCategory, unitOfMeasure, classtype, finyear)) + "}";
    }
}

