/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import javax.servlet.http.HttpServletRequest;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.adtax.workflow.AdvertisementWorkFlowService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.workflow.entity.StateAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class UpdateHoardingController
extends HoardingControllerSupport {
    private static final String ADDITIONAL_RULE = "additionalRule";
    private static final String HOARDING_UPDATE = "hoarding-update";
    private static final String MESSAGE = "message";
    private static final String APPROVAL_POSITION = "approvalPosition";
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private AdvertisementWorkFlowService advertisementWorkFlowService;

    @ModelAttribute(value="advertisementPermitDetail")
    public AdvertisementPermitDetail advertisementPermitDetail(@PathVariable String id) {
        return this.advertisementPermitDetailService.findBy(Long.valueOf(id));
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String updateHoarding(@PathVariable String id, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        model.addAttribute("dcPending", (Object)this.advertisementDemandService.anyDemandPendingForCollection(advertisementPermitDetail));
        model.addAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        if (advertisementPermitDetail != null && advertisementPermitDetail.getPreviousapplicationid() != null) {
            model.addAttribute(ADDITIONAL_RULE, (Object)"RENEWADVERTISEMENT");
            workFlowContainer.setAdditionalRule("RENEWADVERTISEMENT");
        } else {
            model.addAttribute(ADDITIONAL_RULE, (Object)"CREATEADVERTISEMENT");
            workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
        }
        if (advertisementPermitDetail != null) {
            model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)advertisementPermitDetail.getCurrentState().getValue());
            model.addAttribute("agency", (Object)advertisementPermitDetail.getAgency());
            model.addAttribute("advertisementDocuments", (Object)advertisementPermitDetail.getAdvertisement().getDocuments());
            this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, workFlowContainer);
        }
        return HOARDING_UPDATE;
    }

    @RequestMapping(value={"update/{id}"}, method={RequestMethod.POST})
    public String updateHoarding(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        this.validateHoardingDocsOnUpdate(advertisementPermitDetail, resultBinder, redirAttrib);
        this.validateAdvertisementDetails(advertisementPermitDetail, resultBinder);
        if (resultBinder.hasErrors()) {
            WorkflowContainer workFlowContainer = new WorkflowContainer();
            if (advertisementPermitDetail != null && advertisementPermitDetail.getPreviousapplicationid() != null) {
                model.addAttribute(ADDITIONAL_RULE, (Object)"RENEWADVERTISEMENT");
                workFlowContainer.setAdditionalRule("RENEWADVERTISEMENT");
            } else {
                model.addAttribute(ADDITIONAL_RULE, (Object)"CREATEADVERTISEMENT");
                workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
            }
            if (advertisementPermitDetail != null) {
                this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, workFlowContainer);
                model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
                model.addAttribute("currentState", (Object)advertisementPermitDetail.getCurrentState().getValue());
            }
            return HOARDING_UPDATE;
        }
        try {
            Long approvalPosition = 0L;
            String approvalComment = "";
            String approverName = "";
            String nextDesignation = "";
            if (request.getParameter("approverName") != null) {
                approverName = request.getParameter("approverName");
            }
            if (request.getParameter("nextDesignation") != null) {
                nextDesignation = request.getParameter("nextDesignation");
            }
            if (request.getParameter("approvalComent") != null) {
                approvalComment = request.getParameter("approvalComent");
            }
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            if (request.getParameter(APPROVAL_POSITION) != null && !request.getParameter(APPROVAL_POSITION).isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter(APPROVAL_POSITION));
            }
            if ("GENERATE DEMAND NOTICE".equalsIgnoreCase(workFlowAction)) {
                return "redirect:/advertisement/demandNotice?pathVar=" + advertisementPermitDetail.getId();
            }
            this.updateHoardingDocuments(advertisementPermitDetail);
            this.advertisementPermitDetailService.updateAdvertisementPermitDetail(advertisementPermitDetail, approvalPosition, approvalComment, advertisementPermitDetail != null && advertisementPermitDetail.getPreviousapplicationid() != null ? "RENEWADVERTISEMENT" : "CREATEADVERTISEMENT", workFlowAction);
            redirAttrib.addFlashAttribute("advertisementNumber", (Object)advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
            if ("Approve".equals(workFlowAction)) {
                String message = advertisementPermitDetail.getPreviousapplicationid() != null ? this.messageSource.getMessage("msg.renewal.success.approved", (Object[])new String[]{advertisementPermitDetail.getAdvertisement().getAdvertisementNumber(), advertisementPermitDetail.getPermissionNumber()}, null) : this.messageSource.getMessage("msg.success.approved", (Object[])new String[]{advertisementPermitDetail.getAdvertisement().getAdvertisementNumber(), advertisementPermitDetail.getPermissionNumber()}, null);
                redirAttrib.addFlashAttribute(MESSAGE, (Object)message);
            } else if ("REJECT".equalsIgnoreCase(workFlowAction) || "CANCEL APPLICATION".equalsIgnoreCase(workFlowAction) || "CANCEL RENEWAL".equalsIgnoreCase(workFlowAction)) {
                Assignment wfInitiator = this.advertisementWorkFlowService.getWorkFlowInitiator(advertisementPermitDetail);
                if (ApplicationThreadLocals.getUserId().equals(wfInitiator.getEmployee().getId())) {
                    String message = this.messageSource.getMessage("msg.success.cancelled", (Object[])new String[]{advertisementPermitDetail.getApplicationNumber()}, null);
                    redirAttrib.addFlashAttribute(MESSAGE, (Object)message);
                } else {
                    approverName = wfInitiator.getEmployee().getName();
                    nextDesignation = wfInitiator.getDesignation().getName();
                    String message = this.messageSource.getMessage("msg.success.reject", (Object[])new String[]{advertisementPermitDetail.getApplicationNumber(), approverName.concat("~").concat(nextDesignation)}, null);
                    redirAttrib.addFlashAttribute(MESSAGE, (Object)message);
                }
            } else {
                if ("GENERATE PERMIT ORDER".equalsIgnoreCase(workFlowAction)) {
                    return "redirect:/advertisement/permitOrder?pathVar=" + advertisementPermitDetail.getId();
                }
                String message = this.messageSource.getMessage("msg.success.forward.on.reject", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), advertisementPermitDetail.getApplicationNumber()}, null);
                redirAttrib.addFlashAttribute(MESSAGE, (Object)message);
            }
            return "redirect:/hoarding/success/" + advertisementPermitDetail.getId();
        }
        catch (HoardingValidationError e) {
            resultBinder.rejectValue(e.fieldName(), e.errorCode());
            return HOARDING_UPDATE;
        }
    }
}

