/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.reports;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/advertisement"})
public class ReportController {
    private static final String AGENCYADDRESS = "agencyaddress";
    private static final String AGENCYNAME = "agencyname";
    @Autowired
    private ReportService reportService;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AdvertisementPenaltyCalculator advertisementPenaltyCalculator;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;
    @Autowired
    private CityService cityService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource advertisementReportMessageSource;

    @RequestMapping(value={"/permitOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generatePermitOrder(HttpServletRequest request, HttpSession session) {
        String errorMessage = "";
        String workFlowAction = "";
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(request.getParameter("pathVar")));
        if (!"".isEmpty()) {
            return this.redirect("");
        }
        return this.generatePermitOrder(request, advertisementPermitDetail, session, "");
    }

    @RequestMapping(value={"/demandNotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateDemandNotice(HttpServletRequest request, HttpSession session) {
        String errorMessage = "";
        String workFlowAction = "";
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(request.getParameter("pathVar")));
        workFlowAction = (String)session.getAttribute("workFlowAction");
        if (!"".isEmpty()) {
            return this.redirect("");
        }
        return this.generateDemandNotice(request, advertisementPermitDetail, session, workFlowAction);
    }

    private ResponseEntity<byte[]> generatePermitOrder(HttpServletRequest request, AdvertisementPermitDetail advertisementPermitDetail, HttpSession session, String workFlowAction) {
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (null != advertisementPermitDetail) {
            Map reportParams = this.buildParametersForReport(request, advertisementPermitDetail);
            reportParams.put("advertisementtitle", WordUtils.capitalize((String)"Advertisement Permit Order"));
            reportInput = new ReportRequest("permitOrder", (Object)advertisementPermitDetail, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Permit Order.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private void buildMeasurementDetailsForJasper(AdvertisementPermitDetail advertisementPermitDetail, StringBuilder measurement, Map<String, Object> reportParams, String NOTMENTIONED) {
        measurement.append(advertisementPermitDetail.getMeasurement() == null ? NOTMENTIONED : advertisementPermitDetail.getMeasurement()).append(" ");
        if (advertisementPermitDetail.getMeasurement() != null) {
            measurement.append(advertisementPermitDetail.getUnitOfMeasure().getDescription());
        }
        if (advertisementPermitDetail.getLength() != null) {
            measurement.append(" Length : ").append(advertisementPermitDetail.getLength());
        }
        if (advertisementPermitDetail.getBreadth() != null) {
            measurement.append(" Breadth : ").append(advertisementPermitDetail.getBreadth());
        }
        if (advertisementPermitDetail.getTotalHeight() != null) {
            measurement.append(" Height : ").append(advertisementPermitDetail.getTotalHeight());
        }
        reportParams.put("measurement", measurement.toString());
    }

    private ResponseEntity<byte[]> generateDemandNotice(HttpServletRequest request, AdvertisementPermitDetail advertisementPermitDetail, HttpSession session, String workFlowAction) {
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (null != advertisementPermitDetail) {
            Map reportParams = this.buildParametersForReport(request, advertisementPermitDetail);
            reportParams.putAll(this.buildParametersForDemandDetails(advertisementPermitDetail));
            String cityGrade = this.getCityGrade();
            if (cityGrade != null && cityGrade.equalsIgnoreCase("Corp")) {
                reportParams.put("lawAct", this.advertisementReportMessageSource.getMessage("msg.ap.law.act.corporation", (Object[])new String[0], Locale.getDefault()));
            } else {
                reportParams.put("lawAct", this.advertisementReportMessageSource.getMessage("msg.ap.law.act.municipality", (Object[])new String[0], Locale.getDefault()));
            }
            reportInput = new ReportRequest("demandNotice", (Object)advertisementPermitDetail, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Demand Notice.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private Map<String, Object> buildParametersForDemandDetails(AdvertisementPermitDetail advertisementPermitDetail) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        BigDecimal curntInsAdvertisement = BigDecimal.ZERO;
        BigDecimal curntInsEncrocFee = BigDecimal.ZERO;
        BigDecimal curntInsPenaltyFee = BigDecimal.ZERO;
        BigDecimal curntInsServiceTax = BigDecimal.ZERO;
        BigDecimal curntInsSwachBharatCess = BigDecimal.ZERO;
        BigDecimal curntInsKrishiKalyanCess = BigDecimal.ZERO;
        BigDecimal curntInsTotalTaxableAmt = BigDecimal.ZERO;
        BigDecimal arrInsAdvertisement = BigDecimal.ZERO;
        BigDecimal arrInsEncrocFee = BigDecimal.ZERO;
        BigDecimal arrInsPenaltyFee = BigDecimal.ZERO;
        BigDecimal arrInsServiceTax = BigDecimal.ZERO;
        BigDecimal arrInsSwachBharatCess = BigDecimal.ZERO;
        BigDecimal arrInsKrishiKalyanCess = BigDecimal.ZERO;
        BigDecimal arrInsTotalTaxableAmt = BigDecimal.ZERO;
        String previousInstallmentDesc = null;
        Installment currentInstallemnt = advertisementPermitDetail.getAdvertisement().getDemandId().getEgInstallmentMaster();
        List previousInstallemnt = this.advertisementDemandService.getPreviousInstallment(currentInstallemnt.getFromDate());
        Map penaltyAmountMap = this.advertisementPenaltyCalculator.getPenaltyByInstallment(advertisementPermitDetail);
        HashMap<String, BigDecimal> additionalTaxes = new HashMap<String, BigDecimal>();
        List additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        if (previousInstallemnt.isEmpty()) {
            String currentFinYear = currentInstallemnt.getFinYearRange();
            String[] stringArray = currentFinYear.split("-");
            Integer from = Integer.parseInt(stringArray[0]) - 1;
            Integer to = Integer.parseInt(stringArray[1]) - 1;
            previousInstallmentDesc = from.toString() + "-" + to.toString();
        }
        for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
            additionalTaxes.put(advertisementAdditionalTaxRate.getReasonCode(), advertisementAdditionalTaxRate.getPercentage());
        }
        for (EgDemandDetails egDemandDetails : advertisementPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
            if (egDemandDetails.getBalance().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (currentInstallemnt != null && currentInstallemnt.getDescription().equals(egDemandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription())) {
                if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax")) {
                    arrInsAdvertisement = arrInsAdvertisement.add(egDemandDetails.getBalance());
                    arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                    continue;
                }
                if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Advertisemnt_Tax")) {
                    curntInsAdvertisement = curntInsAdvertisement.add(egDemandDetails.getBalance());
                    reportParams.put("curntInsAdvertisement", curntInsAdvertisement.setScale(2, 6));
                    curntInsTotalTaxableAmt = curntInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                    continue;
                }
                if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Enchroachmnt_Fee")) {
                    curntInsEncrocFee = egDemandDetails.getBalance();
                    reportParams.put("curntInsEncrocFee", curntInsEncrocFee.setScale(2, 6));
                    curntInsTotalTaxableAmt = curntInsTotalTaxableAmt.add(curntInsEncrocFee);
                    continue;
                }
                if (!egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Penalty")) continue;
                curntInsPenaltyFee = egDemandDetails.getBalance();
                reportParams.put("curntInsPenaltyFee", curntInsPenaltyFee.setScale(2, 6));
                continue;
            }
            if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax") || egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Advertisemnt_Tax")) {
                arrInsAdvertisement = arrInsAdvertisement.add(egDemandDetails.getBalance());
                reportParams.put("arrInsAdvertisement", arrInsAdvertisement.setScale(2, 6));
                arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                continue;
            }
            if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Enchroachmnt_Fee")) {
                arrInsEncrocFee = arrInsEncrocFee.add(egDemandDetails.getBalance());
                reportParams.put("arrInsEncrocFee", arrInsEncrocFee.setScale(2, 6));
                arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                continue;
            }
            if (!egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Penalty")) continue;
            arrInsPenaltyFee = arrInsPenaltyFee.add(egDemandDetails.getBalance());
            reportParams.put("arrInsPenaltyFee", arrInsPenaltyFee.setScale(2, 6));
        }
        for (Map.Entry entry : penaltyAmountMap.entrySet()) {
            if (currentInstallemnt != null && currentInstallemnt.getDescription().equalsIgnoreCase(((Installment)entry.getKey()).getDescription())) {
                curntInsPenaltyFee = curntInsPenaltyFee.add((BigDecimal)entry.getValue());
                reportParams.put("curntInsPenaltyFee", curntInsPenaltyFee);
                continue;
            }
            arrInsPenaltyFee = arrInsPenaltyFee.add((BigDecimal)entry.getValue());
            reportParams.put("arrInsPenaltyFee", arrInsPenaltyFee);
        }
        for (Map.Entry entry : additionalTaxes.entrySet()) {
            if ("Service_Tax".equalsIgnoreCase((String)entry.getKey())) {
                curntInsServiceTax = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                arrInsServiceTax = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                continue;
            }
            if ("ADTAX_SB_CESS".equalsIgnoreCase((String)entry.getKey())) {
                curntInsSwachBharatCess = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                arrInsSwachBharatCess = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                continue;
            }
            if (!"ADTAX_KRISHI_CES".equalsIgnoreCase((String)entry.getKey())) continue;
            curntInsKrishiKalyanCess = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
            arrInsKrishiKalyanCess = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
        }
        reportParams.put("currentInstallmentDesc", currentInstallemnt.getDescription());
        reportParams.put("previousInstallmentDesc", previousInstallemnt.isEmpty() ? previousInstallmentDesc : ((Installment)previousInstallemnt.get(0)).getDescription());
        reportParams.put("curntInsServiceTax", curntInsServiceTax.setScale(2, 6));
        reportParams.put("curntInsKrishiKalyanCess", curntInsKrishiKalyanCess.setScale(2, 6));
        reportParams.put("curntInsSwachBharatCess", curntInsSwachBharatCess.setScale(2, 6));
        reportParams.put("arrInsServiceTax", arrInsServiceTax.setScale(2, 6));
        reportParams.put("arrInsSwachBharatCess", arrInsSwachBharatCess.setScale(2, 6));
        reportParams.put("arrInsKrishiKalyanCess", arrInsKrishiKalyanCess.setScale(2, 6));
        reportParams.put("curntInsTotalTaxableAmt", curntInsTotalTaxableAmt.setScale(2, 6));
        reportParams.put("arrInsTotalTaxableAmt", arrInsTotalTaxableAmt.setScale(2, 6));
        BigDecimal curntInsGrossTotal = curntInsTotalTaxableAmt.add(curntInsServiceTax).add(curntInsSwachBharatCess).add(curntInsKrishiKalyanCess);
        reportParams.put("curntInsGrossTotal", curntInsGrossTotal.setScale(2, 6));
        BigDecimal curntInsNetTotal = curntInsGrossTotal.add(curntInsPenaltyFee);
        reportParams.put("curntInsNetTotal", curntInsNetTotal.setScale(2, 6));
        BigDecimal arrInsGrossTotal = arrInsTotalTaxableAmt.add(arrInsServiceTax).add(arrInsSwachBharatCess).add(arrInsKrishiKalyanCess);
        reportParams.put("arrInsGrossTotal", arrInsGrossTotal.setScale(2, 6));
        BigDecimal arrInsNetTotal = arrInsGrossTotal.add(arrInsPenaltyFee);
        reportParams.put("arrInsNetTotal", arrInsNetTotal.setScale(2, 6));
        reportParams.put("advertisementTaxSum", curntInsAdvertisement.add(arrInsAdvertisement).setScale(2, 6));
        reportParams.put("encrochmentFeeSum", curntInsEncrocFee.add(arrInsEncrocFee).setScale(2, 6));
        reportParams.put("serviceTaxSum", curntInsServiceTax.add(arrInsServiceTax).setScale(0, 4));
        reportParams.put("swachBharatCessSum", curntInsSwachBharatCess.add(arrInsSwachBharatCess).setScale(0, 4));
        reportParams.put("krishiKalyanCessSum", curntInsKrishiKalyanCess.add(arrInsKrishiKalyanCess).setScale(0, 4));
        reportParams.put("penalitySum", curntInsPenaltyFee.add(arrInsPenaltyFee).setScale(2, 6));
        reportParams.put("adParticular", advertisementPermitDetail.getAdvertisementParticular());
        reportParams.put("durationOfAdvt", advertisementPermitDetail.getAdvertisementDuration());
        reportParams.put("class", advertisementPermitDetail.getAdvertisement().getRateClass().getDescription());
        reportParams.put("revenueWard", advertisementPermitDetail.getAdvertisement().getWard().getName());
        reportParams.put("electionWard", advertisementPermitDetail.getAdvertisement().getElectionWard() != null ? advertisementPermitDetail.getAdvertisement().getElectionWard().getName() : "");
        return reportParams;
    }

    private BigDecimal calculateAdditionalTaxes(BigDecimal curntInsTotalTaxableAmt, BigDecimal entry) {
        return entry.multiply(curntInsTotalTaxableAmt).divide(BigDecimal.valueOf(100L)).setScale(0, 4);
    }

    private String getCityGrade() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getGrade();
    }

    private Map<String, Object> buildParametersForReport(HttpServletRequest request, AdvertisementPermitDetail advertisementPermitDetail) {
        StringBuilder measurement = new StringBuilder();
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        String NOTMENTIONED = "Not Mentioned ";
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String ulbName = request.getSession().getAttribute("citymunicipalityname").toString();
        String cityName = request.getSession().getAttribute("cityname").toString();
        reportParams.put("cityName", cityName);
        reportParams.put("logoPath", cityLogo);
        reportParams.put("ulbName", ulbName);
        reportParams.put("advertisementtitle", WordUtils.capitalize((String)"Advertisement Demand Notice"));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put("advertisementnumber", advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
        reportParams.put("permitNumber", advertisementPermitDetail.getPermissionNumber());
        reportParams.put("applicationNumber", advertisementPermitDetail.getApplicationNumber());
        if (advertisementPermitDetail.getAgency() != null && StringUtils.isNotBlank((String)advertisementPermitDetail.getOwnerDetail())) {
            reportParams.put(AGENCYNAME, advertisementPermitDetail.getAgency().getName() + "/" + advertisementPermitDetail.getOwnerDetail());
            reportParams.put(AGENCYADDRESS, advertisementPermitDetail.getAgency().getAddress());
        } else if (advertisementPermitDetail.getAgency() != null && StringUtils.isBlank((String)advertisementPermitDetail.getOwnerDetail())) {
            reportParams.put(AGENCYNAME, advertisementPermitDetail.getAgency().getName());
            reportParams.put(AGENCYADDRESS, advertisementPermitDetail.getAgency().getAddress());
        } else {
            reportParams.put(AGENCYNAME, advertisementPermitDetail.getOwnerDetail());
            reportParams.put(AGENCYADDRESS, NOTMENTIONED);
        }
        reportParams.put("address", advertisementPermitDetail.getAdvertisement().getAddress());
        reportParams.put("applicationDate", formatter.format(advertisementPermitDetail.getApplicationDate()));
        reportParams.put("category", advertisementPermitDetail.getAdvertisement().getCategory().getName());
        reportParams.put("subjectMatter", advertisementPermitDetail.getAdvertisementParticular());
        this.buildMeasurementDetailsForJasper(advertisementPermitDetail, measurement, reportParams, NOTMENTIONED);
        reportParams.put("permitStartDate", formatter.format(advertisementPermitDetail.getPermissionstartdate()));
        reportParams.put("permitEndDate", formatter.format(advertisementPermitDetail.getPermissionenddate()));
        reportParams.put("currdate", formatter.format(new Date()));
        return reportParams;
    }

    private ResponseEntity<byte[]> redirect(String errorMessage) {
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = errorMessage.getBytes();
        errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/demandNotice/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewDemandNoticeReport(@PathVariable String id, HttpSession session, HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetails = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        return this.generateDemandNotice(request, advertisementPermitDetails, session, null);
    }

    @RequestMapping(value={"/permitOrder/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewPermitOrderReport(@PathVariable String id, HttpSession session, HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetails = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        if (!"ADTAXPERMITGENERATED".equalsIgnoreCase(advertisementPermitDetails.getStatus().getCode())) {
            this.advertisementPermitDetailService.updateStateTransition(advertisementPermitDetails, Long.valueOf(0L), "", "CREATEADVERTISEMENT", "GENERATE PERMIT ORDER");
        }
        return this.generatePermitOrder(request, advertisementPermitDetails, session, null);
    }
}

