/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import java.util.Date;
import java.util.List;
import org.egov.adtax.entity.AdvertisementBatchDemandGenerate;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.adtax.service.AdvertisementBatchDemandGenService;
import org.egov.adtax.service.AdvertisementRateService;
import org.egov.adtax.web.controller.GenericController;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.service.ModuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class GenerateDemandHoardingController
extends GenericController {
    @Autowired
    private AdvertisementRateService advertisementRateService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AdvertisementBatchDemandGenService advertisementBatchDemandGenService;

    @ModelAttribute(value="financialYears")
    public List<Installment> financialyear() {
        return this.installmentDao.getInsatllmentByModule(this.moduleService.getModuleByName("Advertisement Tax"));
    }

    @RequestMapping(value={"/generate-search"}, method={RequestMethod.GET})
    public String search(@ModelAttribute HoardingSearch hoardingSearch) {
        return "hoarding-generate";
    }

    @RequestMapping(value={"generate-search"}, method={RequestMethod.POST})
    public String searchHoarding(@ModelAttribute HoardingSearch hoardingSearch, RedirectAttributes redirectAttributes, BindingResult resultBinder) {
        Installment installment = null;
        if (hoardingSearch.getFinancialYear() == null) {
            resultBinder.rejectValue("financialYear", "*");
            return "hoarding-generate";
        }
        installment = this.installmentDao.fetchInstallmentByModuleAndInstallmentNumber(this.moduleService.getModuleByName("Advertisement Tax"), Integer.valueOf(hoardingSearch.getFinancialYear()));
        if (installment != null) {
            AdvertisementBatchDemandGenerate advBatchDmdGenerate = new AdvertisementBatchDemandGenerate();
            advBatchDmdGenerate.setActive(Boolean.valueOf(true));
            advBatchDmdGenerate.setInstallment(installment);
            advBatchDmdGenerate.setJobName("Generate Demand For " + installment.getFinYearRange() + new Date());
            this.advertisementBatchDemandGenService.createAdvertisementBatchDemandGenerate(advBatchDmdGenerate);
        }
        redirectAttributes.addFlashAttribute("message", (Object)"msg.demand.Scheduled");
        return "generateDemand-success";
    }
}

