/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.agency;

import java.util.List;
import javax.validation.Valid;
import org.egov.adtax.entity.Agency;
import org.egov.adtax.entity.enums.AgencyStatus;
import org.egov.adtax.service.AgencyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/agency"})
public class AgencyController {
    private final AgencyService agencyService;

    @Autowired
    public AgencyController(AgencyService agencyService) {
        this.agencyService = agencyService;
    }

    @ModelAttribute
    public Agency agency() {
        return new Agency();
    }

    @ModelAttribute(value="agencies")
    public List<Agency> getAgencies() {
        return this.agencyService.findAll();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String create() {
        return "agency-form";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute Agency agency, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "agency-form";
        }
        this.agencyService.createAgency(agency);
        redirectAttrs.addFlashAttribute("agency", (Object)agency);
        redirectAttrs.addFlashAttribute("message", (Object)"message.agency.create");
        return "redirect:/agency/success/" + agency.getCode();
    }

    @RequestMapping(value={"/success/{code}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="code") String code, @ModelAttribute Agency agency) {
        return new ModelAndView("agency/agency-success", "agency", (Object)this.agencyService.findByCode(code));
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return "agency-search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String search(@ModelAttribute Agency agency, BindingResult errors) {
        if (errors.hasErrors()) {
            return "agency-search";
        }
        return "redirect:/agency/update/" + agency.getCode();
    }

    @RequestMapping(value={"agencies"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Agency> findAgencies(@RequestParam String name) {
        return this.agencyService.findAllByNameLike(name);
    }

    @RequestMapping(value={"active-agencies"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Agency> findActiveAgencies(@RequestParam String name) {
        return this.agencyService.findAllActiveByName(name, AgencyStatus.ACTIVE);
    }
}

