/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.demand;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.adtax.entity.AdvertisementBatchDemandGenerate;
import org.egov.adtax.entity.AdvertisementDemandGenerationLog;
import org.egov.adtax.search.contract.AdvertisementBatchStatusResponse;
import org.egov.adtax.search.contract.AdvertisementDemandStatus;
import org.egov.adtax.service.AdTaxDemandGenerationLogService;
import org.egov.adtax.service.AdvertisementBatchDemandGenService;
import org.egov.adtax.web.adaptor.AdvertisementBatchStatusAdapter;
import org.egov.adtax.web.adaptor.AdvertisementDemandStatusAdapter;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/advertisement"})
public class ViewAdTaxDemandGenerationStatusController {
    private static final String DATA = "{\"data\":";
    private static final String DEMAND_STATUS_FORM = "demand-status-form";
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AdTaxDemandGenerationLogService adTaxDemandGenerationLogService;
    @Autowired
    private AdvertisementBatchDemandGenService advertisementBatchDemandGenService;

    @ModelAttribute(value="financialYears")
    public List<Installment> financialyear() {
        return this.installmentDao.getInsatllmentByModule(this.moduleService.getModuleByName("Advertisement Tax"));
    }

    @RequestMapping(value={"/demand-status"}, method={RequestMethod.GET})
    public String viewDemand(@ModelAttribute AdvertisementDemandStatus advertisementDemandStatus) {
        return DEMAND_STATUS_FORM;
    }

    @RequestMapping(value={"/demand-status"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getDemandGenerationStatus(@ModelAttribute AdvertisementDemandStatus advertisementDemandStatus, @RequestParam String financialYear, HttpServletRequest request) {
        List generationLogList;
        ArrayList<AdvertisementDemandStatus> resultList = new ArrayList<AdvertisementDemandStatus>();
        if (financialYear != null && (generationLogList = this.adTaxDemandGenerationLogService.getDemandGenerationLogByInstallmentYear(financialYear)) != null && !generationLogList.isEmpty()) {
            AdvertisementDemandStatus demandStatus = this.adTaxDemandGenerationLogService.getDemandStatusResult(generationLogList);
            demandStatus.setFinancialYear(financialYear);
            resultList.add(demandStatus);
        }
        return DATA + JsonUtils.toJSON(resultList, AdvertisementDemandStatus.class, AdvertisementDemandStatusAdapter.class) + "}";
    }

    @RequestMapping(value={"/demand-status-records-view/{financialYear}"}, method={RequestMethod.GET})
    public String viewDemandStatusOfRecords(@ModelAttribute AdvertisementDemandStatus advertisementDemandStatus, @PathVariable String financialYear, Model model) {
        model.addAttribute("financialYear", (Object)financialYear);
        return "adtax-demand-status-view";
    }

    @RequestMapping(value={"/demand-status-records-view/"}, produces={"text/plain"})
    @ResponseBody
    public String viewDemandStatus(@RequestParam(value="financialyear") String financialyear, Model model) {
        ArrayList outputList = new ArrayList();
        ArrayList detailList = new ArrayList();
        if (financialyear != null) {
            String[] inputArray = financialyear.split("~");
            boolean val = false;
            if (inputArray[0].contains("0")) {
                val = true;
            }
            List demandGenLogList = this.adTaxDemandGenerationLogService.getDemandGenerationLogByInstallmentYear(inputArray[1]);
            for (AdvertisementDemandGenerationLog generationLog : demandGenLogList) {
                List logDetailList = generationLog.getDetails();
                if (logDetailList == null || logDetailList.isEmpty()) continue;
                List resultList = this.adTaxDemandGenerationLogService.getLogDetailResultList(logDetailList, generationLog, detailList, val);
                outputList.addAll(resultList);
            }
        }
        return DATA + JsonUtils.toJSON(outputList, AdvertisementDemandStatus.class, AdvertisementDemandStatusAdapter.class) + "}";
    }

    @RequestMapping(value={"/demand-batch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getDemandGeneration(@ModelAttribute AdvertisementBatchStatusResponse advertisementBatchStatus, HttpServletRequest request, @RequestParam String financialYear, Model model) {
        ArrayList<AdvertisementBatchStatusResponse> batchresultList = new ArrayList<AdvertisementBatchStatusResponse>();
        List batchList = this.advertisementBatchDemandGenService.findActiveBatchDemands();
        if (batchList != null) {
            for (AdvertisementBatchDemandGenerate batch : batchList) {
                AdvertisementBatchStatusResponse batchobj = new AdvertisementBatchStatusResponse();
                batchobj.setJobname(batch.getJobName());
                batchobj.setCreatedDate(batch.getCreatedDate());
                batchobj.setFinancialYear(financialYear);
                batchobj.setStatus("Demand Generation is scheduled and waiting for completion");
                batchresultList.add(batchobj);
            }
        }
        return DATA + JsonUtils.toJSON(batchresultList, AdvertisementBatchStatusResponse.class, AdvertisementBatchStatusAdapter.class) + "}";
    }
}

