/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.category;

import java.util.List;
import javax.validation.Valid;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.service.HoardingCategoryService;
import org.egov.adtax.service.SubCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/subcategory"})
public class UpdateSubCategoryController {
    private final SubCategoryService subCategoryService;
    @Autowired
    private HoardingCategoryService hoardingCategoryService;

    @Autowired
    public UpdateSubCategoryController(SubCategoryService subCategoryService) {
        this.subCategoryService = subCategoryService;
    }

    @ModelAttribute
    public SubCategory subCategoryModel(@PathVariable Long id, Model model) {
        return this.subCategoryService.getSubCategoryById(id);
    }

    @ModelAttribute(value="hoardingCategories")
    public List<HoardingCategory> getAllHoardingCategory() {
        return this.hoardingCategoryService.getAllHoardingCategory();
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute SubCategory subCategory, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "subcategory-form";
        }
        this.subCategoryService.updateSubCategory(subCategory);
        redirectAttrs.addFlashAttribute("subCategory", (Object)subCategory);
        redirectAttrs.addFlashAttribute("message", (Object)"message.subcategory.update");
        return "redirect:/subcategory/success/" + subCategory.getId();
    }

    @RequestMapping(value={"/updateSubCategory/{id}"}, method={RequestMethod.GET})
    public String update(@PathVariable Long id) {
        return "redirect:/subcategory/update/" + id;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public ModelAndView updateView(@PathVariable(value="id") Long id, @ModelAttribute SubCategory subcategory) {
        return new ModelAndView("subcategory/subcategory-form", "subCategory", (Object)this.subCategoryService.getSubCategoryById(id));
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@ModelAttribute SubCategory subCategory, BindingResult errors) {
        if (errors.hasErrors()) {
            return "subcategory-search";
        }
        return "redirect:/subcategory/success/" + subCategory.getId();
    }
}

