/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.ratesClass;

import javax.validation.Valid;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.service.RatesClassService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/ratesclass"})
public class UpdateRateClassController {
    private final RatesClassService rateClassService;

    @Autowired
    public UpdateRateClassController(RatesClassService rateClassService) {
        this.rateClassService = rateClassService;
    }

    @ModelAttribute
    public RatesClass ratesClassModel(@PathVariable Long id, Model model) {
        return this.rateClassService.getRateClassById(id);
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute RatesClass rateClass, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "ratesClass-form";
        }
        this.rateClassService.updateRateClass(rateClass);
        redirectAttrs.addFlashAttribute("rateClass", (Object)rateClass);
        redirectAttrs.addFlashAttribute("message", (Object)"message.ratesClass.update");
        return "redirect:/ratesclass/success/" + rateClass.getId();
    }

    @RequestMapping(value={"/updateRatesClass/{id}"}, method={RequestMethod.GET})
    public String update(@PathVariable Long id) {
        return "redirect:/ratesclass/update/" + id;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public ModelAndView updateView(@PathVariable(value="id") Long id, @ModelAttribute RatesClass ratesclass) {
        return new ModelAndView("ratesClass/ratesClass-form", "ratesClass", (Object)this.rateClassService.getRateClassById(id));
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@ModelAttribute RatesClass rateClass, BindingResult errors) {
        if (errors.hasErrors()) {
            return "ratesClass-search";
        }
        return "redirect:/ratesclass/success/" + rateClass.getId();
    }
}

