/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.SubCategoryService;
import org.egov.adtax.web.controller.GenericController;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hoarding"})
public class SearchHoardingController
extends GenericController {
    @Autowired
    private FinancialYearDAO financialYearDAO;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private SubCategoryService subCategoryService;

    @ModelAttribute
    public AdvertisementPermitDetail advertisementPermitDetail() {
        return new AdvertisementPermitDetail();
    }

    @RequestMapping(value={"/subcategories-by-category"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SubCategory> hoardingSubcategories(@RequestParam Long categoryId) {
        return this.subCategoryService.getAllActiveSubCategoryByCategoryId(categoryId);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return "hoarding-search";
    }

    @RequestMapping(value={"/search-adtax"}, method={RequestMethod.GET})
    public String searchAdtaxForm() {
        return "advertisement-search";
    }

    @RequestMapping(value={"/search-adtax-result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchAdtaxResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetail, "Advertisement")) + "}"), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/search-list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String searchType = request.getParameter("searchType");
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetail, searchType)) + "}"), (Writer)response.getWriter());
    }

    public String commonSearchResult(AdvertisementPermitDetail advertisementPermitDetail, String searchType) {
        List searchResult = this.advertisementPermitDetailService.getAdvertisementSearchResult(advertisementPermitDetail, searchType);
        return "{ \"data\":" + searchResult + "}";
    }

    @RequestMapping(value={"search-for-update"}, method={RequestMethod.GET})
    public String searchHoardingForm(@ModelAttribute HoardingSearch hoardingSearch) {
        return "hoarding-search-for-update";
    }

    @RequestMapping(value={"search-for-update"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchHoarding(@ModelAttribute HoardingSearch hoardingSearch) {
        return "{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(hoardingSearch, "searchLegacyRecord")) + "}";
    }

    @RequestMapping(value={"view/{id}"}, method={RequestMethod.GET})
    public String viewHoarding(@PathVariable String id, Model model, @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail) {
        advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        model.addAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        model.addAttribute("arrearTax", (Object)this.advertisementDemandService.getPendingArrearsTax(advertisementPermitDetail));
        model.addAttribute("previousFinancialYear", (Object)this.financialYearDAO.getPreviousFinancialYearByDate(new Date()));
        return "hoarding-view";
    }

    @RequestMapping(value={"/renewal-search"}, method={RequestMethod.GET})
    public String renewalSearchForm() {
        return "renewal-search";
    }

    @RequestMapping(value={"/renewal-search-result"}, method={RequestMethod.GET})
    @ResponseBody
    public void renewSearchResult(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, HttpServletRequest request, HttpServletResponse response) throws IOException {
        IOUtils.write((String)("{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.advertisementPermitDetailService.getRenewalAdvertisementSearchResult(advertisementPermitDetail, "Advertisement")) + "}"), (Writer)response.getWriter());
    }
}

