/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.category;

import java.util.List;
import javax.validation.Valid;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.service.HoardingCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/category"})
public class CategoryController {
    private final HoardingCategoryService hoardingCategoryService;

    @Autowired
    public CategoryController(HoardingCategoryService hoardingCategoryService) {
        this.hoardingCategoryService = hoardingCategoryService;
    }

    @ModelAttribute(value="hoardingCategory")
    public HoardingCategory hoardingCategory() {
        return new HoardingCategory();
    }

    @ModelAttribute(value="hoardingCategories")
    public List<HoardingCategory> getAllHoardingCategory() {
        return this.hoardingCategoryService.getAllHoardingCategory();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String create() {
        return "category-form";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return "category-search";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute HoardingCategory hoardingCategory, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "category-form";
        }
        this.hoardingCategoryService.createHoardingCategory(hoardingCategory);
        redirectAttrs.addFlashAttribute("hoardingCategory", (Object)hoardingCategory);
        redirectAttrs.addFlashAttribute("message", (Object)"message.category.create");
        return "redirect:/category/success/" + hoardingCategory.getId();
    }

    @RequestMapping(value={"/success/{name}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="name") Long name, @ModelAttribute HoardingCategory hoardingCategory) {
        return new ModelAndView("category/category-success", "hoardingCategory", (Object)this.hoardingCategoryService.getCategoryById(name));
    }
}

