/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.tpbo;

import java.util.List;
import javax.validation.Valid;
import org.egov.adtax.entity.RevenueInspector;
import org.egov.adtax.service.RevenueInspectorService;
import org.egov.adtax.web.controller.GenericController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/tpbo"})
public class TpboController
extends GenericController {
    @Autowired
    private RevenueInspectorService revenueInspectorService;

    @RequestMapping(value={"create-tpbo"}, method={RequestMethod.GET})
    public String CreateTpbo(Model model) {
        model.addAttribute("revenueInspectorRecord", (Object)new RevenueInspector());
        return "tpbo-create";
    }

    @ModelAttribute(value="revenueInspector")
    public RevenueInspector RevenueInspector() {
        return new RevenueInspector();
    }

    @RequestMapping(value={"/create-revenue-inspector"}, method={RequestMethod.GET})
    public String create(@Valid @ModelAttribute RevenueInspector revenueInspector, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            redirectAttrs.addFlashAttribute("revenueInspector", (Object)revenueInspector);
            redirectAttrs.addFlashAttribute("code", (Object)"Unique.revenueInspector.code");
            return "tpbo-create";
        }
        revenueInspector = this.revenueInspectorService.create(revenueInspector);
        redirectAttrs.addFlashAttribute("existingTpboObject", (Object)revenueInspector);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.tpbo.create");
        return "redirect:/tpbo/success/" + revenueInspector.getId();
    }

    @RequestMapping(value={"/search-tpbo"}, method={RequestMethod.GET})
    public String SearchTpbo() {
        return "tpbo-search";
    }

    @ModelAttribute(value="revenueInspectorNames")
    public List<RevenueInspector> getAllRevenueInspectors() {
        return this.revenueInspectorService.findAll();
    }
}

