/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import javax.servlet.http.HttpServletRequest;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.workflow.entity.StateAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/advertisement"})
public class AdvertisementRenewalController
extends HoardingControllerSupport {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/renewal/{id}"}, method={RequestMethod.GET})
    public String renewForm(@PathVariable String id, Model model, @ModelAttribute AdvertisementPermitDetail renewalPermitDetail) {
        AdvertisementPermitDetail parentPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        if (parentPermitDetail != null && parentPermitDetail.getAdvertisement() != null && parentPermitDetail.getAdvertisement().getDemandId() != null && !this.advertisementDemandService.checkAnyTaxPendingForSelectedFinancialYear(parentPermitDetail.getAdvertisement(), parentPermitDetail.getAdvertisement().getDemandId().getEgInstallmentMaster()).booleanValue()) {
            model.addAttribute("message", (Object)"msg.renewal.taxNotPending");
            return "renewal-error";
        }
        if (parentPermitDetail != null && parentPermitDetail.getAdvertisement() != null && parentPermitDetail.getAdvertisement().getStatus() != null && parentPermitDetail.getAdvertisement().getStatus().equals((Object)AdvertisementStatus.WORKFLOW_IN_PROGRESS)) {
            model.addAttribute("message", (Object)"msg.renewal.alreadyInWorkFlow");
            return "renewal-error";
        }
        if (parentPermitDetail != null && parentPermitDetail.getAdvertisement() != null && parentPermitDetail.getAdvertisement().getStatus() != null && parentPermitDetail.getAdvertisement().getStatus().equals((Object)AdvertisementStatus.ACTIVE) && parentPermitDetail.getStatus() != null && parentPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
            model.addAttribute("message", (Object)"msg.renewal.paymentPending");
            return "renewal-error";
        }
        this.loadBasicData(model, parentPermitDetail, renewalPermitDetail);
        model.addAttribute("renewalPermitDetail", (Object)renewalPermitDetail);
        model.addAttribute("additionalRule", (Object)"RENEWADVERTISEMENT");
        model.addAttribute("stateType", (Object)renewalPermitDetail.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)"NEW");
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule("RENEWADVERTISEMENT");
        this.prepareWorkflow(model, (StateAware)renewalPermitDetail, workFlowContainer);
        model.addAttribute("agency", (Object)parentPermitDetail.getAgency());
        model.addAttribute("advertisementDocuments", (Object)parentPermitDetail.getAdvertisement().getDocuments());
        return "renewal-newform";
    }

    private void loadBasicData(Model model, AdvertisementPermitDetail parentPermitDetail, AdvertisementPermitDetail renewalPermitDetail) {
        renewalPermitDetail.setAdvertisement(parentPermitDetail.getAdvertisement());
        renewalPermitDetail.setAdvertisementDuration(parentPermitDetail.getAdvertisementDuration());
        renewalPermitDetail.setAdvertisementParticular(parentPermitDetail.getAdvertisementParticular());
        renewalPermitDetail.setAdvertiser(parentPermitDetail.getAdvertiser());
        renewalPermitDetail.setApplicationDate(parentPermitDetail.getApplicationDate());
        renewalPermitDetail.setApplicationNumber(parentPermitDetail.getApplicationNumber());
        renewalPermitDetail.setPermissionNumber(parentPermitDetail.getPermissionNumber());
        renewalPermitDetail.setAgency(parentPermitDetail.getAgency());
        renewalPermitDetail.setEncroachmentFee(parentPermitDetail.getEncroachmentFee());
        renewalPermitDetail.setOwnerDetail(parentPermitDetail.getOwnerDetail());
        renewalPermitDetail.setPermissionstartdate(parentPermitDetail.getPermissionstartdate());
        renewalPermitDetail.setPermissionenddate(parentPermitDetail.getPermissionenddate());
        renewalPermitDetail.setBreadth(parentPermitDetail.getBreadth());
        renewalPermitDetail.setMeasurement(parentPermitDetail.getMeasurement());
        renewalPermitDetail.setLength(parentPermitDetail.getLength());
        renewalPermitDetail.setTaxAmount(parentPermitDetail.getTaxAmount());
        renewalPermitDetail.setPreviousapplicationid(parentPermitDetail);
        renewalPermitDetail.setWidth(parentPermitDetail.getWidth());
        renewalPermitDetail.setUnitOfMeasure(parentPermitDetail.getUnitOfMeasure());
    }

    @RequestMapping(value={"/renewal/{id}"}, method={RequestMethod.POST})
    public String renewSave(@ModelAttribute AdvertisementPermitDetail renewalPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib, HttpServletRequest request, Model model, @RequestParam String workFlowAction, @PathVariable String id) {
        this.validateHoardingDocsOnUpdate(renewalPermitDetail, resultBinder, redirAttrib);
        if (renewalPermitDetail.getState() == null) {
            renewalPermitDetail.setStatus(this.advertisementPermitDetailService.getStatusByModuleAndCode("CREATED"));
        }
        renewalPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.WORKFLOW_IN_PROGRESS);
        if (resultBinder.hasErrors()) {
            WorkflowContainer workFlowContainer = new WorkflowContainer();
            workFlowContainer.setAdditionalRule("RENEWADVERTISEMENT");
            this.prepareWorkflow(model, (StateAware)renewalPermitDetail, workFlowContainer);
            model.addAttribute("additionalRule", (Object)"RENEWADVERTISEMENT");
            model.addAttribute("stateType", (Object)renewalPermitDetail.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)"NEW");
            return "renewal-newform";
        }
        try {
            this.updateHoardingDocuments(renewalPermitDetail);
            Long approvalPosition = 0L;
            String approvalComment = "";
            String approverName = "";
            String nextDesignation = "";
            if (request.getParameter("approvalComent") != null) {
                approvalComment = request.getParameter("approvalComent");
            }
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            if (request.getParameter("approverName") != null) {
                approverName = request.getParameter("approverName");
            }
            if (request.getParameter("nextDesignation") != null) {
                nextDesignation = request.getParameter("nextDesignation");
            }
            if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
            }
            this.advertisementPermitDetailService.renewal(renewalPermitDetail, approvalPosition, approvalComment, "RENEWADVERTISEMENT", workFlowAction);
            redirAttrib.addFlashAttribute("advertisementPermitDetail", (Object)renewalPermitDetail);
            String message = this.messageSource.getMessage("msg.success.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), renewalPermitDetail.getApplicationNumber()}, null);
            redirAttrib.addFlashAttribute("message", (Object)message);
            return "redirect:/hoarding/success/" + renewalPermitDetail.getId();
        }
        catch (HoardingValidationError e) {
            resultBinder.rejectValue(e.fieldName(), e.errorCode());
            return "renewal-newform";
        }
    }
}

