/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.commons.Installment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class CreateAdvertisementController
extends HoardingControllerSupport {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"child-boundaries"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> childBoundaries(@RequestParam Long parentBoundaryId) {
        return this.boundaryService.getActiveChildBoundariesByBoundaryId(parentBoundaryId);
    }

    @RequestMapping(value={"subcategories"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SubCategory> hoardingSubcategories(@RequestParam Long categoryId) {
        return this.subCategoryService.getAllActiveSubCategoryByCategoryId(categoryId);
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String createHoardingForm(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, Model model) {
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
        this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, workFlowContainer);
        model.addAttribute("additionalRule", (Object)"CREATEADVERTISEMENT");
        model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)"NEW");
        return "hoarding-create";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String createAdvertisement(@Valid @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        this.validateHoardingDocs(advertisementPermitDetail, resultBinder);
        this.validateApplicationDate(advertisementPermitDetail, resultBinder);
        this.validateAdvertisementDetails(advertisementPermitDetail, resultBinder);
        if (advertisementPermitDetail.getState() == null) {
            advertisementPermitDetail.setStatus(this.advertisementPermitDetailService.getStatusByModuleAndCode("CREATED"));
        }
        advertisementPermitDetail.getAdvertisement().setStatus(AdvertisementStatus.WORKFLOW_IN_PROGRESS);
        if (resultBinder.hasErrors()) {
            WorkflowContainer workFlowContainer = new WorkflowContainer();
            workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
            this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, workFlowContainer);
            model.addAttribute("additionalRule", (Object)"CREATEADVERTISEMENT");
            model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
            return "hoarding-create";
        }
        this.storeHoardingDocuments(advertisementPermitDetail);
        Long approvalPosition = 0L;
        String approvalComment = "";
        String approverName = "";
        String nextDesignation = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approverName") != null) {
            approverName = request.getParameter("approverName");
        }
        if (request.getParameter("nextDesignation") != null) {
            nextDesignation = request.getParameter("nextDesignation");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        advertisementPermitDetail.getAdvertisement().setPenaltyCalculationDate(advertisementPermitDetail.getApplicationDate());
        this.advertisementPermitDetailService.createAdvertisementPermitDetail(advertisementPermitDetail, approvalPosition, approvalComment, "CREATEADVERTISEMENT", workFlowAction);
        redirAttrib.addFlashAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        String message = this.messageSource.getMessage("msg.success.forward", (Object[])new String[]{approverName.concat("~").concat(nextDesignation), advertisementPermitDetail.getApplicationNumber()}, null);
        redirAttrib.addFlashAttribute("message", (Object)message);
        return "redirect:/hoarding/success/" + advertisementPermitDetail.getId();
    }

    private void validateApplicationDate(AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder) {
        Installment installmentObj;
        if (advertisementPermitDetail != null && advertisementPermitDetail.getApplicationDate() != null && (installmentObj = this.advertisementDemandService.getCurrentInstallment()) != null && installmentObj.getFromDate() != null && (advertisementPermitDetail.getApplicationDate().after(DateUtils.endOfDay((Date)installmentObj.getToDate())) || advertisementPermitDetail.getApplicationDate().before(DateUtils.startOfDay((Date)installmentObj.getFromDate())))) {
            resultBinder.rejectValue("applicationDate", "invalid.applicationDate");
        }
    }

    @RequestMapping(value={"/success/{id}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="id") String id, @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail) {
        return new ModelAndView("hoarding/hoarding-success", "hoarding", (Object)this.advertisementPermitDetailService.findBy(Long.valueOf(id)));
    }
}

