/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.reports;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/advertisement"})
public class ReportController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;

    @RequestMapping(value={"/permitOrder"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generatePermitOrder(HttpServletRequest request, HttpSession session) {
        String errorMessage = "";
        String workFlowAction = "";
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(request.getParameter("pathVar")));
        if (!"".isEmpty()) {
            return this.redirect("");
        }
        return this.generatePermitOrder(request, advertisementPermitDetail, session, "");
    }

    @RequestMapping(value={"/demandNotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateDemandNotice(HttpServletRequest request, HttpSession session) {
        String errorMessage = "";
        String workFlowAction = "";
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(request.getParameter("pathVar")));
        workFlowAction = (String)session.getAttribute("workFlowAction");
        if (!"".isEmpty()) {
            return this.redirect("");
        }
        return this.generateDemandNotice(request, advertisementPermitDetail, session, workFlowAction);
    }

    private ResponseEntity<byte[]> generatePermitOrder(HttpServletRequest request, AdvertisementPermitDetail advertisementPermitDetail, HttpSession session, String workFlowAction) {
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (null != advertisementPermitDetail) {
            Map reportParams = this.buildParametersForReport(request, advertisementPermitDetail);
            reportParams.put("advertisementtitle", WordUtils.capitalize((String)"Advertisement Permit Order"));
            reportInput = new ReportRequest("permitOrder", (Object)advertisementPermitDetail, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Permit Order.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private void buildMeasurementDetailsForJasper(AdvertisementPermitDetail advertisementPermitDetail, StringBuffer measurement, Map<String, Object> reportParams, String NOTMENTIONED) {
        measurement.append(advertisementPermitDetail.getMeasurement() == null ? NOTMENTIONED : advertisementPermitDetail.getMeasurement()).append(" ");
        if (advertisementPermitDetail.getMeasurement() != null) {
            measurement.append(advertisementPermitDetail.getUnitOfMeasure().getDescription());
        }
        if (advertisementPermitDetail.getLength() != null) {
            measurement.append(" Length : ").append(advertisementPermitDetail.getLength());
        }
        if (advertisementPermitDetail.getBreadth() != null) {
            measurement.append(" Breadth : ").append(advertisementPermitDetail.getBreadth());
        }
        if (advertisementPermitDetail.getTotalHeight() != null) {
            measurement.append(" Height : ").append(advertisementPermitDetail.getTotalHeight());
        }
        reportParams.put("measurement", measurement.toString());
    }

    private ResponseEntity<byte[]> generateDemandNotice(HttpServletRequest request, AdvertisementPermitDetail advertisementPermitDetail, HttpSession session, String workFlowAction) {
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (null != advertisementPermitDetail) {
            Map reportParams = this.buildParametersForReport(request, advertisementPermitDetail);
            reportParams.put("taxamount", advertisementPermitDetail.getTaxAmount() == null ? Long.valueOf(0L) : advertisementPermitDetail.getTaxAmount());
            reportParams.put("encroachmentfee", advertisementPermitDetail.getEncroachmentFee() == null ? Long.valueOf(0L) : advertisementPermitDetail.getEncroachmentFee());
            reportInput = new ReportRequest("demandNotice", (Object)advertisementPermitDetail, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Demand Notice.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private Map<String, Object> buildParametersForReport(HttpServletRequest request, AdvertisementPermitDetail advertisementPermitDetail) {
        StringBuffer measurement = new StringBuffer();
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        String NOTMENTIONED = "Not Mentioned ";
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        reportParams.put("logoPath", cityLogo);
        reportParams.put("cityName", cityName);
        reportParams.put("advertisementtitle", WordUtils.capitalize((String)"Advertisement Demand Notice"));
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put("advertisementnumber", advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
        reportParams.put("permitNumber", advertisementPermitDetail.getPermissionNumber());
        reportParams.put("applicationNumber", advertisementPermitDetail.getApplicationNumber());
        if (advertisementPermitDetail.getAgency() != null && StringUtils.isNotBlank((String)advertisementPermitDetail.getOwnerDetail())) {
            reportParams.put("agencyname", advertisementPermitDetail.getAgency().getName() + "/" + advertisementPermitDetail.getOwnerDetail());
            reportParams.put("agencyaddress", advertisementPermitDetail.getAgency().getAddress());
        } else if (advertisementPermitDetail.getAgency() != null && StringUtils.isBlank((String)advertisementPermitDetail.getOwnerDetail())) {
            reportParams.put("agencyname", advertisementPermitDetail.getAgency().getName());
            reportParams.put("agencyaddress", advertisementPermitDetail.getAgency().getAddress());
        } else {
            reportParams.put("agencyname", advertisementPermitDetail.getOwnerDetail());
            reportParams.put("agencyaddress", NOTMENTIONED);
        }
        reportParams.put("address", advertisementPermitDetail.getAdvertisement().getAddress());
        reportParams.put("applicationDate", formatter.format(advertisementPermitDetail.getApplicationDate()));
        reportParams.put("category", advertisementPermitDetail.getAdvertisement().getCategory().getName());
        reportParams.put("subjectMatter", advertisementPermitDetail.getAdvertisementParticular());
        this.buildMeasurementDetailsForJasper(advertisementPermitDetail, measurement, reportParams, NOTMENTIONED);
        reportParams.put("permitStartDate", formatter.format(advertisementPermitDetail.getPermissionstartdate()));
        reportParams.put("permitEndDate", formatter.format(advertisementPermitDetail.getPermissionenddate()));
        reportParams.put("currdate", formatter.format(new Date()));
        return reportParams;
    }

    private ResponseEntity<byte[]> redirect(String errorMessage) {
        errorMessage = "<html><body><p style='color:red;border:1px solid gray;padding:15px;'>" + errorMessage + "</p></body></html>";
        byte[] byteData = errorMessage.getBytes();
        errorMessage = "";
        return new ResponseEntity((Object)byteData, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/demandNotice/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewDemandNoticeReport(@PathVariable String id, HttpSession session, HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetails = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        return this.generateDemandNotice(request, advertisementPermitDetails, session, null);
    }

    @RequestMapping(value={"/permitOrder/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewPermitOrderReport(@PathVariable String id, HttpSession session, HttpServletRequest request) {
        AdvertisementPermitDetail advertisementPermitDetails = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        if (!"ADTAXPERMITGENERATED".equalsIgnoreCase(advertisementPermitDetails.getStatus().getCode())) {
            this.advertisementPermitDetailService.updateStateTransition(advertisementPermitDetails, Long.valueOf(0L), "", "CREATEADVERTISEMENT", "GENERATE PERMIT ORDER");
        }
        return this.generatePermitOrder(request, advertisementPermitDetails, session, null);
    }
}

