/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import javax.servlet.http.HttpServletRequest;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.workflow.entity.StateAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class UpdateHoardingController
extends HoardingControllerSupport {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    private WorkflowContainer workFlowContainer = null;

    @ModelAttribute(value="advertisementPermitDetail")
    public AdvertisementPermitDetail advertisementPermitDetail(@PathVariable String id) {
        return this.advertisementPermitDetailService.findBy(Long.valueOf(id));
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String updateHoarding(@PathVariable String id, Model model) {
        this.workFlowContainer = new WorkflowContainer();
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        model.addAttribute("dcPending", (Object)this.advertisementDemandService.anyDemandPendingForCollection(advertisementPermitDetail));
        model.addAttribute("advertisementPermitDetail", (Object)advertisementPermitDetail);
        if (advertisementPermitDetail != null && advertisementPermitDetail.getPreviousapplicationid() != null) {
            model.addAttribute("additionalRule", (Object)"RENEWADVERTISEMENT");
            this.workFlowContainer.setAdditionalRule("RENEWADVERTISEMENT");
        } else {
            model.addAttribute("additionalRule", (Object)"CREATEADVERTISEMENT");
            this.workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
        }
        model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
        model.addAttribute("currentState", (Object)advertisementPermitDetail.getCurrentState().getValue());
        this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, this.workFlowContainer);
        model.addAttribute("agency", (Object)advertisementPermitDetail.getAgency());
        model.addAttribute("advertisementDocuments", (Object)advertisementPermitDetail.getAdvertisement().getDocuments());
        return "hoarding-update";
    }

    @RequestMapping(value={"update/{id}"}, method={RequestMethod.POST})
    public String updateHoarding(@ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib, HttpServletRequest request, Model model, @RequestParam String workFlowAction) {
        this.validateHoardingDocsOnUpdate(advertisementPermitDetail, resultBinder, redirAttrib);
        if (resultBinder.hasErrors()) {
            this.workFlowContainer = new WorkflowContainer();
            if (advertisementPermitDetail != null && advertisementPermitDetail.getPreviousapplicationid() != null) {
                model.addAttribute("additionalRule", (Object)"RENEWADVERTISEMENT");
                this.workFlowContainer.setAdditionalRule("RENEWADVERTISEMENT");
            } else {
                model.addAttribute("additionalRule", (Object)"CREATEADVERTISEMENT");
                this.workFlowContainer.setAdditionalRule("CREATEADVERTISEMENT");
            }
            this.prepareWorkflow(model, (StateAware)advertisementPermitDetail, this.workFlowContainer);
            model.addAttribute("stateType", (Object)advertisementPermitDetail.getClass().getSimpleName());
            model.addAttribute("currentState", (Object)advertisementPermitDetail.getCurrentState().getValue());
            return "hoarding-update";
        }
        try {
            Long approvalPosition = 0L;
            String approvalComment = "";
            String approverName = "";
            String nextDesignation = "";
            String message = "";
            if (request.getParameter("approverName") != null) {
                approverName = request.getParameter("approverName");
            }
            if (request.getParameter("nextDesignation") != null) {
                nextDesignation = request.getParameter("nextDesignation");
            }
            if (request.getParameter("approvalComent") != null) {
                approvalComment = request.getParameter("approvalComent");
            }
            if (request.getParameter("workFlowAction") != null) {
                workFlowAction = request.getParameter("workFlowAction");
            }
            if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
                approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
            }
            if ("GENERATE DEMAND NOTICE".equalsIgnoreCase(workFlowAction)) {
                return "redirect:/advertisement/demandNotice?pathVar=" + advertisementPermitDetail.getId();
            }
            this.updateHoardingDocuments(advertisementPermitDetail);
            this.advertisementPermitDetailService.updateAdvertisementPermitDetail(advertisementPermitDetail, approvalPosition, approvalComment, advertisementPermitDetail != null && advertisementPermitDetail.getPreviousapplicationid() != null ? "RENEWADVERTISEMENT" : "CREATEADVERTISEMENT", workFlowAction);
            redirAttrib.addFlashAttribute("advertisementNumber", (Object)advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
            if ("Approve".equals(workFlowAction)) {
                message = this.messageSource.getMessage("msg.success.approved", (Object[])new String[]{advertisementPermitDetail.getPermissionNumber()}, null);
                redirAttrib.addFlashAttribute("message", (Object)message);
            } else if ("REJECT".equalsIgnoreCase(workFlowAction) || "CANCEL APPLICATION".equalsIgnoreCase(workFlowAction) || "CANCEL RENEWAL".equalsIgnoreCase(workFlowAction)) {
                Assignment wfInitiator = this.advertisementPermitDetailService.getWfInitiator(advertisementPermitDetail);
                if (ApplicationThreadLocals.getUserId().equals(wfInitiator.getEmployee().getId())) {
                    message = this.messageSource.getMessage("msg.success.cancelled", (Object[])new String[]{advertisementPermitDetail.getApplicationNumber()}, null);
                    redirAttrib.addFlashAttribute("message", (Object)message);
                } else {
                    approverName = wfInitiator.getEmployee().getName();
                    nextDesignation = wfInitiator.getDesignation().getName();
                    message = this.messageSource.getMessage("msg.success.reject", (Object[])new String[]{advertisementPermitDetail.getApplicationNumber(), approverName.concat("~").concat(nextDesignation)}, null);
                    redirAttrib.addFlashAttribute("message", (Object)message);
                }
            } else {
                if ("GENERATE PERMIT ORDER".equalsIgnoreCase(workFlowAction)) {
                    return "redirect:/advertisement/permitOrder?pathVar=" + advertisementPermitDetail.getId();
                }
                message = this.messageSource.getMessage("msg.success.forward.on.reject", (Object[])new String[]{approverName.concat("~").concat(nextDesignation)}, advertisementPermitDetail.getApplicationNumber(), null);
                redirAttrib.addFlashAttribute("message", (Object)message);
            }
            return "redirect:/hoarding/success/" + advertisementPermitDetail.getId();
        }
        catch (HoardingValidationError e) {
            resultBinder.rejectValue(e.fieldName(), e.errorCode());
            return "hoarding-update";
        }
    }
}

