/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.category;

import javax.validation.Valid;
import org.egov.adtax.entity.HoardingCategory;
import org.egov.adtax.service.HoardingCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/category"})
public class UpdateCategoryController {
    private final HoardingCategoryService hoardingCategoryService;

    @Autowired
    public UpdateCategoryController(HoardingCategoryService hoardingCategoryService) {
        this.hoardingCategoryService = hoardingCategoryService;
    }

    @ModelAttribute
    public HoardingCategory hoardingCategoryModel(@PathVariable Long id, Model model) {
        return this.hoardingCategoryService.getCategoryById(id);
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute HoardingCategory hoardingCategory, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "category-form";
        }
        this.hoardingCategoryService.updateHoardingCategory(hoardingCategory);
        redirectAttrs.addFlashAttribute("hoardingCategory", (Object)hoardingCategory);
        redirectAttrs.addFlashAttribute("message", (Object)"message.category.update");
        return "redirect:/category/success/" + hoardingCategory.getId();
    }

    @RequestMapping(value={"/updateCategory/{id}"}, method={RequestMethod.GET})
    public String update(@PathVariable Long id) {
        return "redirect:/category/update/" + id;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public ModelAndView updateView(@PathVariable(value="id") Long id, @ModelAttribute HoardingCategory hoardingCategory) {
        return new ModelAndView("category/category-form", "hoardingCategory", (Object)this.hoardingCategoryService.getCategoryById(id));
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String view(@ModelAttribute HoardingCategory hoardingCategory, BindingResult errors) {
        if (errors.hasErrors()) {
            return "category-search";
        }
        return "redirect:/category/success/" + hoardingCategory.getId();
    }
}

