/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.adtax.entity.SubCategory;
import org.egov.adtax.service.AdvertisementRateService;
import org.egov.adtax.service.SubCategoryService;
import org.egov.adtax.service.penalty.AdvertisementTaxCalculator;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.ptis.wtms.PropertyIntegrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxController {
    @Autowired
    private SubCategoryService subCategoryService;
    @Autowired
    protected AdvertisementRateService advertisementRateService;
    @Autowired
    private AdvertisementTaxCalculator advertisementTaxCalculator;
    @Autowired
    @Qualifier(value="propertyIntegrationServiceImpl")
    private PropertyIntegrationService propertyIntegrationService;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    @RequestMapping(value={"/ajax-subCategories"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<SubCategory> getDesignations(@RequestParam Long category, HttpServletResponse response) {
        List<Object> subCategoryList = new ArrayList<SubCategory>();
        if (category != null && !"".equals(category)) {
            subCategoryList = this.subCategoryService.getAllActiveSubCategoryByCategoryId(category);
            subCategoryList.forEach(subCategory -> subCategory.toString());
        }
        return subCategoryList;
    }

    @RequestMapping(value={"/ajax-assessmentDetails"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public AssessmentDetails getAssessmentDetails(@RequestParam String assessmentNoRequest) {
        AssessmentDetails assessmentDetail = this.propertyIntegrationService.getAssessmentDetailsForFlag(assessmentNoRequest, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        return assessmentDetail;
    }

    @RequestMapping(value={"/hoarding/calculateTaxAmount"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Double getTaxAmount(@RequestParam Long unitOfMeasureId, @RequestParam Double measurement, @RequestParam Long subCategoryId, @RequestParam Long rateClassId) {
        return this.advertisementTaxCalculator.calculateTaxAmount(unitOfMeasureId, measurement, subCategoryId, rateClassId);
    }
}

