/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.collection.AgencyWiseBillable;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.Installment;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AgencyWiseBillServiceImpl
extends BillServiceInterface {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetailList = new ArrayList<EgBillDetails>();
        int orderNo = 1;
        AgencyWiseBillable agencyWiseBillable = (AgencyWiseBillable)billObj;
        EgDemand dmd = agencyWiseBillable.getCurrentDemand();
        ArrayList details = new ArrayList(dmd.getEgDemandDetails());
        if (!details.isEmpty()) {
            Collections.sort(details, (c1, c2) -> c1.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().compareTo(c2.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()));
        }
        for (EgDemandDetails demandDetail : details) {
            if (demandDetail.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal creaditAmt = BigDecimal.ZERO;
            creaditAmt = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (creaditAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, creaditAmt, demandDetail.getEgDemandReason().getGlcodeId().getGlcode(), this.getReceiptDetailDescription(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), demandDetail.getEgDemandReason().getEgInstallmentMaster()));
            ++orderNo;
            billDetailList.add(billdetail);
        }
        return billDetailList;
    }

    private String getReceiptDetailDescription(String reasonType, Installment instlment) {
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        ArrayList<String> taxTypeList = new ArrayList<String>();
        for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
            if (advertisementAdditionalTaxRate == null) continue;
            taxTypeList.add(advertisementAdditionalTaxRate.getTaxType());
        }
        if (taxTypeList.contains(reasonType)) {
            return reasonType + " " + "Collection";
        }
        return reasonType + " " + "Collection" + (instlment != null ? " " + instlment.getDescription() : "");
    }

    private EgBillDetails createBillDetailObject(int orderNo, BigDecimal debitAmount, BigDecimal creditAmount, String glCodeForDemandDetail, String description) {
        EgBillDetails billdetail = new EgBillDetails();
        billdetail.setFunctionCode("9300");
        billdetail.setOrderNo(Integer.valueOf(orderNo));
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        billdetail.setCrAmount(creditAmount);
        billdetail.setDrAmount(debitAmount);
        billdetail.setGlcode(glCodeForDemandDetail);
        billdetail.setDescription(description);
        billdetail.setAdditionalFlag(Integer.valueOf(1));
        billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
        return billdetail;
    }

    public void cancelBill() {
    }

    @Transactional
    public String getBillXML(Billable billObj) {
        String collectXML = URLEncoder.encode(super.getBillXML(billObj));
        return collectXML;
    }
}

