/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.List;
import org.egov.adtax.entity.Agency;
import org.egov.adtax.entity.enums.AgencyStatus;
import org.egov.adtax.repository.AgencyRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AgencyService {
    private final AgencyRepository agencyRepository;

    @Autowired
    public AgencyService(AgencyRepository agencyRepository) {
        this.agencyRepository = agencyRepository;
    }

    @Transactional
    public Agency createAgency(Agency agency) {
        return (Agency)((Object)this.agencyRepository.save((Object)agency));
    }

    @Transactional
    public Agency updateAgency(Agency agency) {
        return (Agency)((Object)this.agencyRepository.save((Object)agency));
    }

    public Agency findByCode(String code) {
        return this.agencyRepository.findByCode(code);
    }

    public Agency findByName(String name) {
        return this.agencyRepository.findByName(name.trim());
    }

    public List<Agency> findAll() {
        return this.agencyRepository.findAll();
    }

    public List<Agency> findAllByNameLike(String name) {
        return this.agencyRepository.findByNameContainingIgnoreCase(name);
    }

    public List<Agency> findAllActiveByName(String name, AgencyStatus status) {
        return this.agencyRepository.findByNameContainingIgnoreCaseAndStatus(name, status);
    }
}

