/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.workflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.Position;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementWorkFlowService {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private EisCommonService eisCommonService;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public String getDesignationForThirdPartyUser() {
        String appConfigKey = "ADTAXDESIGNATIONFORWORKFLOW";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", appConfigKey);
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public String getDepartmentForWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "ADTAXDEPARTMENTFORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || appconfig == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List<AppConfigValues> appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "ADTAXROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : Collections.emptyList();
    }

    public Boolean isCscOperator(User user) {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "ADTAXROLEFORNONEMPLOYEE");
        String rolesForNonEmployee = !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
        for (Role role : user.getRoles()) {
            if (role == null || rolesForNonEmployee == null || !role.getName().equalsIgnoreCase(rolesForNonEmployee)) continue;
            return true;
        }
        return false;
    }

    public String getDesignationForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "ADTAXDESIGNATIONFORCSCOPERATORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public String getDepartmentForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "ADTAXDEPARTMENTFORCSCOPERATORWORKFLOW");
        return !appConfigValue.isEmpty() ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public Assignment getAssignmentByDeptDesigElecWard(AdvertisementPermitDetail advertisementPermitDetail) {
        String designationStr = this.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.getDepartmentForCscOperatorWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                Long deptId = this.departmentService.getDepartmentByName(dept).getId();
                Long desgId = this.designationService.getDesignationByName(desg).getId();
                Long boundaryId = advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getElectionWard() != null ? advertisementPermitDetail.getAdvertisement().getElectionWard().getId() : null;
                assignment = boundaryId == null ? this.assignmentService.findByDepartmentAndDesignation(deptId, desgId) : this.assignmentService.findAssignmentByDepartmentDesignationAndBoundary(deptId, desgId, boundaryId);
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public Assignment getUserPositionByZone(AdvertisementPermitDetail advertisementPermitDetail) {
        String designationStr = this.getDesignationForThirdPartyUser();
        String departmentStr = this.getDepartmentForWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentAndDesignation(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public Assignment getMappedAssignmentForCscOperator(AdvertisementPermitDetail advertisementPermitDetail) {
        Assignment assignment = this.getAssignmentByDeptDesigElecWard(advertisementPermitDetail);
        if (assignment == null) {
            assignment = this.getUserPositionByZone(advertisementPermitDetail);
        }
        return assignment;
    }

    public Assignment getWorkFlowInitiator(AdvertisementPermitDetail advertisementPermitDetail) {
        Assignment wfInitiator = null;
        if (advertisementPermitDetail != null) {
            if (advertisementPermitDetail.getState() != null && advertisementPermitDetail.getState().getInitiatorPosition() != null) {
                wfInitiator = this.getUserAssignmentByPassingPositionAndUser(advertisementPermitDetail.getCreatedBy(), (Position)advertisementPermitDetail.getState().getInitiatorPosition());
                if (wfInitiator == null) {
                    List assignment = this.assignmentService.getAssignmentsForPosition(((Position)advertisementPermitDetail.getState().getInitiatorPosition()).getId(), new Date());
                    wfInitiator = this.getActiveAssignment(assignment);
                }
            } else {
                wfInitiator = this.isEmployee(advertisementPermitDetail.getCreatedBy()) == false || advertisementPermitDetail.getCreatedBy().getName().equalsIgnoreCase("anonymous") ? this.getUserAssignment(advertisementPermitDetail.getCreatedBy(), advertisementPermitDetail) : this.assignmentService.getPrimaryAssignmentForUser(advertisementPermitDetail.getCreatedBy().getId());
            }
        }
        return wfInitiator;
    }

    private Assignment getUserAssignmentByPassingPositionAndUser(User user, Position position) {
        Assignment wfInitiatorAssignment = null;
        if (user != null && position != null) {
            List assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date());
            for (Assignment assignment : assignmentList) {
                if (position.getId() != assignment.getPosition().getId()) continue;
                wfInitiatorAssignment = assignment;
            }
        }
        return wfInitiatorAssignment;
    }

    public Boolean validateUserHasSamePositionAsInitiator(Long userId, Position position) {
        Boolean userHasSamePosition = false;
        if (userId != null && position != null) {
            List assignmentList = this.assignmentService.findByEmployeeAndGivenDate(userId, new Date());
            for (Assignment assignment : assignmentList) {
                if (position.getId() != assignment.getPosition().getId()) continue;
                userHasSamePosition = true;
            }
        }
        return userHasSamePosition;
    }

    public Assignment getUserAssignment(User user, AdvertisementPermitDetail advertisementPermitDetail) {
        Assignment assignment = this.isCscOperator(user) != false || user.getUsername().equalsIgnoreCase("anonymous") ? this.getMappedAssignmentForCscOperator(advertisementPermitDetail) : this.getWorkFlowInitiator(advertisementPermitDetail);
        return assignment;
    }

    private Assignment getActiveAssignment(List<Assignment> assignment) {
        Assignment wfInitiator = null;
        for (Assignment assign : assignment) {
            if (!assign.getEmployee().isActive()) continue;
            wfInitiator = assign;
            break;
        }
        return wfInitiator;
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public List<Map<String, Object>> getHistory(AdvertisementPermitDetail advertisementPermitDetail) {
        ArrayList<Map<String, Object>> historyTable = new ArrayList<Map<String, Object>>();
        State state = advertisementPermitDetail.getState();
        HashMap<String, Object> map = new HashMap<String, Object>(0);
        if (null != state) {
            User user;
            if (!advertisementPermitDetail.getStateHistory().isEmpty() && advertisementPermitDetail.getStateHistory() != null) {
                Collections.reverse(advertisementPermitDetail.getStateHistory());
            }
            for (StateHistory stateHistory : advertisementPermitDetail.getStateHistory()) {
                HashMap<String, Object> historyMap = new HashMap<String, Object>(0);
                historyMap.put("date", stateHistory.getDateInfo());
                historyMap.put("comments", stateHistory.getComments() != null ? stateHistory.getComments() : "");
                historyMap.put("updatedBy", stateHistory.getLastModifiedBy().getUsername() + "::" + stateHistory.getLastModifiedBy().getName());
                historyMap.put("status", stateHistory.getValue());
                Position owner = (Position)stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    historyMap.put("user", user.getUsername() + "::" + user.getName());
                    historyMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    user = this.eisCommonService.getUserForPosition(owner.getId(), new Date());
                    historyMap.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                    historyMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(historyMap);
            }
            map.put("date", state.getDateInfo());
            map.put("comments", state.getComments() != null ? state.getComments() : "");
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            Position ownerPosition = (Position)state.getOwnerPosition();
            user = state.getOwnerUser();
            if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
                map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
            } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
                user = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != user.getUsername() ? user.getUsername() + "::" + user.getName() : "");
                map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
            }
            historyTable.add(map);
        }
        return historyTable;
    }
}

