/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.notice;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementNoticeService {
    private static final String AGENCYADDRESS = "agencyaddress";
    private static final String AGENCYNAME = "agencyname";
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AdvertisementPenaltyCalculator advertisementPenaltyCalculator;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;
    @Autowired
    private CityService cityService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource advertisementReportMessageSource;
    @Autowired
    private ReportService reportService;

    public ReportOutput generatePermitOrder(AdvertisementPermitDetail advertisementPermitDetail, Map<String, Object> ulbDetailsReportParams) {
        ReportRequest reportInput = null;
        if (null != advertisementPermitDetail) {
            Map<String, Object> reportParams = this.buildParametersForReport(advertisementPermitDetail);
            reportParams.putAll(ulbDetailsReportParams);
            reportParams.put("advertisementtitle", WordUtils.capitalize((String)"Advertisement Permit Order"));
            reportInput = new ReportRequest("adtax_permitOrder", (Object)advertisementPermitDetail, reportParams);
            reportInput.setReportFormat(ReportFormat.PDF);
        }
        return this.reportService.createReport(reportInput);
    }

    public ReportOutput generateDemandNotice(AdvertisementPermitDetail advertisementPermitDetail, Map<String, Object> ulbDetailsReportParams) {
        ReportRequest reportInput = null;
        if (null != advertisementPermitDetail) {
            Map<String, Object> reportParams = this.buildParametersForReport(advertisementPermitDetail);
            reportParams.putAll(ulbDetailsReportParams);
            reportParams.putAll(this.buildParametersForDemandDetails(advertisementPermitDetail));
            String cityGrade = this.getCityGrade();
            if (cityGrade != null && cityGrade.equalsIgnoreCase("Corp")) {
                reportParams.put("lawAct", this.advertisementReportMessageSource.getMessage("msg.ap.law.act.corporation", (Object[])new String[0], Locale.getDefault()));
            } else {
                reportParams.put("lawAct", this.advertisementReportMessageSource.getMessage("msg.ap.law.act.municipality", (Object[])new String[0], Locale.getDefault()));
            }
            reportInput = new ReportRequest("demandNotice", (Object)advertisementPermitDetail, reportParams);
            reportInput.setReportFormat(ReportFormat.PDF);
        }
        return this.reportService.createReport(reportInput);
    }

    private void buildMeasurementDetailsForJasper(AdvertisementPermitDetail advertisementPermitDetail, StringBuilder measurement, Map<String, Object> reportParams, String notMentioned) {
        measurement.append(advertisementPermitDetail.getMeasurement() == null ? notMentioned : advertisementPermitDetail.getMeasurement()).append(" ");
        if (advertisementPermitDetail.getMeasurement() != null) {
            measurement.append(advertisementPermitDetail.getUnitOfMeasure().getDescription());
        }
        if (advertisementPermitDetail.getLength() != null) {
            measurement.append(" Length : ").append(advertisementPermitDetail.getLength());
        }
        if (advertisementPermitDetail.getWidth() != null) {
            measurement.append(" Breadth : ").append(advertisementPermitDetail.getWidth());
        }
        if (advertisementPermitDetail.getTotalHeight() != null) {
            measurement.append(" Height : ").append(advertisementPermitDetail.getTotalHeight());
        }
        reportParams.put("measurement", measurement.toString());
    }

    private Map<String, Object> buildParametersForDemandDetails(AdvertisementPermitDetail advertisementPermitDetail) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        BigDecimal curntInsAdvertisement = BigDecimal.ZERO;
        BigDecimal curntInsEncrocFee = BigDecimal.ZERO;
        BigDecimal curntInsPenaltyFee = BigDecimal.ZERO;
        BigDecimal curntInsServiceTax = BigDecimal.ZERO;
        BigDecimal curntInsSwachBharatCess = BigDecimal.ZERO;
        BigDecimal curntInsKrishiKalyanCess = BigDecimal.ZERO;
        BigDecimal curntInsTotalTaxableAmt = BigDecimal.ZERO;
        BigDecimal arrInsAdvertisement = BigDecimal.ZERO;
        BigDecimal arrInsEncrocFee = BigDecimal.ZERO;
        BigDecimal arrInsPenaltyFee = BigDecimal.ZERO;
        BigDecimal arrInsServiceTax = BigDecimal.ZERO;
        BigDecimal arrInsSwachBharatCess = BigDecimal.ZERO;
        BigDecimal arrInsKrishiKalyanCess = BigDecimal.ZERO;
        BigDecimal arrInsTotalTaxableAmt = BigDecimal.ZERO;
        String previousInstallmentDesc = null;
        Installment currentInstallemnt = advertisementPermitDetail.getAdvertisement().getDemandId().getEgInstallmentMaster();
        List<Installment> previousInstallemnt = this.advertisementDemandService.getPreviousInstallment(currentInstallemnt.getFromDate());
        Map<Installment, BigDecimal> penaltyAmountMap = this.advertisementPenaltyCalculator.getPenaltyByInstallment(advertisementPermitDetail);
        HashMap<String, BigDecimal> additionalTaxes = new HashMap<String, BigDecimal>();
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        if (previousInstallemnt.isEmpty()) {
            String currentFinYear = currentInstallemnt.getFinYearRange();
            String[] stringArray = currentFinYear.split("-");
            Integer from = Integer.parseInt(stringArray[0]) - 1;
            Integer to = Integer.parseInt(stringArray[1]) - 1;
            previousInstallmentDesc = from.toString() + "-" + to.toString();
        }
        for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
            additionalTaxes.put(advertisementAdditionalTaxRate.getReasonCode(), advertisementAdditionalTaxRate.getPercentage());
        }
        for (EgDemandDetails egDemandDetails : advertisementPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
            if (egDemandDetails.getBalance().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (currentInstallemnt != null && currentInstallemnt.getDescription().equals(egDemandDetails.getEgDemandReason().getEgInstallmentMaster().getDescription())) {
                if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax")) {
                    arrInsAdvertisement = arrInsAdvertisement.add(egDemandDetails.getBalance());
                    arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                    continue;
                }
                if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Advertisemnt_Tax")) {
                    curntInsAdvertisement = curntInsAdvertisement.add(egDemandDetails.getBalance());
                    reportParams.put("curntInsAdvertisement", curntInsAdvertisement.setScale(2, 6));
                    curntInsTotalTaxableAmt = curntInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                    continue;
                }
                if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Enchroachmnt_Fee")) {
                    curntInsEncrocFee = egDemandDetails.getBalance();
                    reportParams.put("curntInsEncrocFee", curntInsEncrocFee.setScale(2, 6));
                    curntInsTotalTaxableAmt = curntInsTotalTaxableAmt.add(curntInsEncrocFee);
                    continue;
                }
                if (!egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Penalty")) continue;
                curntInsPenaltyFee = egDemandDetails.getBalance();
                reportParams.put("curntInsPenaltyFee", curntInsPenaltyFee.setScale(2, 6));
                continue;
            }
            if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Arrear_Adv_Tax") || egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Advertisemnt_Tax")) {
                arrInsAdvertisement = arrInsAdvertisement.add(egDemandDetails.getBalance());
                reportParams.put("arrInsAdvertisement", arrInsAdvertisement.setScale(2, 6));
                arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                continue;
            }
            if (egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Enchroachmnt_Fee")) {
                arrInsEncrocFee = arrInsEncrocFee.add(egDemandDetails.getBalance());
                reportParams.put("arrInsEncrocFee", arrInsEncrocFee.setScale(2, 6));
                arrInsTotalTaxableAmt = arrInsTotalTaxableAmt.add(egDemandDetails.getBalance());
                continue;
            }
            if (!egDemandDetails.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("Penalty")) continue;
            arrInsPenaltyFee = arrInsPenaltyFee.add(egDemandDetails.getBalance());
            reportParams.put("arrInsPenaltyFee", arrInsPenaltyFee.setScale(2, 6));
        }
        for (Map.Entry entry : penaltyAmountMap.entrySet()) {
            if (currentInstallemnt != null && currentInstallemnt.getDescription().equalsIgnoreCase(((Installment)entry.getKey()).getDescription())) {
                curntInsPenaltyFee = curntInsPenaltyFee.add((BigDecimal)entry.getValue());
                reportParams.put("curntInsPenaltyFee", curntInsPenaltyFee);
                continue;
            }
            arrInsPenaltyFee = arrInsPenaltyFee.add((BigDecimal)entry.getValue());
            reportParams.put("arrInsPenaltyFee", arrInsPenaltyFee);
        }
        for (Map.Entry entry : additionalTaxes.entrySet()) {
            if ("Service_Tax".equalsIgnoreCase((String)entry.getKey())) {
                curntInsServiceTax = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                arrInsServiceTax = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                continue;
            }
            if ("ADTAX_SB_CESS".equalsIgnoreCase((String)entry.getKey())) {
                curntInsSwachBharatCess = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                arrInsSwachBharatCess = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
                continue;
            }
            if (!"ADTAX_KRISHI_CES".equalsIgnoreCase((String)entry.getKey())) continue;
            curntInsKrishiKalyanCess = this.calculateAdditionalTaxes(curntInsTotalTaxableAmt, (BigDecimal)entry.getValue());
            arrInsKrishiKalyanCess = this.calculateAdditionalTaxes(arrInsTotalTaxableAmt, (BigDecimal)entry.getValue());
        }
        reportParams.put("currentInstallmentDesc", currentInstallemnt.getDescription());
        reportParams.put("previousInstallmentDesc", previousInstallemnt.isEmpty() ? previousInstallmentDesc : previousInstallemnt.get(0).getDescription());
        reportParams.put("curntInsServiceTax", curntInsServiceTax.setScale(2, 6));
        reportParams.put("curntInsKrishiKalyanCess", curntInsKrishiKalyanCess.setScale(2, 6));
        reportParams.put("curntInsSwachBharatCess", curntInsSwachBharatCess.setScale(2, 6));
        reportParams.put("arrInsServiceTax", arrInsServiceTax.setScale(2, 6));
        reportParams.put("arrInsSwachBharatCess", arrInsSwachBharatCess.setScale(2, 6));
        reportParams.put("arrInsKrishiKalyanCess", arrInsKrishiKalyanCess.setScale(2, 6));
        reportParams.put("curntInsTotalTaxableAmt", curntInsTotalTaxableAmt.setScale(2, 6));
        reportParams.put("arrInsTotalTaxableAmt", arrInsTotalTaxableAmt.setScale(2, 6));
        BigDecimal curntInsGrossTotal = curntInsTotalTaxableAmt.add(curntInsServiceTax).add(curntInsSwachBharatCess).add(curntInsKrishiKalyanCess);
        reportParams.put("curntInsGrossTotal", curntInsGrossTotal.setScale(2, 6));
        BigDecimal curntInsNetTotal = curntInsGrossTotal.add(curntInsPenaltyFee);
        reportParams.put("curntInsNetTotal", curntInsNetTotal.setScale(2, 6));
        BigDecimal arrInsGrossTotal = arrInsTotalTaxableAmt.add(arrInsServiceTax).add(arrInsSwachBharatCess).add(arrInsKrishiKalyanCess);
        reportParams.put("arrInsGrossTotal", arrInsGrossTotal.setScale(2, 6));
        BigDecimal arrInsNetTotal = arrInsGrossTotal.add(arrInsPenaltyFee);
        reportParams.put("arrInsNetTotal", arrInsNetTotal.setScale(2, 6));
        reportParams.put("advertisementTaxSum", curntInsAdvertisement.add(arrInsAdvertisement).setScale(2, 6));
        reportParams.put("encrochmentFeeSum", curntInsEncrocFee.add(arrInsEncrocFee).setScale(2, 6));
        reportParams.put("serviceTaxSum", curntInsServiceTax.add(arrInsServiceTax).setScale(0, 4));
        reportParams.put("swachBharatCessSum", curntInsSwachBharatCess.add(arrInsSwachBharatCess).setScale(0, 4));
        reportParams.put("krishiKalyanCessSum", curntInsKrishiKalyanCess.add(arrInsKrishiKalyanCess).setScale(0, 4));
        reportParams.put("penalitySum", curntInsPenaltyFee.add(arrInsPenaltyFee).setScale(2, 6));
        reportParams.put("adParticular", advertisementPermitDetail.getAdvertisementParticular());
        reportParams.put("durationOfAdvt", (Object)advertisementPermitDetail.getAdvertisementDuration());
        reportParams.put("class", advertisementPermitDetail.getAdvertisement().getRateClass().getDescription());
        reportParams.put("revenueWard", advertisementPermitDetail.getAdvertisement().getWard().getName());
        reportParams.put("electionWard", advertisementPermitDetail.getAdvertisement().getElectionWard() != null ? advertisementPermitDetail.getAdvertisement().getElectionWard().getName() : "");
        return reportParams;
    }

    private BigDecimal calculateAdditionalTaxes(BigDecimal curntInsTotalTaxableAmt, BigDecimal entry) {
        return entry.multiply(curntInsTotalTaxableAmt).divide(BigDecimal.valueOf(100L)).setScale(0, 4);
    }

    private String getCityGrade() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getGrade();
    }

    private Map<String, Object> buildParametersForReport(AdvertisementPermitDetail advertisementPermitDetail) {
        StringBuilder measurement = new StringBuilder();
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        String notMentioned = "Not Mentioned ";
        reportParams.put("advertisementtitle", WordUtils.capitalize((String)"Advertisement Demand Notice"));
        reportParams.put("advertisementnumber", advertisementPermitDetail.getAdvertisement().getAdvertisementNumber());
        reportParams.put("permitNumber", advertisementPermitDetail.getPermissionNumber());
        reportParams.put("applicationNumber", advertisementPermitDetail.getApplicationNumber());
        if (advertisementPermitDetail.getAgency() != null && StringUtils.isNotBlank((CharSequence)advertisementPermitDetail.getOwnerDetail())) {
            reportParams.put(AGENCYNAME, advertisementPermitDetail.getAgency().getName() + "/" + advertisementPermitDetail.getOwnerDetail());
            reportParams.put(AGENCYADDRESS, advertisementPermitDetail.getAgency().getAddress());
        } else if (advertisementPermitDetail.getAgency() != null && StringUtils.isBlank((CharSequence)advertisementPermitDetail.getOwnerDetail())) {
            reportParams.put(AGENCYNAME, advertisementPermitDetail.getAgency().getName());
            reportParams.put(AGENCYADDRESS, StringUtils.defaultIfBlank((CharSequence)advertisementPermitDetail.getAgency().getAddress(), (CharSequence)notMentioned));
        } else {
            reportParams.put(AGENCYNAME, advertisementPermitDetail.getOwnerDetail());
            reportParams.put(AGENCYADDRESS, notMentioned);
        }
        reportParams.put("address", advertisementPermitDetail.getAdvertisement().getAddress());
        reportParams.put("applicationDate", DateUtils.getDefaultFormattedDate((Date)advertisementPermitDetail.getApplicationDate()));
        reportParams.put("category", advertisementPermitDetail.getAdvertisement().getCategory().getName());
        reportParams.put("subjectMatter", advertisementPermitDetail.getAdvertisementParticular());
        reportParams.put("subCategory", advertisementPermitDetail.getAdvertisement().getSubCategory().getCode());
        this.buildMeasurementDetailsForJasper(advertisementPermitDetail, measurement, reportParams, notMentioned);
        reportParams.put("permitStartDate", DateUtils.getDefaultFormattedDate((Date)advertisementPermitDetail.getPermissionstartdate()));
        reportParams.put("permitEndDate", DateUtils.getDefaultFormattedDate((Date)advertisementPermitDetail.getPermissionenddate()));
        reportParams.put("currdate", DateUtils.getDefaultFormattedDate((Date)new Date()));
        reportParams.put("lastPaymentPaidYear", this.advertisementDemandService.getLastPaymentPaidFinYear(advertisementPermitDetail.getAdvertisement()));
        return reportParams;
    }
}

