/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import org.egov.adtax.service.collection.AdvertisementTaxCollection;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.commons.CChartOfAccounts;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdtaxExternalService {
    @Autowired
    private AdvertisementTaxCollection advertisementTaxCollection;

    public BillInfoImpl prepareBillInfo(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, EgBill bill, String source) {
        BillInfoImpl billInfoImpl = this.initialiseFromBill(amountPaid, collType, bill);
        ArrayList<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>(0);
        ArrayList billDetails = new ArrayList(bill.getEgBillDetails());
        Collections.sort(billDetails);
        for (EgBillDetails billDet : billDetails) {
            receiptDetails.add(this.initReceiptDetail(billDet.getGlcode(), BigDecimal.ZERO, billDet.getCrAmount(), billDet.getDrAmount(), billDet.getDescription()));
        }
        Boolean isActualDemand = false;
        this.advertisementTaxCollection.apportionPaidAmount(String.valueOf(bill.getId()), amountPaid, receiptDetails);
        block1: for (EgBillDetails billDet : bill.getEgBillDetails()) {
            for (ReceiptDetail rd : receiptDetails) {
                if (!billDet.getGlcode().equals(rd.getAccounthead().getGlcode()) || !billDet.getDescription().equals(rd.getDescription())) continue;
                isActualDemand = billDet.getAdditionalFlag() == 1;
                BillAccountDetails billAccDetails = new BillAccountDetails(billDet.getGlcode(), billDet.getOrderNo(), rd.getCramount(), rd.getDramount(), billDet.getFunctionCode(), billDet.getDescription(), isActualDemand, BillAccountDetails.PURPOSE.valueOf((String)billDet.getPurpose()));
                ((BillDetails)((BillPayeeDetails)billInfoImpl.getPayees().get(0)).getBillDetails().get(0)).addBillAccountDetails(billAccDetails);
                continue block1;
            }
        }
        billInfoImpl.setTransactionReferenceNumber(bill.getTransanctionReferenceNumber());
        billInfoImpl.setSource(source);
        return billInfoImpl;
    }

    private BillInfoImpl initialiseFromBill(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, EgBill bill) {
        String[] collModes;
        BillInfoImpl billInfoImpl = null;
        BillPayeeDetails billPayeeDet = null;
        ArrayList<BillPayeeDetails> billPayeeDetList = new ArrayList<BillPayeeDetails>(0);
        ArrayList<String> collModesList = new ArrayList<String>();
        for (String coll : collModes = bill.getCollModesNotAllowed().split(",")) {
            collModesList.add(coll);
        }
        billInfoImpl = new BillInfoImpl(bill.getServiceCode(), bill.getFundCode(), bill.getFunctionaryCode(), bill.getFundSourceCode(), bill.getDepartmentCode(), "Advertisement Tax Collection", bill.getCitizenName(), bill.getPartPaymentAllowed(), bill.getOverrideAccountHeadsAllowed(), collModesList, collType);
        billPayeeDet = new BillPayeeDetails(bill.getCitizenName(), bill.getCitizenAddress(), bill.getEmailId());
        BillDetails billDetails = new BillDetails(bill.getId().toString(), bill.getCreateDate(), bill.getConsumerId(), bill.getConsumerType(), bill.getBoundaryNum().toString(), bill.getBoundaryType(), bill.getDescription(), amountPaid, bill.getMinAmtPayable());
        billPayeeDet.addBillDetails(billDetails);
        billPayeeDetList.add(billPayeeDet);
        billInfoImpl.setPayees(billPayeeDetList);
        return billInfoImpl;
    }

    private ReceiptDetail initReceiptDetail(String glCode, BigDecimal crAmount, BigDecimal crAmountToBePaid, BigDecimal drAmount, String description) {
        ReceiptDetail receiptDetail = new ReceiptDetail();
        CChartOfAccounts accountHead = new CChartOfAccounts();
        accountHead.setGlcode(glCode);
        receiptDetail.setAccounthead(accountHead);
        receiptDetail.setDescription(description);
        receiptDetail.setCramount(crAmount);
        receiptDetail.setCramountToBePaid(crAmountToBePaid);
        receiptDetail.setDramount(drAmount);
        return receiptDetail;
    }
}

