/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.List;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.AdvertisementReassignDetails;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReassignAdvertisementService {
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public String getStateObject(AdvertisementReassignDetails advertisementReassignDetails, Position position) {
        return this.updateAdtaxPermitDetails(advertisementReassignDetails, position);
    }

    private String updateAdtaxPermitDetails(AdvertisementReassignDetails advertisementReassignDetails, Position position) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(advertisementReassignDetails.getApplicationId());
        advertisementPermitDetail.changeProcessInitiator((OwnerGroup)position);
        advertisementPermitDetail.changeProcessOwner((OwnerGroup)position);
        this.advertisementPermitDetailService.updateAdvertisementPermitDetail(advertisementPermitDetail);
        return advertisementPermitDetail.getApplicationNumber();
    }

    public boolean isReassignEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "REASSIGN_BUTTONENABLED_ADTAX");
        return !appConfigValues.isEmpty() && "YES".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }
}

