/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.repository;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.repository.AdvertisementPermitDetailRepositoryCustom;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.infra.utils.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;

public class AdvertisementPermitDetailRepositoryImpl
implements AdvertisementPermitDetailRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<AdvertisementPermitDetail> searchAdvertisementPermitDetailLike(HoardingSearch hoardingSearch, String hoardingType) {
        Criteria hoardingCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(AdvertisementPermitDetail.class, "permit");
        hoardingCriteria.createAlias("permit.advertisement", "advertisement");
        if (hoardingType != null && hoardingType.equalsIgnoreCase("searchLegacyRecord")) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.legacy", (Object)Boolean.TRUE));
            hoardingCriteria.add(Restrictions.isNull((String)"previousapplicationid"));
        }
        if (hoardingSearch.getAgency() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"agency.id", (Object)hoardingSearch.getAgency()));
        }
        if (StringUtils.isNotBlank((CharSequence)hoardingSearch.getAdvertisementNumber())) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.advertisementNumber", (Object)hoardingSearch.getAdvertisementNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)hoardingSearch.getApplicationNumber())) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"applicationNumber", (Object)hoardingSearch.getApplicationNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)hoardingSearch.getPermissionNumber())) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"permissionNumber", (Object)hoardingSearch.getPermissionNumber()));
        }
        if (hoardingSearch.getAdminBoundryParent() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.locality.id", (Object)hoardingSearch.getAdminBoundryParent()));
        }
        if (hoardingSearch.getAdminBoundry() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.ward.id", (Object)hoardingSearch.getAdminBoundry()));
        }
        if (hoardingSearch.getCategory() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.category.id", (Object)hoardingSearch.getCategory()));
        }
        if (hoardingSearch.getSubCategory() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.subCategory.id", (Object)hoardingSearch.getSubCategory()));
        }
        if (hoardingSearch.getRevenueInspector() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.revenueInspector.id", (Object)hoardingSearch.getRevenueInspector()));
        }
        if (null != hoardingSearch.getStatus() && !hoardingSearch.getStatus().equals((Object)AdvertisementStatus.ACTIVE)) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)hoardingSearch.getStatus())));
        } else {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)AdvertisementStatus.ACTIVE)));
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"permit.isActive", (Object)Boolean.TRUE));
        }
        if (hoardingSearch.getApplicationFromDate() != null) {
            hoardingCriteria.add((Criterion)Restrictions.ge((String)"applicationDate", (Object)DateUtils.startOfDay((Date)hoardingSearch.getApplicationFromDate())));
        }
        if (hoardingSearch.getApplicationToDate() != null) {
            hoardingCriteria.add((Criterion)Restrictions.le((String)"applicationDate", (Object)DateUtils.endOfDay((Date)hoardingSearch.getApplicationToDate())));
        }
        if (hoardingSearch.getOwnerDetail() != null) {
            hoardingCriteria.add(Restrictions.ilike((String)"ownerDetail", (String)hoardingSearch.getOwnerDetail(), (MatchMode)MatchMode.ANYWHERE));
        }
        return hoardingCriteria.list();
    }

    @Override
    public List<AdvertisementPermitDetail> searchAdvertisementPermitDetailBySearchParams(AdvertisementPermitDetail advertisementPermitDetail) {
        Criteria hoardingCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(AdvertisementPermitDetail.class, "permit").createAlias("permit.advertisement", "advertisement").createAlias("advertisement.category", "category").createAlias("advertisement.subCategory", "subCategory").createAlias("advertisement.revenueInspector", "revenueInspector");
        if (advertisementPermitDetail.getAdvertisement() != null) {
            if (advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getAdvertisementNumber() != null && !advertisementPermitDetail.getAdvertisement().getAdvertisementNumber().isEmpty()) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.advertisementNumber", (Object)advertisementPermitDetail.getAdvertisement().getAdvertisementNumber()));
            }
            if (advertisementPermitDetail.getAdvertisement().getLocality() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.locality.id", (Object)advertisementPermitDetail.getAdvertisement().getLocality().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getWard() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.ward.id", (Object)advertisementPermitDetail.getAdvertisement().getWard().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getCategory() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.category.id", (Object)advertisementPermitDetail.getAdvertisement().getCategory().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getSubCategory() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.subCategory.id", (Object)advertisementPermitDetail.getAdvertisement().getSubCategory().getId()));
            }
            if (advertisementPermitDetail.getAgency() != null && advertisementPermitDetail.getAgency().getId() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"agency.id", (Object)advertisementPermitDetail.getAgency().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getStatus() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)advertisementPermitDetail.getAdvertisement().getStatus())));
            } else {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)AdvertisementStatus.ACTIVE)));
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)true));
            }
            if (advertisementPermitDetail.getAdvertisement().getRevenueInspector() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.revenueInspector.id", (Object)advertisementPermitDetail.getAdvertisement().getRevenueInspector().getId()));
            }
            if (advertisementPermitDetail.getOwnerDetail() != null) {
                hoardingCriteria.add(Restrictions.ilike((String)"ownerDetail", (String)advertisementPermitDetail.getOwnerDetail(), (MatchMode)MatchMode.ANYWHERE));
            }
        }
        return hoardingCriteria.list();
    }

    @Override
    public List<AdvertisementPermitDetail> searchActiveAdvertisementPermitDetailBySearchParams(AdvertisementPermitDetail advertisementPermitDetail) {
        Criteria hoardingCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(AdvertisementPermitDetail.class, "permit").createAlias("permit.advertisement", "advertisement").createAlias("advertisement.category", "category").createAlias("advertisement.subCategory", "subCategory").createAlias("advertisement.revenueInspector", "revenueInspector");
        if (advertisementPermitDetail.getAdvertisement() != null) {
            if (advertisementPermitDetail.getAdvertisement() != null && advertisementPermitDetail.getAdvertisement().getAdvertisementNumber() != null && !advertisementPermitDetail.getAdvertisement().getAdvertisementNumber().isEmpty()) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.advertisementNumber", (Object)advertisementPermitDetail.getAdvertisement().getAdvertisementNumber()));
            }
            if (advertisementPermitDetail.getAdvertisement().getLocality() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.locality.id", (Object)advertisementPermitDetail.getAdvertisement().getLocality().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getWard() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.ward.id", (Object)advertisementPermitDetail.getAdvertisement().getWard().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getCategory() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.category.id", (Object)advertisementPermitDetail.getAdvertisement().getCategory().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getSubCategory() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.subCategory.id", (Object)advertisementPermitDetail.getAdvertisement().getSubCategory().getId()));
            }
            if (advertisementPermitDetail.getAgency() != null && advertisementPermitDetail.getAgency().getId() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"agency.id", (Object)advertisementPermitDetail.getAgency().getId()));
            }
            if (advertisementPermitDetail.getAdvertisement().getRevenueInspector() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.revenueInspector.id", (Object)advertisementPermitDetail.getAdvertisement().getRevenueInspector().getId()));
            }
            if (advertisementPermitDetail.getOwnerDetail() != null) {
                hoardingCriteria.add(Restrictions.ilike((String)"ownerDetail", (String)advertisementPermitDetail.getOwnerDetail(), (MatchMode)MatchMode.ANYWHERE));
            }
            if (advertisementPermitDetail.getAdvertisement().getStatus() != null) {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)advertisementPermitDetail.getAdvertisement().getStatus())));
            } else {
                hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)AdvertisementStatus.ACTIVE)));
            }
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)true));
        }
        return hoardingCriteria.list();
    }
}

