/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.entity;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.Agency;
import org.egov.adtax.entity.UnitOfMeasure;
import org.egov.adtax.entity.enums.AdvertisementApplicationType;
import org.egov.adtax.entity.enums.AdvertisementDuration;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGADTAX_PERMITDETAILS")
@SequenceGenerator(name="SEQ_EGADTAX_PERMITDETAILS", sequenceName="SEQ_EGADTAX_PERMITDETAILS", allocationSize=1)
@Unique(fields={"applicationNumber", "permissionNumber"}, enableDfltMsg=true)
public class AdvertisementPermitDetail
extends StateAware<Position> {
    public static final String SEQ_ADTAX_APPLICATION = "SEQ_EGADTAX_PERMITDETAILS";
    private static final long serialVersionUID = 845357231248646624L;
    @Id
    @GeneratedValue(generator="SEQ_EGADTAX_PERMITDETAILS", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="advertisement", nullable=false)
    private Advertisement advertisement;
    @Column(name="applicationNumber", unique=true)
    @SafeHtml
    @Length(max=25)
    private String applicationNumber;
    @Column(name="permissionNumber", unique=true)
    @SafeHtml
    @Length(max=25)
    private String permissionNumber;
    @NotNull
    private Date applicationDate;
    @Enumerated(value=EnumType.ORDINAL)
    private AdvertisementDuration advertisementDuration;
    @ManyToOne
    @JoinColumn(name="status", nullable=false)
    private EgwStatus status;
    @NotNull
    private BigDecimal taxAmount;
    private BigDecimal encroachmentFee;
    @ManyToOne
    @JoinColumn(name="previousapplicationid")
    private AdvertisementPermitDetail previousapplicationid;
    private Boolean isActive = false;
    private Date permissionstartdate;
    private Date permissionenddate;
    @SafeHtml
    @Length(max=125)
    private String ownerDetail;
    @ManyToOne
    @JoinColumn(name="agency")
    private Agency agency;
    @SafeHtml
    @Length(max=125)
    private String advertiser;
    @SafeHtml
    @Length(max=512)
    private String advertisementParticular;
    @NotNull
    @ManyToOne
    @JoinColumn(name="unitofmeasure", nullable=false)
    private UnitOfMeasure unitOfMeasure;
    private Double measurement;
    private Double length;
    private Double width;
    private Double breadth;
    private Double totalHeight;
    private String deactivation_remarks;
    private Date deactivation_date;
    private String Source;
    @Enumerated(value=EnumType.ORDINAL)
    private AdvertisementApplicationType applicationtype;
    @Transient
    private Long approvalDepartment;
    @Transient
    private String approvalComent;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getPermissionNumber() {
        return this.permissionNumber;
    }

    public void setPermissionNumber(String permissionNumber) {
        this.permissionNumber = permissionNumber;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public AdvertisementDuration getAdvertisementDuration() {
        return this.advertisementDuration;
    }

    public void setAdvertisementDuration(AdvertisementDuration advertisementDuration) {
        this.advertisementDuration = advertisementDuration;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getEncroachmentFee() {
        return this.encroachmentFee;
    }

    public void setEncroachmentFee(BigDecimal encroachmentFee) {
        this.encroachmentFee = encroachmentFee;
    }

    public AdvertisementPermitDetail getPreviousapplicationid() {
        return this.previousapplicationid;
    }

    public void setPreviousapplicationid(AdvertisementPermitDetail previousapplicationid) {
        this.previousapplicationid = previousapplicationid;
    }

    public Date getPermissionstartdate() {
        return this.permissionstartdate;
    }

    public void setPermissionstartdate(Date permissionstartdate) {
        this.permissionstartdate = permissionstartdate;
    }

    public Date getPermissionenddate() {
        return this.permissionenddate;
    }

    public void setPermissionenddate(Date permissionenddate) {
        this.permissionenddate = permissionenddate;
    }

    public Advertisement getAdvertisement() {
        return this.advertisement;
    }

    public void setAdvertisement(Advertisement advertisement) {
        this.advertisement = advertisement;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public String getOwnerDetail() {
        return this.ownerDetail;
    }

    public void setOwnerDetail(String ownerDetail) {
        this.ownerDetail = ownerDetail;
    }

    public Agency getAgency() {
        return this.agency;
    }

    public void setAgency(Agency agency) {
        this.agency = agency;
    }

    public String getAdvertiser() {
        return this.advertiser;
    }

    public void setAdvertiser(String advertiser) {
        this.advertiser = advertiser;
    }

    public String getAdvertisementParticular() {
        return this.advertisementParticular;
    }

    public void setAdvertisementParticular(String advertisementParticular) {
        this.advertisementParticular = advertisementParticular;
    }

    public UnitOfMeasure getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasure unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public Double getMeasurement() {
        return this.measurement;
    }

    public void setMeasurement(Double measurement) {
        this.measurement = measurement;
    }

    public Double getLength() {
        return this.length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    public Double getWidth() {
        return this.width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Double getBreadth() {
        return this.breadth;
    }

    public void setBreadth(Double breadth) {
        this.breadth = breadth;
    }

    public Double getTotalHeight() {
        return this.totalHeight;
    }

    public void setTotalHeight(Double totalHeight) {
        this.totalHeight = totalHeight;
    }

    public String getStateDetails() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        return String.format("Application Number %s with date %s.", this.applicationNumber, this.applicationDate != null ? formatter.format(this.applicationDate) : formatter.format(new Date()));
    }

    public Long getApprovalDepartment() {
        return this.approvalDepartment;
    }

    public void setApprovalDepartment(Long approvalDepartment) {
        this.approvalDepartment = approvalDepartment;
    }

    public String getApprovalComent() {
        return this.approvalComent;
    }

    public void setApprovalComent(String approvalComent) {
        this.approvalComent = approvalComent;
    }

    public String getDeactivation_remarks() {
        return this.deactivation_remarks;
    }

    public void setDeactivation_remarks(String deactivation_remarks) {
        this.deactivation_remarks = deactivation_remarks;
    }

    public Date getDeactivation_date() {
        return this.deactivation_date;
    }

    public void setDeactivation_date(Date deactivation_date) {
        this.deactivation_date = deactivation_date;
    }

    public String getSource() {
        return this.Source;
    }

    public void setSource(String source) {
        this.Source = source;
    }

    public AdvertisementApplicationType getApplicationtype() {
        return this.applicationtype;
    }

    public void setApplicationtype(AdvertisementApplicationType applicationtype) {
        this.applicationtype = applicationtype;
    }
}

