/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.collection;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.collection.AdvertisementBillable;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.commons.Installment;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementBillServiceImpl
extends BillServiceInterface {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AdvertisementPenaltyCalculator advertisementPenaltyCalculator;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetailList = new ArrayList<EgBillDetails>();
        int orderNo = 1;
        AdvertisementBillable advBillable = (AdvertisementBillable)billObj;
        EgDemand dmd = advBillable.getCurrentDemand();
        ArrayList details = new ArrayList(dmd.getEgDemandDetails());
        BigDecimal totalTaxableAmount = BigDecimal.ZERO;
        if (!details.isEmpty()) {
            Collections.sort(details, (c1, c2) -> c1.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster().compareTo(c2.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()));
        }
        HashMap<String, BigDecimal> additionalTaxes = new HashMap<String, BigDecimal>();
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        for (AdvertisementAdditionalTaxRate taxRates : additionalTaxRates) {
            additionalTaxes.put(taxRates.getReasonCode(), taxRates.getPercentage());
        }
        for (EgDemandDetails demandDetail : details) {
            if (demandDetail.getAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal creaditAmt = BigDecimal.ZERO;
            creaditAmt = demandDetail.getAmount().subtract(demandDetail.getAmtCollected());
            if (creaditAmt.compareTo(BigDecimal.ZERO) <= 0 || "Penalty".equalsIgnoreCase(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster()) && additionalTaxes.containsKey(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode())) continue;
            totalTaxableAmount = totalTaxableAmount.add(creaditAmt);
            EgBillDetails egBillDetails = this.createBillDetailObject(orderNo, BigDecimal.ZERO, creaditAmt, demandDetail.getEgDemandReason().getGlcodeId().getGlcode(), this.getReceiptDetailDescription(demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), demandDetail.getEgDemandReason().getEgInstallmentMaster()));
            ++orderNo;
            billDetailList.add(egBillDetails);
        }
        Map<Installment, BigDecimal> penaltyReasons = this.advertisementPenaltyCalculator.getPenaltyOnAdditionalTaxByInstallment(advBillable.getAdvertisement().getActiveAdvertisementPermit());
        if (penaltyReasons != null && penaltyReasons.size() > 0) {
            BigDecimal penaltyAmount = BigDecimal.ZERO;
            for (Map.Entry entry : penaltyReasons.entrySet()) {
                penaltyAmount = (BigDecimal)entry.getValue();
                if (penaltyAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                orderNo = this.prepareBillDetails(billDetailList, orderNo, dmd, penaltyAmount, (Installment)entry.getKey(), "Penalty");
            }
        }
        if (this.serviceTaxAndCessCalculationRequired().booleanValue()) {
            Installment currentInstallment = this.advertisementDemandService.getCurrentInstallment();
            for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
                if (advertisementAdditionalTaxRate.getPercentage().compareTo(BigDecimal.ZERO) <= 0) continue;
                orderNo = this.prepareBillDetails(billDetailList, orderNo, dmd, totalTaxableAmount.multiply(advertisementAdditionalTaxRate.getPercentage()).divide(BigDecimal.valueOf(100L)).setScale(0, 4), currentInstallment, advertisementAdditionalTaxRate.getReasonCode());
            }
        }
        return billDetailList;
    }

    private int prepareBillDetails(List<EgBillDetails> billDetailList, int orderNo, EgDemand dmd, BigDecimal amount, Installment installment, String demandReasonCode) {
        EgDemandReason pendingTaxReason = this.advertisementDemandService.getDemandReasonByCodeAndInstallment(demandReasonCode, installment);
        if (pendingTaxReason != null) {
            List<EgDemandDetails> demandDetail = this.advertisementDemandService.getDemandDetailByPassingDemandDemandReason(dmd, pendingTaxReason);
            if (demandDetail != null && demandDetail.size() > 0) {
                EgDemandDetails existingDemandDetail = demandDetail.get(0);
                BigDecimal creaditAmt = existingDemandDetail.getAmount().subtract(existingDemandDetail.getAmtCollected());
                EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, creaditAmt.add(amount), existingDemandDetail.getEgDemandReason().getGlcodeId().getGlcode(), this.getReceiptDetailDescription(existingDemandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster(), existingDemandDetail.getEgDemandReason().getEgInstallmentMaster()));
                ++orderNo;
                billDetailList.add(billdetail);
            } else {
                EgBillDetails billdetail = this.createBillDetailObject(orderNo, BigDecimal.ZERO, amount, pendingTaxReason.getGlcodeId().getGlcode(), this.getReceiptDetailDescription(pendingTaxReason.getEgDemandReasonMaster().getReasonMaster(), pendingTaxReason.getEgInstallmentMaster()));
                ++orderNo;
                billDetailList.add(billdetail);
            }
        }
        return orderNo;
    }

    private String getReceiptDetailDescription(String reasonType, Installment instlment) {
        List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
        ArrayList<String> taxTypeList = new ArrayList<String>();
        for (AdvertisementAdditionalTaxRate advertisementAdditionalTaxRate : additionalTaxRates) {
            if (advertisementAdditionalTaxRate == null) continue;
            taxTypeList.add(advertisementAdditionalTaxRate.getTaxType());
        }
        if (!taxTypeList.isEmpty() && taxTypeList.contains(reasonType)) {
            return reasonType + " " + "Collection";
        }
        return reasonType + " " + "Collection" + (instlment != null ? " " + instlment.getDescription() : "");
    }

    private EgBillDetails createBillDetailObject(int orderNo, BigDecimal debitAmount, BigDecimal creditAmount, String glCodeForDemandDetail, String description) {
        EgBillDetails billdetail = new EgBillDetails();
        billdetail.setFunctionCode("9300");
        billdetail.setOrderNo(Integer.valueOf(orderNo));
        billdetail.setCreateDate(new Date());
        billdetail.setModifiedDate(new Date());
        billdetail.setCrAmount(creditAmount);
        billdetail.setDrAmount(debitAmount);
        billdetail.setGlcode(glCodeForDemandDetail);
        billdetail.setDescription(description);
        billdetail.setAdditionalFlag(Integer.valueOf(1));
        billdetail.setPurpose(BillAccountDetails.PURPOSE.OTHERS.toString());
        return billdetail;
    }

    public void cancelBill() {
    }

    public String getBillXML(Billable billObj) {
        String collectXML;
        try {
            collectXML = URLEncoder.encode(super.getBillXML(billObj), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        return collectXML;
    }

    private Boolean serviceTaxAndCessCalculationRequired() {
        AppConfigValues isServiceTaxAndCessCollectionRequired = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "Service Tax And Cess Collection required").get(0);
        if (isServiceTaxAndCessCollectionRequired != null && "YES".equalsIgnoreCase(isServiceTaxAndCessCollectionRequired.getValue())) {
            return true;
        }
        return false;
    }
}

