/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.repository.AdvertisementRepository;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemand;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementService {
    @Autowired
    private AdvertisementRepository advertisementRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    protected CollectionIntegrationService collectionIntegrationService;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource advertisementMessageSource;
    @Autowired
    private ReportService reportService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public Advertisement createAdvertisement(Advertisement hoarding) {
        if (hoarding != null && hoarding.getId() == null) {
            hoarding.setDemandId(this.advertisementDemandService.createDemand(hoarding));
        }
        this.roundOfAllTaxAmount(hoarding);
        return (Advertisement)((Object)this.advertisementRepository.save((Object)hoarding));
    }

    public Advertisement updateAdvertisement(Advertisement advertisement) {
        return (Advertisement)((Object)this.advertisementRepository.saveAndFlush((Object)advertisement));
    }

    private void roundOfAllTaxAmount(Advertisement hoarding) {
    }

    public List<Object[]> searchBySearchType(Advertisement hoarding, String searchType) {
        return this.advertisementRepository.fetchAdvertisementBySearchType(hoarding, searchType);
    }

    public int getActivePermanentAdvertisementsByCurrentInstallment(Installment installment) {
        return this.advertisementRepository.findActivePermanentAdvertisementsByCurrentInstallment(installment);
    }

    @Transactional
    public List<Advertisement> findActivePermanentAdvertisementsByCurrentInstallmentAndNumberOfResultToFetch(Installment installment, int noOfResultToFetch) {
        return this.advertisementRepository.findActivePermanentAdvertisementsByCurrentInstallmentAndNumberOfResultToFetch(installment, noOfResultToFetch);
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRES_NEW)
    public Advertisement getHoardingByAdvertisementNumber(String hoardingNumber) {
        return this.advertisementRepository.findByAdvertisementNumber(hoardingNumber);
    }

    public Advertisement findByAdvertisementNumber(String hoardingNumber) {
        return this.advertisementRepository.findByAdvertisementNumber(hoardingNumber);
    }

    public Advertisement findBy(Long hoardingId) {
        return (Advertisement)((Object)this.advertisementRepository.findOne(hoardingId));
    }

    public Advertisement getAdvertisementByDemand(EgDemand demand) {
        return this.advertisementRepository.findByDemandId(demand);
    }

    public ReportOutput getReportParamsForAcknowdgement(AdvertisementPermitDetail permitDetail, String municipalityName, String cityName) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("municipality", municipalityName);
        reportParams.put("cityname", cityName);
        reportParams.put("wardName", permitDetail.getAdvertisement().getElectionWard().getName());
        String applicantName = permitDetail.getAgency() != null && permitDetail.getAgency().getName() != null && permitDetail.getAdvertiser() != null ? permitDetail.getAgency().getName().concat(" / ").concat(permitDetail.getOwnerDetail()) : (permitDetail.getOwnerDetail() == null ? permitDetail.getAgency().getName() : permitDetail.getOwnerDetail());
        reportParams.put("applicantName", applicantName);
        reportParams.put("acknowledgementNo", permitDetail.getApplicationNumber());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        reportParams.put("currentDate", formatter.format(new Date()));
        reportParams.put("licenceAddress", permitDetail.getAdvertisement().getAddress());
        reportParams.put("dueDate", formatter.format(this.calculateDueDate(permitDetail)));
        reportParams.put("Party's Copy", "Party's Copy");
        reportParams.put("Office's Copy", "Office's Copy");
        reportParams.put("ApplicationCentre", this.advertisementMessageSource.getMessage("msg.application.centre", (Object[])new String[0], Locale.getDefault()));
        reportParams.put("appType", permitDetail.getPreviousapplicationid() == null ? "New Advertisement" : "Renewal Advertisement");
        ReportRequest reportInput = new ReportRequest("adtax_hoarding_acknowledgement", (Object)permitDetail, reportParams);
        return this.reportService.createReport(reportInput);
    }

    public Date calculateDueDate(AdvertisementPermitDetail permitDetail) {
        Date currentDate = new Date();
        String slaNewAdvertisement = this.advertisementMessageSource.getMessage("msg.newAdvertisement.sla", (Object[])new String[0], Locale.getDefault());
        String slaRenewAdvertisement = this.advertisementMessageSource.getMessage("msg.renewAdvertisement.sla", (Object[])new String[0], Locale.getDefault());
        Date dueDate = permitDetail.getPreviousapplicationid() == null ? DateUtils.addDays((Date)currentDate, (int)Integer.parseInt(slaNewAdvertisement)) : DateUtils.addDays((Date)currentDate, (int)Integer.parseInt(slaRenewAdvertisement));
        return dueDate;
    }

    public List<Advertisement> getAdvertisement(Long wardno, String advertisementNo) {
        Criteria criteria = this.getCurrentSession().createCriteria(Advertisement.class, "advertisement");
        if (wardno != null) {
            criteria.createAlias("advertisement.ward", "ward");
            criteria.add((Criterion)Restrictions.eq((String)"ward.boundaryNum", (Object)wardno));
        }
        if (advertisementNo != null) {
            criteria.add((Criterion)Restrictions.eq((String)"advertisementNumber", (Object)advertisementNo));
        }
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)AdvertisementStatus.ACTIVE)));
        return criteria.list();
    }
}

