/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.repository;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.AgencyWiseResult;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.entity.enums.AdvertisementStructureType;
import org.egov.adtax.repository.AdvertisementRepositoryCustom;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.commons.Installment;
import org.egov.infra.utils.DateUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class AdvertisementRepositoryImpl
implements AdvertisementRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public List<Advertisement> fetchAdvertisementLike(HoardingSearch hoardingSearch) {
        Criteria hoardingCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Advertisement.class, "hoarding");
        if (hoardingSearch.getAgency() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"agency.id", (Object)hoardingSearch.getAgency()));
        }
        if (StringUtils.isNotBlank((CharSequence)hoardingSearch.getAdvertisementNumber())) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisementNumber", (Object)hoardingSearch.getAdvertisementNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)hoardingSearch.getApplicationNumber())) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"applicationNumber", (Object)hoardingSearch.getApplicationNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)hoardingSearch.getPermissionNumber())) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"permissionNumber", (Object)hoardingSearch.getPermissionNumber()));
        }
        if (hoardingSearch.getAdminBoundryParent() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"locality.id", (Object)hoardingSearch.getAdminBoundryParent()));
        }
        if (hoardingSearch.getAdminBoundry() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"ward.id", (Object)hoardingSearch.getAdminBoundry()));
        }
        if (hoardingSearch.getCategory() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"category.id", (Object)hoardingSearch.getCategory()));
        }
        if (hoardingSearch.getSubCategory() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"subCategory.id", (Object)hoardingSearch.getSubCategory()));
        }
        if (hoardingSearch.getRevenueInspector() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"revenueInspector.id", (Object)hoardingSearch.getRevenueInspector()));
        }
        if (hoardingSearch.getStatus() != null) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)hoardingSearch.getStatus())));
        }
        if (hoardingSearch.getApplicationFromDate() != null) {
            hoardingCriteria.add((Criterion)Restrictions.ge((String)"applicationDate", (Object)DateUtils.startOfDay((Date)hoardingSearch.getApplicationFromDate())));
        }
        if (hoardingSearch.getApplicationToDate() != null) {
            hoardingCriteria.add((Criterion)Restrictions.le((String)"applicationDate", (Object)DateUtils.endOfDay((Date)hoardingSearch.getApplicationToDate())));
        }
        return hoardingCriteria.list();
    }

    @Override
    public List<Object[]> fetchAdvertisementBySearchType(Advertisement hoarding, String searchType) {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(AdvertisementPermitDetail.class, "permit").createAlias("permit.advertisement", "advertisement").createAlias("advertisement.ward", "ward").createAlias("advertisement.locality", "locality").createAlias("advertisement.category", "category").createAlias("advertisement.subCategory", "subCategory").createAlias("advertisement.revenueInspector", "revenueInspector").createAlias("permit.agency", "agency");
        if ("agency".equalsIgnoreCase(searchType)) {
            criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"agency"), "agency").add(Projections.rowCount(), "count")).setResultTransformer(Transformers.aliasToBean(AgencyWiseResult.class));
        }
        if (null != hoarding.getAdvertisementNumber() && !hoarding.getAdvertisementNumber().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"hoarding.advertisementNumber", (Object)hoarding.getAdvertisementNumber()));
        }
        if (null != hoarding.getLocality()) {
            criteria.add((Criterion)Restrictions.eq((String)"locality.id", (Object)hoarding.getLocality().getId()));
        }
        if (null != hoarding.getWard()) {
            criteria.add((Criterion)Restrictions.eq((String)"ward.id", (Object)hoarding.getWard().getId()));
        }
        if (null != hoarding.getCategory()) {
            criteria.add((Criterion)Restrictions.eq((String)"category.id", (Object)hoarding.getCategory().getId()));
        }
        if (null != hoarding.getSubCategory()) {
            criteria.add((Criterion)Restrictions.eq((String)"subCategory.id", (Object)hoarding.getSubCategory().getId()));
        }
        if (null != hoarding.getStatus()) {
            criteria.add((Criterion)Restrictions.eq((String)"hoarding.status", (Object)((Object)hoarding.getStatus())));
        }
        if (null != hoarding.getRevenueInspector()) {
            criteria.add((Criterion)Restrictions.eq((String)"revenueInspector.id", (Object)hoarding.getRevenueInspector().getId()));
        }
        return criteria.list();
    }

    @Override
    public int findActivePermanentAdvertisementsByCurrentInstallment(Installment installment) {
        Criteria advtCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Advertisement.class, "advertise").createAlias("advertise.demandId", "demand");
        advtCriteria.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)AdvertisementStatus.ACTIVE)));
        advtCriteria.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)AdvertisementStructureType.PERMANENT)));
        if (installment != null) {
            advtCriteria.add((Criterion)Restrictions.eq((String)"demand.egInstallmentMaster.id", (Object)installment.getId()));
        }
        return advtCriteria.list().size();
    }

    @Override
    public List<Advertisement> findActivePermanentAdvertisementsByCurrentInstallmentAndNumberOfResultToFetch(Installment installment, int noOfResultToFetch) {
        Criteria advtCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Advertisement.class, "advertise").createAlias("advertise.demandId", "demand");
        advtCriteria.add((Criterion)Restrictions.eq((String)"advertise.status", (Object)((Object)AdvertisementStatus.ACTIVE)));
        advtCriteria.add((Criterion)Restrictions.eq((String)"advertise.type", (Object)((Object)AdvertisementStructureType.PERMANENT)));
        if (installment != null) {
            advtCriteria.add((Criterion)Restrictions.eq((String)"demand.egInstallmentMaster.id", (Object)installment.getId()));
        }
        advtCriteria.setMaxResults(noOfResultToFetch);
        advtCriteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return advtCriteria.list();
    }

    @Override
    public List<Advertisement> fetchAdvertisementBySearchParams(Advertisement hoarding) {
        Criteria hoardingCriteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(AdvertisementPermitDetail.class, "permit").createAlias("permit.advertisement", "advertisement").createAlias("advertisement.category", "category").createAlias("advertisement.subCategory", "subCategory").createAlias("advertisement.revenueInspector", "revenueInspector").createAlias("permit.agency", "agency");
        if (null != hoarding.getAdvertisementNumber() && !hoarding.getAdvertisementNumber().isEmpty()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.advertisementNumber", (Object)hoarding.getAdvertisementNumber()));
        }
        if (null != hoarding.getLocality()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"locality.id", (Object)hoarding.getLocality().getId()));
        }
        if (null != hoarding.getWard()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"ward.id", (Object)hoarding.getWard().getId()));
        }
        if (null != hoarding.getCategory()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"category.id", (Object)hoarding.getCategory().getId()));
        }
        if (null != hoarding.getSubCategory()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"subCategory.id", (Object)hoarding.getSubCategory().getId()));
        }
        if (null != hoarding.getStatus()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"advertisement.status", (Object)((Object)hoarding.getStatus())));
        }
        if (null != hoarding.getRevenueInspector()) {
            hoardingCriteria.add((Criterion)Restrictions.eq((String)"revenueInspector.id", (Object)hoarding.getRevenueInspector().getId()));
        }
        return hoardingCriteria.list();
    }
}

