/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.egov.adtax.entity.AdvertisementDemandGenerationLogDetail;
import org.egov.adtax.entity.enums.ProcessStatus;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;

@Entity
@Table(name="egadtax_demandgenerationlog")
@SequenceGenerator(name="seq_egadtax_demandgenerationlog", sequenceName="seq_egadtax_demandgenerationlog", allocationSize=1)
@Unique(fields={"installmentYear"}, enableDfltMsg=true)
public class AdvertisementDemandGenerationLog
extends AbstractAuditable {
    private static final long serialVersionUID = -2733572195063280873L;
    public static final String SEQ = "seq_egadtax_demandgenerationlog";
    @Id
    @GeneratedValue(generator="seq_egadtax_demandgenerationlog", strategy=GenerationType.SEQUENCE)
    private Long id;
    private String installmentYear;
    @Enumerated(value=EnumType.STRING)
    private ProcessStatus executionStatus;
    @Enumerated(value=EnumType.STRING)
    private ProcessStatus demandGenerationStatus;
    @OneToMany(mappedBy="demandGenerationLog", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private List<AdvertisementDemandGenerationLogDetail> details = new ArrayList<AdvertisementDemandGenerationLogDetail>();

    public AdvertisementDemandGenerationLog() {
    }

    public AdvertisementDemandGenerationLog(String installmentYear) {
        this.installmentYear = installmentYear;
        this.executionStatus = ProcessStatus.COMPLETED;
        this.demandGenerationStatus = ProcessStatus.COMPLETED;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getInstallmentYear() {
        return this.installmentYear;
    }

    public void setInstallmentYear(String installmentYear) {
        this.installmentYear = installmentYear;
    }

    public ProcessStatus getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(ProcessStatus executionStatus) {
        this.executionStatus = executionStatus;
    }

    public ProcessStatus getDemandGenerationStatus() {
        return this.demandGenerationStatus;
    }

    public void setDemandGenerationStatus(ProcessStatus demandGenerationStatus) {
        this.demandGenerationStatus = demandGenerationStatus;
    }

    public List<AdvertisementDemandGenerationLogDetail> getDetails() {
        return this.details;
    }

    public void setDetails(List<AdvertisementDemandGenerationLogDetail> details) {
        this.details = details;
    }

    public void addDetails(AdvertisementDemandGenerationLogDetail logDetail) {
        this.getDetails().add(logDetail);
    }
}

